(function ($) {
	
	ThemePress.Mobile = {

        $activeTextForm: $("#mobile-comment-textform"),
		mentionMarkup: [],
		searchAdjusted: false,
		searchInFocus: false,
		
		didScroll: false,
		lastScrollTop: 0,

        // Post comment via REST API.
        addComment: function(element, commentId) {
            var jsonData = "";

            if (commentId) {
                jsonData = JSON.stringify({
                    type : "comment",
                    ancestors: [{
                        id: "" + commentId,
                        type: "comment"
                    }],
                    container : {
                        id : ThemePress.pageId,
                        type : "page",
                        status : "current"
                    },
                    body : {
                        storage : {
                            // Converts the mention markup to HTML.
                            value : ThemePress.Mobile.textToHtml($(element).find("textarea").val(), ThemePress.Mobile.mentionMarkup),
                            representation : "storage"
                        }
                    }
                });
            }
            else {
                jsonData = JSON.stringify({
                    type : "comment",
                    container : {
                        id : ThemePress.pageId,
                        type : "page",
                        status : "current"
                    },
                    body : {
                        storage : {
                            // Converts the mention markup to HTML.
                            value : ThemePress.Mobile.textToHtml($(element).find("textarea").val(), ThemePress.Mobile.mentionMarkup),
                            representation : "storage"
                        }
                    }
                });
            }

            $.ajax({
                url: Confluence.getContextPath() + '/rest/api/content',
                type: "POST",
                // To ensure that the new comment is visible on iOS.
                cache: false,
                async: false,
                contentType: "application/json; charset=UTF-8",
                data: jsonData,
                dataType: "text",
                success: function(response) {
                    var parsedResponse = JSON.parse(response);
                    // Reload page on successful post - Needs to be done with timeout because iOS
                    // does not update the value for window.location.href until the next run of the JavaScript event loop.
                    var queryString = location.search.length > 0 ? location.search.substring(1) + "&" : "";
                    setTimeout(function(){ document.location.assign(location.pathname + "?" + queryString + "focusedComment=" + parsedResponse.id + "#comment-" + parsedResponse.id);}, 250);
                    return false;
                },
                error: function(xhr, error) {
                    console.log("readyState: "+xhr.readyState+", status: "+xhr.status+", responseText" + xhr.responseText);
                }
            });
        },

		addMenuToggle: function () {
			var $menuToggle = $("#mobile-menu-toggle-button");
			if (!$menuToggle.length) {
				$menuToggle = $("<button>")
					.attr("id", "mobile-menu-toggle-button")
					.addClass("aui-button")
					.append("<span class='aui-icon aui-icon-small aui-iconfont-appswitcher'> Menu</span>");

				$menuToggle				
					.adjustClass("using-custom-menu", ThemePress.Mobile.hasCustomMenu())
					.adjustClass("using-regular-menu", !ThemePress.Mobile.hasCustomMenu());

				$(ThemePress.Mobile.hasCustomMenu() ? ".brikit-header-content" : "body").append($menuToggle);
			}
			return $menuToggle;
		},

        animate: function (selector, amount, side, complete) {
            var properties = {};
            properties[side] = amount;
            selector.stop().animate(properties, 400, complete);
        },
		
		calculateMenu: function () {

			var $topMenu = $("<ul>").addClass("top-menu aui-navgroup aui-navgroup-vertical");

			var addMenuItem = function ($sourceLink) {
				
                // Create a top level menu entry for the mobile menu.
				var $topEntry = $("<li>").addClass("aui-nav");
				var $link = $("<a>")
                    .text($sourceLink.text())
                    .attr("href", $sourceLink.attr("href"));
				$topMenu.append($topEntry.append($link));

				if (!$sourceLink.hasAttr("aria-owns")) return; 
                var id = $sourceLink.attr("href");
                var $panel = id.length > 1 ? $("#" + id) : [];
                if (!$panel.length) return;

                // Add the submenu attributes to the top level menu entry.
                $link.attr("href", "#");
                $link.addClass("mobile-toggle-submenu");
                var $caret = $("<span>")
                    .addClass("mobile-submenu-caret");
                $link.append($caret);

                // Add the submenu items to the top level menu entry.
                var $subMenu = $("<ul>").addClass("mobile-submenu");
                $panel.find("a").each(function () {
					var $candidate = $(this);
					var $containingLi = $candidate.closest("li");
					if ($containingLi.length) $candidate = $containingLi.contents();
                    $subMenu.append($("<li>").append($candidate));
                });
                $topEntry.append($subMenu);
			};
			
			if (!ThemePress.Menu.doNotConvertForMobile()) ThemePress.Menu.menu("li.top-level").each(function () {
				addMenuItem($("a", this));
			});
			
			// Add a login/logout link as appropriate
			addMenuItem($("#login-link, #logout-link").first());

			return $topMenu;
		},
		
		calculateMultiLevelMenu: function () {
			var menuCount = 1;
			
			var topLevelItem = function (item, depth) { return $(item).parents("ul").length == depth; }
			
			var addSubmenuContainers = function (item, depth) {
				var $item = $(item);
				var $submenu = $("ul", $item).first();
				if (!$submenu.length) return;

				var id = "submenu-" + menuCount

				$item.attr("href", "#" + id);
				$("> .submenu-toggle", $item).addClass("closed");
				
				$submenu.addClass("submenu").attr("id", id).hide();

				menuCount++;
				depth++;
				$("li", $submenu).filter(function () { return topLevelItem(this, depth); }).each(function () { addSubmenuContainers(this, depth); });
			};
			
			var $menu = ThemePress.Menu.menu("ul").first().addClass("mobile-submenu multi-level-menu");
			$("li", $menu)
				.prepend($("<span>").addClass("submenu-toggle"))
				.prepend($("<span>").addClass("submenu-indent"))
				.filter(function () { return topLevelItem(this, 1); }).each(function () { addSubmenuContainers(this, 1); });
				
			$menu.on("click", ".submenu-toggle.closed, .submenu-toggle.open", function (event) {
				event.preventDefault();
				var $toggle = $(this);
				var opening = $toggle.hasClass("closed");
				$toggle.toggleClass("open closed");
				$($toggle.closest("li").attr("href")).slideToggle("fast");
			});
			
			return $menu;
		},

        cancelUserDelegate: function(event) {
            $("#mobile-user-delegate-field").val("");
            ThemePress.Mobile.hideUserDelegate();

            return false;
        },

        // Retrieve the user markup from the username and update the nearest/active textbox.
		changeUserDelegate: function (username) {
            // Return when empty.
            if (username.length == 0) return false;

            var $textArea = ThemePress.Mobile.$activeTextForm;

            var cursorPosStart = $textArea.prop('selectionStart');
            var cursorPosEnd = $textArea.prop('selectionEnd');
            var v = $textArea.val();
            var textBefore = v.substring(0,  cursorPosStart );
            var textAfter  = v.substring( cursorPosEnd, v.length );

            var deferred = ThemePress.Mobile.getMentionMarkup(username, ThemePress.Mobile.mentionMarkup);

            // Using deferred here to wait for the markup retrieval to be complete before updating
            // the text form.
            $.when(deferred).done(function(){
                $textArea.val( textBefore+ ThemePress.Mobile.getMentionString() +textAfter );
            });
        },

        // Selects the clicked user from the drop down and sets it as a markup on the "nearest" text box cursor.
        changeUserDelegateDeferred: function(event) {
            // Retrieve the username from the href of the clicked option.
            var username = $(event.target).closest("a").attr("href").split("~")[1];

            ThemePress.Mobile.changeUserDelegate(username);
            ThemePress.Mobile.hideUserDelegate();
        },

        close: function (link) {
            $("body").removeClass("mobile-menu-active");
            $(".mobile-menu-slider").removeClass("mobile-menu-open");
            $('.mobile-menu').css("visibility","hidden");
            if (link) window.location = link;
        },
		
		content: function () {
			return $(".mobile .brikit-content-stack");
		},

        eventHandler: function (event, selector) {
            event.stopPropagation();
            event.preventDefault();

            // If event type was touch turn off clicks to prevent phantom clicks.
            if (event.type === 'touchend') selector.off('click');
        },

		getCustomMenu: function () {
			return $("#brikit-mobile-menu");
		},

        getMenu: function () {
            var $menuContainer = $(".mobile-menu");
			var $menuTarget = $("#mobile-menu-goes-here");
            if ($menuTarget.length) {
				$menuContainer.find(".mobile-aui-header").addClass("aui-header");
            	$menuTarget.replaceWith(ThemePress.Menu.isMultiLevel() ? ThemePress.Mobile.calculateMultiLevelMenu() : ThemePress.Mobile.calculateMenu());
            }
            return $menuContainer;
        },

        // Return the latest mention markup (needed for adding to the comment text area).
        getMentionString: function() {
            return ThemePress.Mobile.mentionMarkup[ThemePress.Mobile.mentionMarkup.length - 1].mentionString;
        },

        // Retrieve mention HTML and markup via REST API.
        getMentionMarkup: function(user, mentionMarkup) {
            return $.ajax({
                url: Confluence.getContextPath() + '/rest/api/contentbody/convert/storage',
                type: "POST",
                contentType: "application/json; charset=UTF-8",
                data: JSON.stringify({
                    value: "[~" + user +  "]",
                    representation: "wiki"
                }),
                dataType: "text",
                success: function(response) {
                    var parsedResponse = JSON.parse(response);
                    mentionMarkup.push({
                        mentionString: "[~" + user +"]",
                        html: parsedResponse.value.replace(/<p>|<\/p>/g, "")
                    });
                },
                error: function(xhr, error) {
                    alert("error");
                    console.log("Could not retrieve mention HTML for " + user + ".");
                    console.log("readyState: "+xhr.readyState+", status: "+xhr.status+", responseText" + xhr.responseText);
                }
            });
        },

        // Gets a parameter value from a URL
        getParameterByName: function(name, url) {
            if (!url) url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        },

		hasCustomMenu: function () {
			return ThemePress.Mobile.getCustomMenu().length;
		},

		hasScrolled: function (forceAdjust, forceHide) {
			
			// Don't move the menu if a menu panel is open
			if ($("body").hasClass("disable-nav") ||
				ThemePress.Mobile.isCustomMenuOpen() || 
				ThemePress.Mobile.isMenuPanelOpen() ||
				ThemePress.Mobile.isTableOfContentsOpen() ||
				ThemePress.Mobile.isMobileOverlayOpen()) return;

			var scrollTop = $(window).scrollTop();
			var headerHeight = ThemePress.Mobile.headerForHidingHeight();

            var scrollingDown = scrollTop > ThemePress.Mobile.lastScrollTop;
            var scrollingAtTop = scrollTop < 1;
            var bouncingOffBottom = scrollTop + $(window).height() + 150 > $(document).height();

			// If user moves down past header, hide the menu
			if (forceHide || (scrollingDown || bouncingOffBottom) && !scrollingAtTop) {
				if (forceHide || scrollTop > headerHeight) {
					$("body").addClass("hide-nav");
					ThemePress.Mobile.lastScrollTop = scrollTop;
				}
			} 
			else {
				$("body").removeClass("hide-nav");
				ThemePress.Mobile.lastScrollTop = scrollTop;
			}

		},
		
		headerForHiding: function () {
			return $(".brikit-header-backdrop");
		},
		
		headerForHidingHeight: function (includeMargin) {
            includeMargin = includeMargin || false;
			return ThemePress.Mobile.headerForHiding().outerHeight(includeMargin);
		},
		
        hideUserDelegate: function() {
            $('html, body').unbind();
            $("#mobile-user-delegate-selector").hide();
        },
		
		initialize: function () {
			
            // Initialize the menu.
            ThemePress.Mobile.getMenu();

            // Set up the mobile menu slider.
            var $site = $('#page');
            if (!$site.parent().is('body')) $site.appendTo('body');
            $site.addClass('mobile-menu-slider');

            // Add the mobile menu to the DOM.
            $('body').prepend($('.mobile-menu'));

            // Add the appropriate search field
            var $targetedSearch = $(".targeted-search-field[data-replace-default]").first().removeAttr("data-replace-default").show();
            if ($targetedSearch.length) {
                // Targeted Search 2.x Targeted Search Field macro replacing Confluence search
                // For Targeted Search 3.0 adjustment, see ThemePress.Mobile.open() function
                $("#brikit-mobile-search").empty().append($targetedSearch);
            }
			else {
                // Let Theme Press mobile search run
			    ThemePress.MobileSearch.initialize();
			}
			
			// Add doo-dads to the input field
			var $searchIcon = ThemePress.auiIcon("search", "search-icon");
			var $closeIcon = ThemePress.auiIcon("close-dialog", "close-icon");
			ThemePress.Mobile.quickSearchField().after($searchIcon).after($closeIcon);

			// Add and wire the mobile menu trigger
			var $menuToggle = ThemePress.Mobile.addMenuToggle();
			$menuToggle.click(ThemePress.Mobile.toggleMenu);

            // Close mobile menu via link.
            $('.mobile-menu a').on('click', function(event) {
                ThemePress.Mobile.eventHandler(event, $(this));
                if (ThemePress.Mobile.menuIsOpen()) ThemePress.Mobile.close($(this).attr('href'));
            });

            // Close menus via outside touch.
            $site.on('touchend click', function(event) {
	            // Close search results menu via outside touch.
				if (!ThemePress.Mobile.searchResultsHidden()) {
                    ThemePress.Mobile.eventHandler(event, $(this));
					$("#mobile-appheader").click();
					return false;
				}
	            // Close mobile menu via outside touch.
                else if (ThemePress.Mobile.menuIsOpen()) {
                    ThemePress.Mobile.eventHandler(event, $(this));
                    ThemePress.Mobile.close();
					return false;
                }
            });

            $('.mobile-toggle-submenu').off('click').on('click', function() {
                $submenu = $(this).parent().children('.mobile-submenu');
                $(this).add($submenu).toggleClass('mobile-submenu-active');
                if ($submenu.hasClass('mobile-submenu-active')) $submenu.slideDown(200);
                else $submenu.slideUp(200);
            });
            
            // Make the whole li element clickable for expanders in mobile multi-level menus
            $(".mobile-submenu.multi-level-menu").on("click", "li[href^='#submenu-']", function (e) { 
                if (this != e.target) return; 
                e.preventDefault(); 
                e.stopPropagation(); 
                $("> .submenu-toggle", this).click();
            });
            $(".multi-level-menu li[href^='#submenu-']:not(:has(> a))").addClass("no-link-toggle");
			
		},
		
		initializeCustomMenu: function () {
			var $menuToggle = ThemePress.Mobile.addMenuToggle();
			$menuToggle.click(ThemePress.Mobile.toggleCustomMenu);
			
			$("#page").on("touchend click", function (e) {
				var $t = $(e.target);
				// Don't auto close if user clicked on the toggle button (it'll handle it or the menu)
				var ignore = $t.attr("id") == "mobile-menu-toggle-button" || $t.closest("#mobile-menu-toggle-button").length ||
							 $t.attr("id") == "brikit-mobile-menu" || $t.closest("#brikit-mobile-menu").length
				if (!ignore && $(".custom-menu-on").length) $menuToggle.click(); 
			});

            // Add a window cover to catch clicks, etc. when mobile menu is open.
            $("#brikit-canvas-content").prepend($("<div>").addClass("mobile-menu-page-cover"));

		},
		
		initializeHeaderForScrolling: function () {
			$(window).scroll(function () { ThemePress.Mobile.didScroll = true; });
			setInterval(function() {
				if (ThemePress.Mobile.didScroll) {
					ThemePress.Mobile.hasScrolled();
					ThemePress.Mobile.didScroll = false;
				}
			}, 250);
		},
		
		isCustomMenuOpen: function () {
			return $("body").hasClass("custom-menu-on");
		},
		
		isMenuPanelOpen: function () {
			return $("body").hasClass("menu-panel-open");
		},
		
		// Support other apps
		isMobileOverlayOpen: function () {
			return $("body").hasClass("mobile-overlay");
		},
		
		isTableOfContentsOpen: function () {
			return $("body").hasClass("show-mobile-toc");
		},
		
        menuIsOpen: function () {
            return $('.mobile-menu-active').length > 0;
        },

        moveShareButton: function() {
            if (!themePressMobile) return;
			var $share = $("<div>").addClass("mobile-share");
			$(".brikit-labels").append($share);
            $("#shareContentLink").appendTo($share);
            $("#shareContentLink").removeClass("aui-button-subtle");
            // Scrolls the page to the "Share Dialog" when clicked.
            $("#shareContentLink").click(function(){
                $("html, body").animate ({
                    scrollTop:  $("#shareContentLink").offset().top - 250
                }, 1000);
            });
        },
		
        open: function () {
            $("body").addClass("mobile-menu-active");
            $(".mobile-menu-slider").addClass("mobile-menu-open");
            $('.mobile-menu').css("visibility","visible");
			
			if (!ThemePress.Mobile.searchAdjusted) {

                // If Targeted Search 3.0 is installed, remove the search from the Theme Press mobile menu
                if ($(".brikit-search-panel").length) $("#brikit-mobile-search").remove();
			
				// Prevent the search form from accessing the search results screen
				ThemePress.Mobile.quickSearch()
					.submit(function () {return false;})
					.focusin(function () {
						ThemePress.Mobile.searchInFocus = true;
						ThemePress.Mobile.quickSearch().addClass("focused");
						ThemePress.Mobile.pruneSearchResults();
					})
					.focusout(function () {
						ThemePress.Mobile.searchInFocus = false;
					});
					
				ThemePress.Mobile.quickSearch().find(".search-icon").click(function (e) {
					e.preventDefault();
					ThemePress.Mobile.quickSearchField().focus();
				});
				
				ThemePress.Mobile.quickSearch().find(".close-icon").click(function (e) {
					e.preventDefault();
					ThemePress.MobileSearch.mobileResults().hide();
					ThemePress.Mobile.quickSearch().removeClass("focused");
					ThemePress.Mobile.quickSearchField().val("");
					ThemePress.Mobile.searchInFocus = false;
				});
			
				ThemePress.Mobile.searchAdjusted = true;				
			}
        },
		
		pruneSearchResults: function () {
			$(".search-for, .admin-item", ".mobile-menu .quick-search-dropdown:not(.replacement)").closest("ol").remove();
			if (!$(".mobile-menu .quick-search-dropdown ol:visible li").length) {
				$(".mobile-menu .quick-search-dropdown").append($("<ol><li><a><span>Not found</span></a></li></ol>"));
			}
			if (ThemePress.Mobile.searchInFocus) setTimeout(ThemePress.Mobile.pruneSearchResults, 50);
		},
		
		quickSearch: function () {
			return $("#quick-search, #search-ui, #brikit-mobile-search .targeted-search-field").first();
		},

		quickSearchField: function () {
			return $("#quick-search-query").first();
		},

		resizeLabelsEditor: function() {
            $(".aui-popup").css({"left": "0%"});
            $("#edit-labels-dialog").css({"width": "100%", "margin-left": 0});
		},
		
		searchResultsHidden: function () {
			return !$("#brikit-mobile-search .quick-nav-drop-down .aui-dropdown").length ||
				   $("#brikit-mobile-search .quick-nav-drop-down .aui-dropdown.hidden").length;
		},
		
		showUserDelegate: function(element) {
		    // Disable scroll.
            $('html, body').on('scroll touchmove mousewheel', function(e){
                e.preventDefault();
                e.stopPropagation();
                return false;
            });
		    ThemePress.Mobile.$activeTextForm = $(element).parents().eq(3).find("textarea");
            $("#mobile-user-delegate-selector").show();
            $("#mobile-user-delegate-field").val("");
            $("#mobile-user-delegate-selector #mobile-user-delegate-field").focus();
		},

        // Converts the comments to HTML before posting (including retrieving the proper mention markup).
		textToHtml: function(html, mentionMarkup) {
            if (mentionMarkup) {
                for (var i = 0; i < mentionMarkup.length; i++) {
                    html = html.replace(mentionMarkup[i].mentionString, mentionMarkup[i].html);
                }
            }
            return html;
        },

		toggleCustomMenu: function () {
			$(".brikit-menu-top-level .brikit-menu-dropdown-trigger.active").click();

			$("body").toggleClass("custom-menu-on");
			ThemePress.Mobile.updateScrollPrevention();
		},
		
        toggleMenu: function () {
            if (ThemePress.Mobile.menuIsOpen()) ThemePress.Mobile.close();
            else ThemePress.Mobile.open();
			return false;
        },
		
		updateScrollPrevention: function () {
            return; // see mobile.css for body.some-class with overflow: hidden (TODO: remove this and all calls after testing)
		}
	};

	ThemePress.toFinalize( function ($) {

		// Don't do mobile for frames
		if (typeof(themePressMobile) == "undefined" || !themePressMobile || $("#main-content.frames").length) return;

		if (ThemePress.Mobile.hasCustomMenu()) ThemePress.Mobile.initializeCustomMenu();
		else ThemePress.Mobile.initialize();
		
		ThemePress.Mobile.initializeHeaderForScrolling();
		
        ThemePress.Mobile.moveShareButton();

        var focusedComment =  ThemePress.Mobile.getParameterByName("focusedComment", window.location);

		// Scrolling for Mobile.
		if (focusedComment != null) {
            $('html, body').animate({
                scrollTop: $(".mobile-comment-outer-" + focusedComment).offset().top
            }, 400);
        }

	});

})(jQuery);

