/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitList;
import com.brikit.themepress.model.PageWrapper;
import java.util.List;
import java.util.Map;

public class IncludeContentMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/include-content.vm";
    public static final String PAGE = "page";
    public static final String LABELS = "labels";
    public static final String EXCLUDE_LABELS = "exclude-labels";
    public static final String SPACE_KEY = "key";
    public static final String NAMES = "block-names";
    public static final String RENDER_WITHOUT_BLOCKS = "render-without-blocks";
    public static final String RETAIN_BORDERS = "retain-borders";
    public static final String RETAIN_BLOCK_WIDTH = "retain-block-width";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (!macroContext.hasStringValue(PAGE) && !macroContext.hasStringValue(LABELS)) {
            throw new MacroExecutionException("Missing parameter: Page title or labels");
        }
        AbstractPage includePage = macroContext.pageFromValue(PAGE, null);
        if (macroContext.hasStringValue(PAGE) && includePage == null) {
            throw new MacroExecutionException("Couldn't find page: " + macroContext.stringValue(PAGE));
        }
        if (includePage == macroContext.getPage()) {
            throw new MacroExecutionException("Including content from the current page is not allowed.");
        }
        if (includePage != null && !Confluence.canRead((AbstractPage)includePage)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        List names = macroContext.commaSeparatedListValue(NAMES);
        boolean renderWithoutBlocks = macroContext.booleanValue(RENDER_WITHOUT_BLOCKS);
        boolean retainBorders = macroContext.booleanValue(RETAIN_BORDERS);
        boolean retainBlockWidth = macroContext.booleanValue(RETAIN_BLOCK_WIDTH);
        try {
            if (includePage != null) {
                this.renderBlocks(builder, includePage, names, renderWithoutBlocks, retainBorders, retainBlockWidth);
            } else {
                String spaceKey = macroContext.stringValue(SPACE_KEY);
                Space space = null;
                if (macroContext.hasStringValue(SPACE_KEY)) {
                    Space space2 = space = spaceKey.equals("@current") ? macroContext.getSpace() : macroContext.spaceFromValue(SPACE_KEY);
                }
                if (macroContext.hasStringValue(SPACE_KEY) && space == null) {
                    throw new MacroExecutionException("Invalid space key: " + macroContext.stringValue(SPACE_KEY));
                }
                if (space != null) {
                    spaceKey = space.getKey();
                }
                SearchResults searchResults = Confluence.findPagesByLabel((String)spaceKey, (List)macroContext.listValue(LABELS), (int)200);
                List excludeLabels = macroContext.listValue(EXCLUDE_LABELS);
                for (SearchResult searchResult : searchResults.getAll()) {
                    includePage = Confluence.getPageOrBlogPost((SearchResult)searchResult);
                    if (includePage == null || Confluence.hasAnyLabel((AbstractLabelableEntityObject)includePage, (List)excludeLabels)) continue;
                    this.renderBlocks(builder, includePage, names, renderWithoutBlocks, retainBorders, retainBlockWidth);
                }
            }
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Couldn't read content blocks on " + String.valueOf(includePage)), (Exception)ex);
            throw new MacroExecutionException("Couldn't read content blocks on " + String.valueOf(includePage), (Throwable)ex);
        }
        macroContext.velocityContextAdd((Object)"body", (Object)builder.toString());
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    protected void renderBlocks(StringBuilder builder, AbstractPage abstractPage, List<String> names, boolean renderWithoutBlocks, boolean retainBorders, boolean retainBlockWidth) throws Exception {
        PageWrapper wrapper = PageWrapper.get(abstractPage);
        BrikitList renderedBlocks = new BrikitList();
        for (MacroDefinition block : wrapper.blocksForced()) {
            if (!names.isEmpty() && !names.contains(wrapper.getName(block))) continue;
            MacroParser.setName((MacroDefinition)block, (String)"rendered-content-block");
            if (renderWithoutBlocks) {
                MacroParser.setParameter((MacroDefinition)block, (String)"brikit-content-block-include", (String)"true", (AbstractPage)abstractPage);
            }
            if (retainBorders) {
                MacroParser.setParameter((MacroDefinition)block, (String)RETAIN_BORDERS, (String)"true", (AbstractPage)abstractPage);
            }
            if (retainBlockWidth) {
                MacroDefinition column = wrapper.columnMacroForBlock(wrapper.getId(block));
                String width = MacroParser.getStringParameter((MacroDefinition)column, (String)"width");
                MacroParser.setParameter((MacroDefinition)block, (String)"block-width", (String)width, (AbstractPage)abstractPage);
            }
            String renderedContent = Confluence.render((MacroDefinition)block, (AbstractPage)abstractPage);
            renderedBlocks.add((Object)renderedContent);
        }
        builder.append(renderedBlocks.join("<p class='include-content-separator'></p>"));
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

