/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.AbstractThemeFileAction;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.util.ThemePress;
import java.io.File;
import java.util.Collections;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class UploadFileAction
extends AbstractThemeFileAction {
    public String execute() {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            UploadedFile[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                UploadedFile uploadedFile;
                if (files[i] == null || !(uploadedFile = files[i]).isFile()) continue;
                File file = (File)uploadedFile.getContent();
                this.setFilename(this.getMultiPartRequest().getFileNames(parameterName)[i]);
                BrikitLog.log((String)("Uploading: " + file.getAbsolutePath()));
                if (!this.getFilename().endsWith("." + this.getFileExtension())) {
                    return this.jsonError("Wrong file type. Must be ." + this.getFileExtension());
                }
                if (this.getThemeFile().exists()) {
                    return this.jsonError("File already exists in theme.");
                }
                try {
                    File destinationFile = this.getThemeFile();
                    BrikitFile.ensurePathExists((String)destinationFile.getParent());
                    file.renameTo(destinationFile);
                    BrikitList filenames = new BrikitList(this.getFileNames());
                    filenames.add((Object)this.getFilenameWithoutExtension());
                    ThemePlugin.apply(this.getThemeName(), this.getFileNamesProperty(), filenames.join(" "));
                    ThemePress.resetCaches();
                    continue;
                }
                catch (Exception ex) {
                    return this.jsonError((String)(BrikitString.isSet((String)ex.getMessage()) ? ex.getMessage() : "Unable to upload " + this.getFilename()));
                }
            }
        }
        return this.jsonSuccess();
    }
}

