/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.settings.BrikitConfigProperties;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeCacheHelper;
import com.brikit.themepress.settings.ThemeProperties;
import com.brikit.themepress.util.ThemePress;
import java.io.File;

public class ThemeJavaScriptCacheHelper
extends ThemeCacheHelper {
    protected boolean customCode;
    protected boolean skipDesignerSupport;

    public ThemeJavaScriptCacheHelper(String key) {
        this(key, 0L);
    }

    public ThemeJavaScriptCacheHelper(String key, long compiledAt) {
        super(key, "css", compiledAt);
        this.setThemeName((String)this.getBits().first());
        this.setTweaker(this.getBits().size() > 1 ? (String)this.getBits().get(1) : "");
        this.setCustomCode(this.bits.size() > 2 && "theme".equals(this.bits.get(2)));
        this.setSkipDesignerSupport("edit".equals(this.bits.last()));
    }

    public String filesFromPlugins() {
        return BrikitThemeSettings.javascriptFilesForThemePressPlugins();
    }

    public String filesFromTheme() {
        return ThemeProperties.getThemeProperties(this.getThemeName()).getJavascriptFiles();
    }

    public String filesFromThemePress() {
        return BrikitConfigProperties.getJavaScriptFilesList(!this.isSkipDesignerSupport() && ExternalDevelopmentMode.isDesigning());
    }

    public boolean isCustomCode() {
        return this.customCode;
    }

    public boolean needsUpdate() {
        if (!this.isDeveloperMode()) {
            return false;
        }
        for (String filename : BrikitString.split((String)this.filesFromThemePress())) {
            File file = BrikitThemeSettings.getExternalDevelopmentFile(ThemePress.PLUGIN_KEY, filename, "css", "css");
            if (file.lastModified() <= this.compiledAt) continue;
            return true;
        }
        return false;
    }

    public boolean isSkipDesignerSupport() {
        return this.skipDesignerSupport;
    }

    public void setSkipDesignerSupport(boolean skipDesignerSupport) {
        this.skipDesignerSupport = skipDesignerSupport;
    }

    public void setCustomCode(boolean customCode) {
        this.customCode = customCode;
    }
}

