/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.PageWrapper;
import com.brikit.themepress.model.SpaceWrapper;
import java.util.Calendar;

public class CreateMobileVersionAction
extends ThemePressActionSupport {
    protected AbstractPage newPage;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        String mobileTitle = PageWrapper.get(this.getPage()).getMobilePhonePageTitle();
        String storageFormat = Confluence.getBodyAsString((ContentEntityObject)this.getPage());
        SpaceWrapper spaceWrapper = SpaceWrapper.get(this.getSpaceKey());
        this.newPage = Confluence.isBlog((AbstractPage)this.getPage()) ? Confluence.createBlogPost((Space)this.getSpace(), (String)mobileTitle, (String)storageFormat, (Calendar)Calendar.getInstance()) : Confluence.createPage((Space)this.getSpace(), (String)mobileTitle, (String)storageFormat, (boolean)false, (Page)spaceWrapper.getOrCreateMobilePageRoot());
        Confluence.copyAttachments((AbstractPage)this.getPage(), (AbstractPage)this.newPage);
        return "success";
    }

    public AbstractPage getNewPage() {
        return this.newPage;
    }

    public String getNewPageUrl() {
        return this.getPageUrl(this.getNewPage());
    }

    public void setNewPage(AbstractPage newPage) {
        this.newPage = newPage;
    }

    public void validate() {
        super.validate();
        if (PageWrapper.get(this.getPage()) == null) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
        if (!Confluence.canCreate((String)this.getSpaceKey())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
        if (PageWrapper.get(this.getPage()).getMobilePhoneVersion() != null) {
            this.addActionError(this.getText("brikit.config.page.already.exists"));
        }
    }
}

