/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.util;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitMobile;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class RenderedPageCache {
    protected static final String CACHE_DIR = "page_cache";
    protected static final String FILE_EXT = ".html";
    protected static final long CACHE_TIME_LIMIT = 30L;
    protected static long resetCacheTimestamp = new Date().getTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheContent(String content, Page aPage) {
        File cacheFile = RenderedPageCache.cacheLocationWithUser(aPage);
        String string = cacheFile.getAbsolutePath();
        synchronized (string) {
            try {
                File location = RenderedPageCache.cacheLocationWithVersion(aPage);
                BrikitFile.ensurePathExists((File)location);
                BrikitFile.writeFileUTF8((String)content, (File)cacheFile);
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Failed to write page content cache at " + cacheFile.getAbsolutePath()), (Exception)ex);
            }
        }
    }

    protected static File cacheLocation(Page aPage) {
        File pageLocation = new File(RenderedPageCache.cacheLocation(), aPage.getIdAsString());
        return new File(pageLocation, BrikitMobile.isPhone() ? "mobile" : "desktop");
    }

    protected static File cacheLocation() {
        return BrikitFile.getBrikitFile((String)CACHE_DIR);
    }

    protected static File cacheLocationWithUser(Page aPage) {
        int userHash = Confluence.isAnonymousUser() ? 0 : Confluence.getConfluenceUser().hashCode();
        return new File(RenderedPageCache.cacheLocationWithVersion(aPage), userHash + FILE_EXT);
    }

    protected static File cacheLocationWithVersion(Page aPage) {
        long start = new Date().getTime();
        int version = Confluence.canEdit((AbstractPage)aPage) ? aPage.getVersion() : 0;
        return new File(RenderedPageCache.cacheLocation(aPage), Integer.toString(version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cachedContent(Page aPage) {
        File cacheFile = RenderedPageCache.cacheLocationWithUser(aPage);
        String string = cacheFile.getAbsolutePath();
        synchronized (string) {
            try {
                if (!cacheFile.exists()) {
                    return null;
                }
                RenderedPageCache.checkCacheExpirationIgnoringSynchronization(cacheFile);
                if (cacheFile.exists()) {
                    return BrikitFile.readFileUTF8((File)cacheFile);
                }
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Failed to read cached page content at " + cacheFile.getAbsolutePath()), (Exception)ex);
            }
        }
        return null;
    }

    protected static void checkCacheExpirationIgnoringSynchronization(File cacheFile) {
        if (cacheFile.lastModified() < RenderedPageCache.getResetCacheTimestamp()) {
            BrikitFile.removeFile((File)cacheFile);
            return;
        }
        long minutesOld = (new Date().getTime() - cacheFile.lastModified()) / 60000L;
        if (minutesOld > 30L) {
            BrikitFile.removeFile((File)cacheFile);
        }
    }

    protected static long getResetCacheTimestamp() {
        return resetCacheTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanCache(File cacheFile) {
        if (cacheFile.getName().equals(".") || cacheFile.getName().equals("..")) {
            return;
        }
        if (cacheFile.isDirectory()) {
            File[] fileList = cacheFile.listFiles();
            if (fileList != null) {
                for (File file : fileList) {
                    RenderedPageCache.cleanCache(file);
                }
                if (fileList.length == 0) {
                    cacheFile.delete();
                }
            }
        } else if (cacheFile.getAbsolutePath().endsWith(FILE_EXT)) {
            String string = cacheFile.getAbsolutePath();
            synchronized (string) {
                RenderedPageCache.checkCacheExpirationIgnoringSynchronization(cacheFile);
            }
        }
    }

    public static void cleanCache() {
        RenderedPageCache.cleanCache(RenderedPageCache.cacheLocation());
    }

    public static void resetCache() {
        resetCacheTimestamp = new Date().getTime();
    }
}

