(function ($) { 

	// Wire the receiver to show popup help panels
	$.fn.enablePopupHelp = function() {
        return this.each(function () {
			var property = $(this).data("key");
			var label = $(".label-text", this).text();
			var themeTab = $(this).closest(".theme-tab").length;
			var pageTab  = $(this).closest(".page-tab").length;
			AJS.InlineDialog(
				$(this), 
				$(this).data("key"), 
				contextPath + "/plugins/brikit/help/help.action?key=" + property + "&name=" + encodeURIComponent(label) + ThemePress.atlTokenParam(true), 
				{
					onHover: false, 
					width: 500, 
					showDelay: 0, 
					initCallback: function () { 
						var $popup = $(this.popup);
						var dialog = this;
						$popup.css({zIndex: 10000});
						$popup.find(".tour-button").enableLessonPlan();
						$popup.find(".close-link").click(function(){ dialog.hide(); return false; });
						
						// Hide the properties expando panel if we're not on the Theme tab, or another tab in external dev mode
						if (themeTab) $popup.find(".expanding-field-set-container").fieldsetContainerToggle(true);
						else if (ThemePress.isDeveloperMode()) $popup.find(".expanding-field-set-container").fieldsetContainerToggle(true);
						else $popup.find(".expanding-field-set-container").remove();
						if (ThemePress.isDeveloperMode()) $popup.find(".expanding-field-set-container .field-set-toggle").click();
					}
				}
			);
	    });
	};

})(jQuery);
