/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.settings.SpaceCategorySettings;
import java.io.File;
import java.util.Collections;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

@AdminOnly
public class UploadSpaceCategorySettingsAction
extends ThemePressActionSupport {
    @PermittedMethods(value={HttpMethod.POST})
    public String execute() throws Exception {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            UploadedFile[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                UploadedFile uploadedFile;
                if (files[i] == null || !(uploadedFile = files[i]).isFile()) continue;
                File pluginFile = (File)uploadedFile.getContent();
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log((String)("Uploading: " + pluginFile.getAbsolutePath()));
                try {
                    SpaceCategorySettings.uploadSettings(pluginFile);
                    this.setResult(filename);
                    continue;
                }
                catch (Exception ex) {
                    BrikitLog.logError((String)("Unable to read settings in " + filename), (Exception)ex);
                    this.addActionError(BrikitString.isSet((String)ex.getMessage()) ? ex.getMessage() : "Unable to read " + filename);
                    return "error";
                }
            }
        }
        return "success";
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

