/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveSearchMultiSpaceAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(LiveSearchMultiSpaceAction.class);
    private static final String ACTION_RESULT_INVALID_SEARCH_RESULT = "invalidsearchresult";
    private static final int MAX_RESULTS = 10;
    private String liveSearchId;
    private String queryString;
    private String where;
    private List<SearchResult> results;
    private PredefinedSearchBuilder predefinedSearchBuilder;
    private SearchManager searchManager;

    public String getLiveSearchId() {
        return this.liveSearchId;
    }

    @StrutsParameter
    public void setLiveSearchId(String liveSearchId) {
        this.liveSearchId = liveSearchId;
    }

    public String getQueryString() {
        return this.queryString;
    }

    @StrutsParameter
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getWhere() {
        return this.where;
    }

    @StrutsParameter
    public void setWhere(String where) {
        this.where = where;
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    public String execute() throws Exception {
        if (StringUtils.isBlank((String)this.queryString)) {
            return "success";
        }
        SearchQueryParameters params = new SearchQueryParameters(this.queryString);
        BrikitList spaceKeys = BrikitString.splitCommaOrSpaceSeparated((String)this.getWhere());
        params.setSpaceKeys(new HashSet(spaceKeys));
        ISearch search = this.predefinedSearchBuilder.buildSiteSearch(params, 0, 10);
        try {
            SearchResults searchResults = this.searchManager.search(search);
            if (searchResults == null) {
                log.warn("Failure executing search for term " + this.queryString);
                return "error";
            }
            this.results = searchResults.getAll();
            return "success";
        }
        catch (IllegalArgumentException iae) {
            log.debug("Invalid search query provided: " + this.queryString, (Throwable)iae);
            return ACTION_RESULT_INVALID_SEARCH_RESULT;
        }
    }

    @StrutsParameter
    public void setPredefinedSearchBuilder(PredefinedSearchBuilder predefinedSearchBuilder) {
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }
}

