/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.UserFullNameSortOrder;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import java.util.Collections;
import java.util.Map;

public class UserGroupNavigatorMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/user-group-navigator.vm";
    protected static final String SORT_ORDER_PARAM = "sort-order";
    protected static final String INCLUDE_INDIVIDUAL_EDITORS = "include-individual-editors";
    protected static final String SORT_NAME_VALUE = "name";
    protected static final String SORT_GROUP_VALUE = "group";
    protected static final String THUMBNAIL_HEIGHT_PARAM = "thumbnail-height";
    protected static final String THUMBNAIL_WIDTH_PARAM = "thumbnail-width";
    protected static final String THUMBNAIL_MARGIN_PARAM = "thumbnail-margin";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        BrikitList<BrikitList<Object>> users = new BrikitList<BrikitList<Object>>();
        for (String groupName : macroContext.commaSeparatedListValue("groups")) {
            Group group = Confluence.getGroup(groupName);
            if (group == null) {
                throw new MacroExecutionException("Unknown group: " + groupName);
            }
            BrikitList<User> groupUsers = Confluence.getGroupMembers(group, false);
            Collections.sort(groupUsers, new UserFullNameSortOrder());
            users.ensureContains(groupUsers);
        }
        if (macroContext.booleanValue(INCLUDE_INDIVIDUAL_EDITORS)) {
            for (User user : Confluence.getUsersWithSpacePermissions(macroContext.getSpace())) {
                if (!Confluence.hasSpacePermissionAsUser("EDITSPACE", macroContext.getSpace(), user) || users.contains(user)) continue;
                users.add((BrikitList<Object>)user);
            }
        }
        if (SORT_NAME_VALUE.equals(macroContext.stringValue(SORT_ORDER_PARAM))) {
            Collections.sort(users, new UserFullNameSortOrder());
        }
        macroContext.velocityContextAdd("users", users);
        macroContext.velocityContextAdd(THUMBNAIL_HEIGHT_PARAM, BrikitNumber.parseInteger(macroContext.stringValue(THUMBNAIL_HEIGHT_PARAM, "256")));
        macroContext.velocityContextAdd(THUMBNAIL_WIDTH_PARAM, BrikitNumber.parseInteger(macroContext.stringValue(THUMBNAIL_WIDTH_PARAM, "256")));
        macroContext.velocityContextAdd(THUMBNAIL_MARGIN_PARAM, BrikitNumber.parseInteger(macroContext.stringValue(THUMBNAIL_MARGIN_PARAM, "0")));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public boolean isInline() {
        return true;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

