/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.lesson.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.util.BrikitString;
import java.util.List;

public class LearnAction
extends ConfluenceActionSupport {
    protected static final String YOU_TUBE_ID_KEY = "com.brikit.themepress.learn.videos";
    protected String result;

    public String execute() throws Exception {
        JSONArray videos = new JSONArray();
        for (String youTubeID : this.getYouTubeIDs()) {
            JSONObject youTube = new JSONObject();
            youTube.put("id", (Object)youTubeID);
            youTube.put("title", (Object)this.getTitleForYouTubeID(youTubeID));
            youTube.put("html", (Object)this.getHtmlForYouTube(youTubeID));
            videos.put((Object)youTube);
        }
        JSONObject json = new JSONObject();
        json.put("success", true);
        json.put("videos", (Object)videos);
        this.setResult(json.toString());
        return "success";
    }

    public String getCaptionForYouTubeID(String id) {
        return this.getValueIfSpecified("com.brikit.themepress.learn.videos." + id + ".caption");
    }

    public String getHeightForYouTubeVideos() {
        return this.getValueIfSpecified("com.brikit.themepress.learn.videos.height");
    }

    public String getHtmlForYouTube(String id) throws Exception {
        String caption = this.getCaptionForYouTubeID(id);
        caption = BrikitString.isSet((String)caption) ? "<h1 style='margin:0 0 12px 0'>" + caption + "</h1>" : "";
        MacroDefinition macro = MacroParser.createMacroDefinition((String)"widget");
        MacroParser.setParameter((MacroDefinition)macro, (String)"url", (String)("http://www.youtube.com/watch?v=" + id), null);
        MacroParser.setParameter((MacroDefinition)macro, (String)"height", (String)this.getHeightForYouTubeVideos(), null);
        MacroParser.setParameter((MacroDefinition)macro, (String)"width", (String)this.getWidthForYouTubeVideos(), null);
        return caption + Confluence.render((MacroDefinition)macro, null);
    }

    public String getResult() {
        return this.result;
    }

    public String getTitleForYouTubeID(String id) {
        return this.getValueIfSpecified("com.brikit.themepress.learn.videos." + id);
    }

    public String getValueIfSpecified(String key) {
        String value = Confluence.getText((String)key);
        return BrikitString.isSet((String)value) && !key.equals(value) ? Confluence.getText((String)key) : null;
    }

    public String getWidthForYouTubeVideos() {
        return this.getValueIfSpecified("com.brikit.themepress.learn.videos.width");
    }

    public List<String> getYouTubeIDs() {
        return BrikitString.splitCommaSeparated((String)this.getValueIfSpecified(YOU_TUBE_ID_KEY));
    }

    public void setResult(String result) {
        this.result = result;
    }
}

