(function ($) { 

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];

	BrikitCore.Dialog2 = {
		
		alert: function (message, options, callback) {
			
			options = options || {};
			options.id = options.id || "brikit-alert-dialog";
			options.title = options.title || BrikitCore.getText("com.brikit.core.alert");
			options.size = options.size || "small";
			
			var actions = [ BrikitCore.Dialog2.okButton(options, callback) ];

			BrikitCore.Dialog2.baseDialog(message, options, actions).show();
			
			return false;
		},
		
		baseDialog: function (body, options, actions) {
			options.size = options.size || "medium";
			options.modal = options.modal || true;
			
			$("#" + options.id).remove();
			
			options.size = options.size || "medium";
			var $header = $("<header class='aui-dialog2-header'>")
				.append($("<h2 class='aui-dialog2-header-main'>").text(options.title));
				
			var $content = $("<div class='aui-dialog2-content'>")
				.append(body);
		
			var $actions = $("<div class='aui-dialog2-footer-actions'>");
			$.each(actions, function (i, action) {
				var $button = $("<button class='aui-button'>")
					.addClass(action.classes)
					.text(action.text)
					.click(action.callback);
				$actions.append($button);
			});
			
			var $footer = $("<footer class='aui-dialog2-footer'>")
				.append($actions);
				
			var $hint = $("<div class='aui-dialog2-footer-hint'>");
			$footer.append($hint);
		
			var $dialog = $("<section class='aui-dialog2' role='dialog'>")
				.attr("role", "dialog")
				.attr("id", options.id)
				.addClass("aui-dialog2-" + options.size)
				.append($header)
				.append($content)
				.append($footer)
				.hide();
			
			if (options.modal) $dialog.attr("data-aui-modal", "true");
			
			$("body").append($dialog);
			
			return AJS.dialog2($dialog);			
		},
		
		cancelButton: function (options, callback) {
			return { 
				text: options.cancelButton || BrikitCore.getText("com.brikit.core.cancel"), 
				classes: "cancel", 
				callback: function (event) {
					event.preventDefault();
					var $dialog = BrikitCore.Dialog2.hide(options);
					if (callback) callback.call(this, $dialog);
				}
			};
		},
		
		confirm: function (message, options, callback, closeCallback) {
			
			options = options || {};
			options.id = options.id || "brikit-confirm-dialog";
			options.title = options.title || BrikitCore.getText("com.brikit.core.confirm");
			options.size = options.size || "medium";
			
			var actions = [ 
				BrikitCore.Dialog2.okButton(options, callback),
				BrikitCore.Dialog2.cancelButton(options, closeCallback)
			];

			return BrikitCore.Dialog2.baseDialog(message, options, actions).show();
		},
		
		dialog: function (panelContents, options, callback, closeCallback, preventCloseCallback) {
			
			options = options || {};
			options.id = options.id || "brikit-dialog";
			options.title = options.title || BrikitCore.getText("com.brikit.core.confirm");
			options.size = options.size || "medium";

			preventCloseCallback = preventCloseCallback || function ($dialog) { 
				BrikitCore.Dialog2.hide(options);
				if (closeCallback) closeCallback.call(this, $dialog);
			};

			var actions = [ 
				BrikitCore.Dialog2.okButton(options, callback),
				BrikitCore.Dialog2.cancelButton(options, preventCloseCallback)
			];

			return BrikitCore.Dialog2.baseDialog(panelContents, options, actions).show();
		},
		
		doubleConfirm: function (message, options, proceedCallback, cancelCallback) {
			options = options || {};
			options.id = options.id || "brikit-double-confirm-dialog";
			options.title = options.title || BrikitCore.getText("com.brikit.core.confirm");
			options.size = options.size || "medium";
			options.doubleConfirmMessage = options.doubleConfirmMessage || 
						BrikitCore.getText("com.brikit.core.i.understand.the.above");
			options.notConfirmedMessage = options.notConfirmedMessage || 
						"<p>" + BrikitCore.getText("com.brikit.core.you.do.not.seem.confident.about.this") + "</p><p>" + BrikitCore.getText("com.brikit.core.if.you.are.check.the.box.and.try.again") + "</p>";
			
			message = message + "<form class='aui'><fieldset><label for='double-confirm'>" + options.doubleConfirmMessage +"</label> <input id='double-confirm' class='checkbox' type='checkbox' /></fieldset></form>";

			var doubleConfirmCallback = function ($dialog) {
				if (!$("#double-confirm:checked", "#" + options.id).length) {
					BrikitCore.Dialog2.alert(options.notConfirmedMessage, { title: BrikitCore.getText("com.brikit.core.are.you.sure") });
					BrikitCore.Dialog2.hide(options);
					if (cancelCallback) cancelCallback.call(this, $dialog);
					return false;
				}
				BrikitCore.Dialog2.hide(options);
				proceedCallback.call(this, $dialog);
			};


			var actions = [ 
				BrikitCore.Dialog2.okButton(options, doubleConfirmCallback),
				BrikitCore.Dialog2.cancelButton(options, cancelCallback)
			];

			return BrikitCore.Dialog2.baseDialog(message, options, actions).show();
		},
		
		hide: function (options) {
			var $dialog = AJS.dialog2($("#" + options.id)).hide();
			$(".aui-blanket").remove();
			return $dialog;
		},
		
		inline: function (element, title, message, options, callback) {

			options = options || {};
			options.initCallback = function () { $(this.popup).css({zIndex: 10000}); };
			if (callback) options.hideCallback = callback;

			var dialog = AJS.InlineDialog($(element), "brikit-dialog-inline" + new Date().getTime(),
			    function(content, trigger, showPopup) {
			        content
						.css({"padding":"20px"})
						.html("<h2>" + title + "</h2><p>" + message + "</p><br/><form class='aui'><a href='#' class='close-link'>" + BrikitCore.getText("com.brikit.core.close") + "</a>");
					content.find(".close-link").click(function () { BrikitCore.Dialog2.hide(options); return false; });
			        showPopup();
			        return false;
			    },
				options
			);
			
			return dialog;
		},

		okButton: function (options, callback) {
			return { 
				text: options.okButton || BrikitCore.getText("com.brikit.core.ok"), 
				classes: "aui-button-primary ok", 
				callback: function (event) {
					event.preventDefault();
					var $dialog = BrikitCore.Dialog2.hide(options);
					if (callback) callback.call(this, $dialog);
				}
			};
		}
		
	};

})(jQuery);
