/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.html.RichLinks;
import java.util.Map;

public class WrapMacro
extends BrikitBaseMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/wrap.vm";
    public static final String TAG_PARAM = "tag";
    public static final String BORDER_SIDE_PARAM = "border-side";
    public static final String ALIGN_PARAM = "align";
    public static final String FLOAT_PARAM = "float";
    public static final String DISPLAY_RICH_LINKS_PARAM = "display-rich-links";
    public static final String IGNORE_THUMBNAILS_PARAM = "ignoreThumbnails";
    public static final String BORDER_ALL = "all";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String align;
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.stringValue(TAG_PARAM).equalsIgnoreCase("span")) {
            body = BrikitString.removeOuterParagraph(body);
        }
        if (macroContext.booleanValue(DISPLAY_RICH_LINKS_PARAM)) {
            body = RichLinks.convertLinksInHTML(body, macroContext.booleanValue(IGNORE_THUMBNAILS_PARAM));
        }
        macroContext.velocityContextAdd("body", body);
        if (BORDER_ALL.equals(macroContext.stringValue(BORDER_SIDE_PARAM))) {
            macroContext.velocityContextAdd(BORDER_SIDE_PARAM, null);
        }
        if (BrikitString.isSet(align = macroContext.stringValue(ALIGN_PARAM, macroContext.stringValue(FLOAT_PARAM)))) {
            macroContext.velocityContextAdd(ALIGN_PARAM, align);
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

