/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.comalaworkflowsservice;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.brikit.core.comalaworkflowsservice.Comala;
import com.brikit.core.comalaworkflowsservice.ComalaServiceFactory;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import java.util.Date;

public class ComalaAccessor {
    private static Comala comala;
    private static long timestamp;

    public static synchronized Comala getComala() {
        if (new Date().getTime() - timestamp > 15000L) {
            timestamp = new Date().getTime();
            comala = null;
        }
        if (comala == null) {
            ComalaAccessor.initComala();
        }
        return comala;
    }

    private static void initComala() {
        PluginAccessor pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
        Plugin comalaPlugin = pluginAccessor.getEnabledPlugin("com.comalatech.workflow");
        if (comalaPlugin != null) {
            try {
                Class<?> comalaServiceFactoryClass = ComalaAccessor.getComalaServiceFactoryClass();
                if (comalaServiceFactoryClass != null) {
                    comala = ((ComalaServiceFactory)Confluence.getApplicationContext().getAutowireCapableBeanFactory().createBean(comalaServiceFactoryClass, 3, false)).get();
                }
            }
            catch (Exception e) {
                BrikitLog.logDebug("Could not create Comala", e);
            }
        }
    }

    private static Class<?> getComalaServiceFactoryClass() {
        try {
            ClassLoader classLoader = ComalaAccessor.class.getClassLoader();
            classLoader.loadClass("com.comalatech.workflow.ApprovalService");
            classLoader.loadClass("com.comalatech.workflow.StateService");
            classLoader.loadClass("com.comalatech.workflow.TaskService");
            classLoader.loadClass("com.comalatech.workflow.WorkflowService");
            return classLoader.loadClass("com.brikit.comalaworkflowsservice.ComalaServiceFactory");
        }
        catch (Exception e) {
            BrikitLog.log("Comala Workflows classes are unavailable.");
            return null;
        }
    }

    public static Class getApprovalServiceClass() {
        try {
            return Class.forName("com.comalatech.workflow.ApprovalService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class getStateChangeEventClass() {
        try {
            return Class.forName("com.comalatech.workflow.event.StateChangeEvent");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class getStateServiceClass() {
        try {
            return Class.forName("com.comalatech.workflow.StateService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class getTaskServiceClass() {
        try {
            return Class.forName("com.comalatech.workflow.TaskService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class getWorkflowServiceClass() {
        try {
            return Class.forName("com.comalatech.workflow.WorkflowService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        timestamp = 0L;
    }
}

