(function ($) { 

	TargetedSearch.Admin = {

	 	addSpaceCategoriesDialog: function (event) {
			event.preventDefault();

	 		// Copy the space-labels-form into a dialog and populate it from the selected row
	 		var form = jQuery(".space-labels-form").clone().removeClass("space-labels-form");
	 		form.convertDataCopyIds().find("[data-copy-id]").convertDataCopyIds();
			// Copy the action from the widget that was clicked to the dialog form (for ajax use)
	 		form.attr("data-action", $(this).attr("href"));
			
			var menu = $(this).closest(".menu-holder");
			var isFilter = menu.attr("data-filter-label");
			var selector = isFilter ? 
					"data-filter-label="  + menu.attr("data-filter-label") : 
					"data-filter-group-key=" + menu.attr("data-filter-group-key");  
			var $row = jQuery("tr.filter-group[" + selector + "]").first();

			var label = $row.find(".label").text();  
			var filterGroup = $row.data("filter-group-display-name"); 
			var filterGroupKey = $row.data("filter-group-key");  

			// populate a hidden field to transmit the parent filterGroup's filterGroupkey
			$("#parent-group-hidden", form).val(filterGroupKey);
			
			return TargetedSearch.Dialog2.confirm(form.show(), {title: $(this).data("wizard-label"), size: "medium", okButton: "Save"}, TargetedSearch.Admin.saveSpaceCategory);
	 	},

		collapseAllFilterGroups: function (event) {
			$("#filters-configuration .expander.expanded").each(function () { TargetedSearch.Admin.expandFilterGroup(this, false); });
		},
		
		confirmAndSaveAllowDuplicateFilterNames: function (url, confirmTitle, confirmMessage, okButton, dialogSize) {
            const data = {};
            TargetedSearch.addToken(data);
			if (TargetedSearch.Dialog2.doubleConfirm(TargetedSearch.getText(confirmMessage), 
                {title: TargetedSearch.getText(confirmTitle), okButton: TargetedSearch.getText(okButton), size: dialogSize}, function () {
    			jQuery.post({
    				url: url,
                    data: data,
    				success: function (response) {
    					if (response.indexOf("errorMessage") == -1) {
    						location.reload(true);
    					}
    					else {
    						AJS.flag({
                               type: "error",
    						   body: response
    						});
    					}
    				},
    				error: function (xhRequest, textStatus, errorThrown) {
						AJS.flag({
                           type: "error",
    					   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
    					});
    				}
    			});
			}));
			return false;
		},
	
		disableDuplicateFilterNames: function () {
            var url = $(this).attr("href");
            TargetedSearch.Admin.confirmAndSaveAllowDuplicateFilterNames(url, 
                "com.brikit.targetedsearch.settings.duplicate.filter.names", 
                "com.brikit.targetedsearch.settings.disallow.duplicate.filter.names.confirm",
                "com.brikit.targetedsearch.disable",
                "large");
			return false;
		},
	
	 	deleteFilterOrGroup: function () {
			var $target = $(this);

			// NOTE: non-dry! These two lines are also used in editFilterOrGroup and addSpaceCategoriesDialog
			var menu = $target.closest(".menu-holder");
			var isFilter = menu.attr("data-filter-label");
	 		var deleteURL = $target.attr("href");
			// TODO: I18N needed
			var mssg = isFilter ? $target.attr("title") + " filter?" : $target.attr("title") + " filterGroup and all its filters?"
	 		TargetedSearch.Dialog2.confirm("<p>" + mssg + "</p>", {title: $(this).data("wizard-label"), size: "medium"}, function () {
	 			window.location = deleteURL + TargetedSearch.atlTokenParam(true);
	 		} );
	 		return false;
	 	},

	 	editFilterOrGroup: function (event) {
			event.preventDefault();
			var $target = $(this);

	 		// Copy the add/edit panel into a dialog and populate it from the selected row
	 		var form = jQuery(".edit-settings").clone().removeClass("edit-settings");
	 		form.convertDataCopyIds().find("[data-copy-id]").convertDataCopyIds();
			// Copy the action from the button that was clicked to the dialog form (for ajax use)
	 		form.attr("data-action", $target.attr("href"));

			// NOTE: non-dry! These two lines are also used in deleteFilterOrGroup and addSpaceCategoriesDialog
			var menu = $target.closest(".menu-holder");
			var isFilter = menu.attr("data-filter-key");
			
			// Find the in-focus table row, using menu data (distinguishes filter vs filterGroup)
			var selector = isFilter ? 
					"tr.filter[data-filter-key="  + menu.attr("data-filter-key") + "]" : 
					"tr.filter-group[data-filter-group-key=" + menu.attr("data-filter-group-key") + "]";  
			var $row = $(selector).first();

			var label = $row.data("label-suffix");  
			var filterGroup = $row.data("filter-group-display-name"); 
			var filterGroupKey = $row.data("filter-group-key"); 
			var filterKey = menu.attr("data-filter-key");
			
			// If we're editing....
			var editingFilter = $target.hasClass("edit-filter-link");
			if (editingFilter) {
				// Append the itemKey (filterGroup or filterKey) in a hidden field
				if (isFilter) {
					form.append("<input type='hidden' name='itemKey' value='" + filterKey + "' />");
				}
				else {
					form.append("<input type='hidden' name='itemKey' value='" + filterGroupKey + "' />");
				}
				
				// Populate the label field
				$("#item-label", form).val(label);
				
				// Populate displayName
				$("#item-name", form).val($row.find(".displayName").text());

				// Populate label prefix
				$("#label-prefix", form).val($row.find(".label").text());
			}
		
			// If adding a subcategory, switch to add filter group mode
			var isAddingSubcategory = isFilter && $target.hasClass("add-subcategory-link");
			if (isAddingSubcategory) isFilter = false;

			var isAddingFilter = $target.hasClass("add-filter-link");
			var isFilterForm = isFilter || isAddingFilter;

			// If adding a Category....
			if ($target.hasClass("add-filter-group") || !isFilterForm) {
				// Lose the parent filterGroup name and item label fields
				$("#filter-group-fieldset, #item-label-fieldset", form).remove();

				// If adding a subcategory, populate the parent filter field (display and hidden field). Otherwise, remove it.
				var parentFilterLabel = menu.data("filter-label");
				if (isAddingSubcategory || parentFilterLabel) $("#parent-filter-display, #parent-filter-field", form).val(parentFilterLabel);
				else $("#parent-filter-fieldset", form).remove();
				
				// Check the promoted box to match, or remove it for subcategories
				if (parentFilterLabel) $("#promoted-group-fieldset", form).remove();
				else $("#promoted-group", form).prop("checked", menu.data("promoted"));
			}
			else {
				// Lose the parent filter, label prefix, and promoted fields
				$("#parent-filter-fieldset, #label-prefix-fieldset", form).remove();

				// For a Filter, disable the filter-group-fieldset fieldset (read only) 
				$("#filter-group-fieldset", form).attr("disabled", "disabled");
				$("#parent-group-display", form).val(filterGroup);

				// Populate a hidden field to transmit the parent filterGroupKey
				$("#parent-group-hidden", form).val(filterGroupKey);
				
				// Set the promoted status unless adding
				if (!isAddingFilter) $("#promoted-group", form).prop("checked", menu.data("promoted"))
			}

	 	    return TargetedSearch.Dialog2.confirm(form.show(), {title: $(this).data("wizard-label"), size: "medium", okButton: "Save"}, TargetedSearch.Admin.saveFilter);
	 	},
	
		enableDuplicateFilterNames: function () {
            var url = $(this).attr("href");
            TargetedSearch.Admin.confirmAndSaveAllowDuplicateFilterNames(url, 
                "com.brikit.targetedsearch.settings.duplicate.filter.names", 
                "com.brikit.targetedsearch.settings.allow.duplicate.filter.names.confirm",
                "com.brikit.targetedsearch.enable",
                "medium");
			return false;
		},
	
		expandAllFilterGroups: function (event) {
			$("#filters-configuration .expander:not(.expanded)").each(function () { TargetedSearch.Admin.expandFilterGroup(this, true); });
		},
		
		expandFilterGroup: function (expander, shouldExpand) {
			var $expander = $(expander);
			var $expanderIcon = $(".expander-icon", $expander);
			var $filterGroup = $expander.closest(".filter-group");
			var groupKey = $filterGroup.data("filter-group-key");

			var $collapsingRows = $filterGroup.nextAll("[data-parent-groups~='" + groupKey + "']");
			TargetedSearch.Admin.expandingChildren($filterGroup, shouldExpand).showIf(shouldExpand);

			$expander.adjustClass("expanded", shouldExpand);
			$expanderIcon
				.adjustClass("aui-iconfont-expanded", shouldExpand)
				.adjustClass("aui-iconfont-collapsed", !shouldExpand);
			
			// Expand children to latest state
			if (shouldExpand) TargetedSearch.Admin.expandingChildren($filterGroup, true).filter(".filter-group").each(function () {
				var $expander = $(this).find(".expander")
				TargetedSearch.Admin.expandFilterGroup($expander, $expander.hasClass("expanded"));
			});
		},
		
		// Return the rows representing children of the filter group represented by $filterGroupRow.
		// If strictChildren is true, then return only that filter group's labels and their subcategory rows.
		expandingChildren: function ($filterGroupRow, strictChildren) {
			var filterGroupKey = $filterGroupRow.data("filter-group-key");
			var $collapsingRows = $filterGroupRow.nextAll("[data-parent-groups~='" + filterGroupKey + "']");
			if (!strictChildren) return $collapsingRows;
			return $collapsingRows.filter("[data-parent-groups^='" + filterGroupKey + "']");
		},
		
		importConfiguration: function () {
			var $button = $(this);
			var $form = $("#import-settings-form");
			var $inputField = $form.find("#importsettings");

			// Clear out then trigger the hidden file upload form
			$inputField.val("").click();

			// When the import filename changes, automagically upload the file and invoke the import action...
			$inputField.unbind().change(function () { 
				// ...on File selection, confirm before importing
				var fileName = $inputField.val().split('\\').pop();
				return TargetedSearch.Dialog2.doubleConfirm("<p>" + TargetedSearch.getText("com.brikit.targetedsearch.import.settings.question", [fileName]) + "</p>", 
				  { title: TargetedSearch.getText("com.brikit.targetedsearch.import.settings.confirm"), 
					  size: "medium", 
					  okButton: TargetedSearch.getText("com.brikit.targetedsearch.import.settings.confirm") 
				  }, function (dialog) {
					dialog.hide();
					$form.submit();
				});
			});
			
			// Convert file upload to ajax submission (using the jquery.form plugin)
			// On submission of the file upload, check server response for errors
			$form.ajaxForm(function (result) {
				if (result.indexOf("errorMessage") > -1) {
					TargetedSearch.Dialog2.alert(result, { title: TargetedSearch.getText("com.brikit.targetedsearch.file.upload.error") }, TargetedSearch.reloadBrowser);
				}
				else {
					TargetedSearch.Dialog2.alert(
						"<p>" + TargetedSearch.getText("com.brikit.targetedsearch.reloading") + "</p>",
						{ title: TargetedSearch.getText("com.brikit.targetedsearch.success") }
					);
					TargetedSearch.reloadBrowser(1000);
				}
			});

		},
	
	 	removeSpaceCategory: function () {
			var $target = $(this);

			var labelButton = $target.closest(".aui-label-closeable");
			var actionURL = $target.data("action");
            const data = {};
            TargetedSearch.addToken(data);
		
			jQuery.post({
				url: actionURL, 
                data: data,
				success: function (response) {
					if (response.indexOf("errorMessage") == -1) {
						labelButton.fadeOut();
					}
				},
				error: function (xhRequest, textStatus, errorThrown) {
					AJS.flag({
                       type: "error",
					   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
					});
				}
			});
 		
	 		return false;
	 	},

		saveFilter: function (dialog) {
			var form = $("#edit-settings-form");
			$.post({
				url: form.data("action"), 
				data: form.serialize(), 
				success: function (response) {
					if (response.indexOf("errorMessage") == -1) {
						location.reload(true);
					}
					else {
						AJS.flag({
                           type: "error",
						   body: response
						});
					}
				},
				error: function (xhRequest, textStatus, errorThrown) {
					AJS.flag({
                       type: "error",
					   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
					});
				}
			});
			return false;
		},
	
		saveSpaceCategory: function (dialog) {
			var form = $("#space-labels-form");
			
			// Validate for non-null input only (Awaiting CORE-1 patch)
			//
			// Check the target filterGroup for the transaction
			var filterGroup = $("#parent-group-hidden", form).val();
			if (!filterGroup) {
				AJS.flag({
                   type: "error",
				   body: "An error has occurred. Please contact your administrator. (Message: On Settings UI add visibility restriction, category is null)"
				});
				return false;
			}
			
			$.post({
				url: form.data("action"), 
				data: form.serialize(), 
				success: function (response) {
					if (response.indexOf("errorMessage") == -1) {
						location.reload(true);
					}
					else {
						AJS.flag({
                           type: "error",
						   body: response
						});
					}
				},
				error: function (xhRequest, textStatus, errorThrown) {
					AJS.flag({
                       type: "error",
					   body: TargetedSearch.getText("com.brikit.targetedsearch.settings.unknown.server.error", errorThrown)
					});
				}
			});
			return false;

		},
		
		showCountResults: function (event) {
			event.preventDefault();
			var label = $(this).data("label");
			TargetedSearch.SearchPanel.openSearch("searchFilters=" + label);
		},
		
		toggleFilterGroupExpander: function (event) {
			var $expanderIcon = $(".expander-icon", this);
			TargetedSearch.Admin.expandFilterGroup(this, $expanderIcon.hasClass("aui-iconfont-collapsed"));
		}
	
	 };
  
	 TargetedSearch.toInit( function ($) {
		// Bind the Operation widgets
		$(".add-space-label-link").click(TargetedSearch.Admin.addSpaceCategoriesDialog);
		$(".space-category-labels .aui-icon-close").click(TargetedSearch.Admin.removeSpaceCategory);
		$("#add-filter-group, .add-filter-link, .edit-filter-link, .add-subcategory-link").click(TargetedSearch.Admin.editFilterOrGroup);
	 	$(".delete-filter-link").click(TargetedSearch.Admin.deleteFilterOrGroup);
		$("#import-config").click(TargetedSearch.Admin.importConfiguration);
		$(".filter-groups-collapse-all").click(TargetedSearch.Admin.collapseAllFilterGroups);
		$(".filter-groups-expand-all").click(TargetedSearch.Admin.expandAllFilterGroups);
        $("#enable-duplicate-filter-names").click(TargetedSearch.Admin.enableDuplicateFilterNames);
        $("#disable-duplicate-filter-names").click(TargetedSearch.Admin.disableDuplicateFilterNames);
		
		$("#filters-configuration")
			.on("click", ".displayName.expander", TargetedSearch.Admin.toggleFilterGroupExpander)
			.on("click contextmenu", ".count-results-link", TargetedSearch.Admin.showCountResults);
	 });

})(jQuery);