// Global Targeted Search javascript functions & variables
(function ($) { 

	TargetedSearch.Attachments = {
		
		openUploadForm: function () {
			var $button = $(this);
			var $form = $("#form-" + $button.data("id"));
			var $inputField = $form.find(".uploadFile");

			// Make the upload button trigger the hidden file upload form
			$inputField.val("").click();

			// When the file upload filename changes, automagically upload and apply the file to the current image field
			$inputField.unbind().change(function () { 
				// On submission of the theme uploader, confirm before firing
				var fileName = $inputField.val().split('\\').pop();
				return TargetedSearch.Dialog2.confirm("<p>" + TargetedSearch.getText("com.brikit.targetedsearch.upload.file.question", [fileName]) + "</p>", { title: $button.text() }, function (dialog) {
					dialog.hide();
					$form.submit();
				});
			});
			
			// On submission of the file upload, check server response for errors
			// Make the file upload form work via ajax (using the jquery.form plugin)
			$form.ajaxForm(function (result) {
				if ($(result).hasClass("errorMessage")) {
					TargetedSearch.Dialog2.alert(result, { title: TargetedSearch.getText("com.brikit.targetedsearch.file.upload.error") });
				}
				else {
					TargetedSearch.Dialog2.alert(
						"<p>" + TargetedSearch.getText("com.brikit.targetedsearch.reloading") + "</p>",
						{ title: TargetedSearch.getText("com.brikit.targetedsearch.success") }
					);
					TargetedSearch.reloadBrowser(1000);
				}
			});

		}
		
	};
	
	TargetedSearch.toInit(function () {
		$(".upload-attachment-button").click(TargetedSearch.Attachments.openUploadForm);
	});

})(jQuery);
