(function ($) {

	TargetedSearch.ResultsBrowser = function (element) {
		this.element = $(element);
		this.initialize();
		this.element.data("results-browser", this);
		this.debug = false;
		
		// Deprecated: For backwards-compatibility for other apps, custom themes, etc.
		TargetedSearch.Browse = this;
	};
	
	Object.assign(TargetedSearch.ResultsBrowser.prototype, {

		addFilterToSummary: function ($filter, speed) {
			var id = $filter.attr("id");
			if (!id) return;
			var $lozenge = $("<span>")
				.addClass("selected-filter aui-label aui-label-closeable")
				.attr("data-id", id)
				.text($("label[for='" + id + "']").text());
			var $closeButton = $("<span>").addClass("aui-icon aui-icon-close").attr("tabindex", "0");
			$lozenge.append($closeButton);
			this.selectedFilterSummary().append($lozenge);
			if (!this.selectedFilterSummary().find(".selected-filter").length) return;
			$lozenge.hide().fadeIn(speed, function () { $lozenge.css("display", "inline-block"); });
		},
		
		adjustFilterGroupsForSelection: function () {
			this.filterGroups().each(function () {
				$(this).adjustClass("filters-checked", $(".checkbox.search-filter:checked", this).length);
			});
		},
		
		adjustGoTopButton: function () {
			var threshhold = $(window).scrollTop();
			var buttonThreshhold = threshhold + $(window).height();
			var $wikiContent = this.targetedSearchResults();
			var wikiContentBottom = $wikiContent.offset().top + $wikiContent.height();
			$(".responsive-jump-to-top").adjustClass("hit-bottom", buttonThreshhold > wikiContentBottom);
		},
		
		collapseAllFilterGroups: function (event) {
			event.preventDefault();
			$(".brikit-expander-control.expanded", "#filterGroups, .default-search-options").click();
		},
		
		collapseFilterGroups: function (scope) {
			scope = scope || "#filterGroups, .default-search-options";
			$(".checkbox.search-filter", scope).closest(".checkbox-wrapper").hide();
		},
		
		dateRangeChanged: function (event) {
			var $filter = $($(event.currentTarget).children("option:selected"));
			var filterType = $filter.data("filter-type");
			var label = $filter.data("label");
			this.selectedFilters.addFilter($filter, filterType);
		},
		
		dateRangeField: function () {
			return this.find("#date-range-selector");
		},
		
		defaultSearchActionForm: function () {
			return $("#default-search-action-form");
		},

		expandAllFilterGroups: function (event) {
			event.preventDefault();
			$(".brikit-expander-control:not(.expanded)", "#filterGroups, .default-search-options").click();
		},
		
		expandFilterGroups: function (scope) {
			scope = scope || "#filterGroups, .default-search-options";
			$(".checkbox.search-filter", scope).closest(".checkbox-wrapper").show();
		},
		
		filterAdded: function ($filter) {
			// this.markFilterPicker($filter, false);
			this.searchCriteriaChanged();
		},
	
		filterGroups: function () {
			return $(".filter-group-select");
		},
		
		filterRemoved: function ($filter, noSearchUpdate) {			
			if (noSearchUpdate) return;

			$filter = $($filter);
			
			// removeProp and removeAttr are both used because of SEARCH-738
			var $checkbox = this.find(".search-filter.checkbox[data-label='" + $filter.data("id") + "']").removeProp("checked").removeAttr("checked");
			
			if ($filter.hasClass("date-range")) this.dateRangeField().val("");
			
			if ($filter.hasClass("contributor")) {
				this.contributorField().val("");
				this.contributorUsernameField().val("");
			}

			this.searchCriteriaChanged();
		},

		find: function (selector) {
			return selector ? $(selector, this.element) : this.element;
		},

		// Return the "go to Conf Site Search" widget
		goToSiteSearchOption: function () {
			return $(".targeted-search-browse-results #go-to-site-search");
		},
	
		handlePreSelectedFilters: function() {
			// Collect all pre-selected filters; for any filter that's reprsented by a
			// checkbox, set the checkbox to selected, and remove any pre-existing (duplicate)
			// pre-selected filter (un-matched pre-selected filters to remain in place)
			this.searchForm.find("input[name='searchFilters']").each(function () {
				var $input = $(this);
				var $match = $("#filterGroups .checkbox[name='" + $input.val() + "']");
				if ($match.length) {
					$match.attr("checked", "checked");
					$input.remove();
				}
			});
		},
		
		initialize: function () {
			var self = this;
		
			this.find(".targeted-search-form").first().each(function () { self.searchForm = new TargetedSearch.SearchForm(this, self.find(".search-results-list"), self); });
			this.find(".selected-filters").first().each(function () { self.selectedFilters = new TargetedSearch.SelectedFilters(this, self.searchForm, self); });

			this.find(".search-results-page-panel-nav").on("change", ".search-filter.checkbox", this.toggleFilter.bind(this));
			this.dateRangeField().on("change", this.dateRangeChanged.bind(this));
			this.contributorField().bind("selected.autocomplete-user-or-group", this.userSelected.bind(this));

			// Move the debug viewer out of the header
			this.find("#results-wrap").prepend(TargetedSearch.cqlDebugViewer());
			
			this.goToSiteSearchOption().click(this.sendToConfluenceSearch.bind(this));
			this.handlePreSelectedFilters();

			this.initializeFilterGroupsExpanders();
			$(".results-filters-expand-all").click(this.expandAllFilterGroups.bind(this));
			$(".results-filters-collapse-all").click(this.collapseAllFilterGroups.bind(this));
		
			$(window).on("scroll resize", this.respondToBrowserChange.bind(this));
			$(".responsive-jump-to-top").click(function (e) { $("html, body").animate({ scrollTop: "0" }); });
		
			this.searchCriteriaChanged();
		
		},
	
		initializeFilterGroupsExpanders: function () {
			var resultsBrowser = this;
			resultsBrowser.filterGroups().each(function() {
				var $expander = $(this);
				if ($expander.hasClass("initialized")) return;

				$expander.addClass("initialized");
				var $control = $expander.find(".brikit-expander-control");
				var $content = $expander.find(".brikit-expander-content"); // .showIf($control.hasClass("expanded"));
				var $expanderIcon = $control.find(".expander-icon");

				var adjustVisibility = function (speed) {
					var isExpanded = $control.hasClass("expanded");
					$expanderIcon.adjustClass("aui-iconfont-expanded", isExpanded);
					$expanderIcon.adjustClass("aui-iconfont-collapsed", !isExpanded);
					if (isExpanded) resultsBrowser.expandFilterGroups($expander, speed);
					else resultsBrowser.collapseFilterGroups($expander, speed);
					// $content.slideOpenIf(isExpanded);
				}
				adjustVisibility(0);
			
				var toggle = function () {
					$control.toggleClass("expanded");
					adjustVisibility();
				}
				$control.click(toggle);
	        });
			
			resultsBrowser.adjustFilterGroupsForSelection();
			
		},
		
		moreResultsLoader: function () {
			return $(".more-results-scroll-loader").data("more-results-loader");
		},
		
		respondToBrowserChange: function () {
			this.adjustGoTopButton();
		},
		
		resultsLoaded: function (resultsData) {
			if (this.debug) console.log("results loaded", resultsData);

			if (!resultsData.totalMatches) {
				this.searchResultsContainer().append("<p class='no-search-results'>" + TargetedSearch.getText("com.brikit.targetedsearch.results.no.search.results.found") + "</p>");
			}
			this.updateResultsStatistics(TargetedSearch.getText("com.brikit.targetedsearch.results.total.search.results", resultsData.totalMatches, resultsData.searchTime));
			
			return true;
		},
		
		searchCriteriaChanged: function () {
			this.searchForm.updateSortBy(this.find(".sort-by-select:not(.select2-container)").val());

			this.selectedFilters.updateSearchFiltersFromSelections();
			
			this.updateResultsStatistics(TargetedSearch.getText("com.brikit.targetedsearch.results.searching"));
			this.searchForm.searchCriteriaChanged();
		},
		
		searchFilters: function () {
			return $("#filterGroups .checkbox");
		},
	
		searchInputField: function () {
			return this.searchForm.find("input.search-input");
		},
		
		// searchModeOptions: function () {
		searchModeAdvanced: function () {
			return $(":checkbox", ".search-mode-advanced");
		}, 
		
		searchResultsContainer: function () {
			return this.find(".search-results-list");
		},
		
		// Redirect to Confluence search site action, with user's query terms only
		sendToConfluenceSearch: function () {
			this.defaultSearchActionForm().find("input[name=queryString]").val(this.queryString());
			this.defaultSearchActionForm().submit();
			return false;
		},
		
		targetedSearchResults: function (selector) {
			var $results = $("#targeted-search-results");
			return selector ? $(selector, $results) : $results;
		},
		
		toggleFilter: function (event) {
			var $filter = $(event.currentTarget);
			var filterType = $filter.data("filter-type");
			var label = $filter.data("label");
			if ($filter.is(":checked")) this.selectedFilters.addFilter($filter, filterType);
			else this.selectedFilters.removeFilterForLabel(label, filterType);
		},
		
		updateResultsStatistics: function (html) {
			this.find(".results-statistics").html(html);
		},
		
		userSelected: function (event) {
			event.preventDefault();
			var username = this.contributorUsernameField().val();
			var displayName = this.contributorField().val();
			var $field = $("<span data-display-name='" + displayName + "' data-filter-type='contributor' data-label='" + username + "'>");
			this.selectedFilters.addFilter($field, "contributor");
		}

	});
	
	TargetedSearch.toFinalize(function ($) {
		$(".targeted-search-browse-results").each(function () { new TargetedSearch.ResultsBrowser(this); });		
	});
		
})(jQuery);
