/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.search.service.DateRangeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.summary.HitHighlighter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.util.actions.ContentTypesDisplayMapper;
import com.atlassian.renderer.util.RendererUtil;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.SearchSettings;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class TargetedSearchAction
extends AbstractTargetedSearchAction {
    protected static final int RESULT_EXCERPT_LENGTH = 320;
    private static final String SEO_META_DESCRIPTION = "com.zenfoundation.seo.meta.description";
    private static final int MAX_RESULTS_PER_PAGE = 10;
    protected String queryString;
    protected int maxResults;
    protected int maxLiveResults;
    protected List<String> searchFilters;
    protected List<String> additionalFilters;
    protected List<String> folksonomyLabels;
    protected List<String> excludeFilters;
    protected List<String> searchScope;
    protected List<String> spaceSearchScope;
    protected boolean showSpaceCategories;
    protected List<String> shownFilterGroups;
    protected List<String> hiddenFilterGroups;
    protected List<String> contentTypes;
    protected String contributor;
    protected String lastModified;
    protected String searchMode;
    protected String useSEO;
    protected String sortBy;
    protected TargetedSearch targetedSearch;
    protected List<SearchResult> searchResults;
    protected String hostSpaceKey;
    protected boolean inheritSpaceLabel = true;
    protected boolean searchInTitle = false;
    protected boolean displayRichLinks;
    protected boolean macroOverridesRichLinksDisplay;
    protected String where;
    private HitHighlighter highlighter;
    private ContentTypesDisplayMapper contentTypesDisplayMapper;
    private PredefinedSearchBuilder predefinedSearchBuilder;
    private SearchManager searchManager;
    private int startIndex = 0;

    @AnonymousSiteAccess
    public String doQuickSearch() {
        return "success";
    }

    @AnonymousSiteAccess
    public String doTargetedSearch() throws Exception {
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET})
    @AnonymousSiteAccess
    public String execute() {
        return "success";
    }

    public List<Filter> getAdditionalFilters() {
        return Filter.getFiltersForLabels(this.additionalFilters);
    }

    public String getAllFiltersTooltip() {
        return TargetedSearch.getAllFiltersTooltip();
    }

    public String getAnyFiltersTooltip() {
        return TargetedSearch.getAnyFiltersTooltip();
    }

    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    public ContentTypesDisplayMapper getContentTypesDisplayMapper() {
        return this.contentTypesDisplayMapper;
    }

    public String getContributor() {
        return this.contributor;
    }

    public String getDefaultFiltersTooltip() {
        return TargetedSearch.getDefaultFiltersTooltip();
    }

    public List<Filter> getExcludeFilters() {
        return Filter.getFiltersForLabels(this.excludeFilters);
    }

    public List<FilterGroup> getFilterGroups() {
        BrikitList<FilterGroup> allVisible = FilterGroup.getFilterGroupsForSpace(this.getHostSpaceKey());
        ArrayList<FilterGroup> configured = new ArrayList<FilterGroup>();
        if (this.getShownFilterGroups().isEmpty()) {
            configured = allVisible;
        } else {
            for (String filterGroupName : this.getShownFilterGroups()) {
                FilterGroup shownFilterGroup = FilterGroup.getFilterGroupByName(filterGroupName);
                if (!allVisible.contains(shownFilterGroup)) continue;
                configured.add(shownFilterGroup);
            }
        }
        for (String filterGroupName : this.getHiddenFilterGroups()) {
            FilterGroup hiddenFilterGroup = FilterGroup.getFilterGroupByName(filterGroupName);
            if (!configured.contains(hiddenFilterGroup)) continue;
            configured.remove(hiddenFilterGroup);
        }
        Collections.sort(configured);
        return configured;
    }

    public List<String> getFolksonomyLabels() {
        return this.folksonomyLabels;
    }

    public List<String> getHiddenFilterGroups() {
        if (this.hiddenFilterGroups == null) {
            this.hiddenFilterGroups = new ArrayList<String>();
        }
        return this.hiddenFilterGroups;
    }

    public String getHostSpaceKey() {
        return this.hostSpaceKey;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public int getMaxLiveResults() {
        return this.maxLiveResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getPageSize() {
        return 10;
    }

    public PredefinedSearchBuilder getPredefinedSearchBuilder() {
        return this.predefinedSearchBuilder;
    }

    public String getQuery() {
        return this.getQueryString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<SearchResult> getQuickSearchResults() throws Exception {
        int maxQuickSearchResults = this.getMaxLiveResults() == 0 ? 15 : this.getMaxLiveResults();
        TargetedSearch searcher = this.getTargetedSearch();
        return new ArrayList<SearchResult>();
    }

    public String getResultType(SearchResult searchResult) {
        String type = searchResult.getType().toLowerCase();
        if (type.contains("attachment")) {
            return ContentTypesDisplayMapper.getIconForAttachment((String)searchResult.getType(), (String)searchResult.getDisplayTitle());
        }
        ContentTypesDisplayMapper mapper = (ContentTypesDisplayMapper)ContainerManager.getComponent((String)"contentTypesDisplayMapper");
        return mapper.getClassName(searchResult);
    }

    public String getSEODescriptionForResult(SearchResult searchResult) {
        Page page = Confluence.getPage((String)searchResult.getSpaceKey(), (String)searchResult.getDisplayTitle());
        ContentPropertyManager cpMgr = (ContentPropertyManager)ContainerManager.getComponent((String)"contentPropertyManager");
        String value = cpMgr.getStringProperty((ContentEntityObject)page, SEO_META_DESCRIPTION);
        return value == null ? "" : value;
    }

    protected DateRangeEnum getSearchDateRange() {
        return BrikitString.isSet((String)this.getLastModified()) ? DateRangeEnum.valueOf((String)this.getLastModified()) : null;
    }

    public List<String> getSearchFilterLabels() {
        return this.searchFilters;
    }

    public List<Filter> getSearchFilters() {
        return Filter.getFiltersForLabels(this.searchFilters);
    }

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    public String getSearchMode() {
        return this.searchMode;
    }

    public List<String> getSearchScope() {
        return this.searchScope;
    }

    public List<String> getShownFilterGroups() {
        return this.shownFilterGroups == null ? new ArrayList() : this.shownFilterGroups;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public List<String> getSpaceSearchScope() {
        return this.spaceSearchScope;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    @HtmlSafe
    public String getSummaryForResult(SearchResult result) {
        String content = result.getField("excerpt");
        if (!BrikitString.isSet((String)content)) {
            content = result.getContent();
        }
        String title = result.getDisplayTitle();
        if (content != null && content.startsWith(title)) {
            content = content.substring(title.length());
        }
        String summary = "";
        if (BrikitString.isSet((String)this.getQueryString())) {
            summary = Confluence.getHighlighter((String)this.getQueryString()).getSummary(content);
        } else if (content != null) {
            summary = content.length() > 320 ? content.substring(0, 320) : content;
            summary = this.stripMarkup(summary);
        }
        return summary.trim().length() > 0 ? summary + "..." : summary;
    }

    protected TargetedSearch getTargetedSearch() {
        if (this.targetedSearch == null) {
            this.targetedSearch = new TargetedSearch();
        }
        return this.targetedSearch;
    }

    @HtmlSafe
    public String getTitleForResult(SearchResult result) {
        String title = result.getDisplayTitle();
        return BrikitString.isSet((String)this.getQueryString()) ? Confluence.getHighlighter((String)this.getQuery()).highlightText(title) : title;
    }

    public String getUseSEO() {
        return this.useSEO;
    }

    public WebInterfaceContext getWebInterfaceContext(SearchResult result) {
        DefaultWebInterfaceContext context = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)super.getWebInterfaceContext());
        context.setParameter("searchResult", (Object)result);
        return context;
    }

    public String getWhere() {
        if (!BrikitString.isSet((String)this.where)) {
            this.setWhere(this.getHostSpaceKey());
        }
        return this.where;
    }

    public boolean isDisplayRichLinks() {
        return this.displayRichLinks;
    }

    public boolean isInheritSpaceLabel() {
        return this.inheritSpaceLabel;
    }

    public boolean isMacroOverridesRichLinksDisplay() {
        return this.macroOverridesRichLinksDisplay;
    }

    @Override
    public boolean isRichLinksDisabled() {
        return this.isMacroOverridesRichLinksDisplay() ? !this.isDisplayRichLinks() : SearchSettings.isRichLinksDisabled();
    }

    public boolean isSearchInTitle() {
        return this.searchInTitle;
    }

    public boolean getShowSpaceCategories() {
        return this.showSpaceCategories;
    }

    @StrutsParameter
    public void setAdditionalFilters(List<String> additionalFilters) {
        this.additionalFilters = additionalFilters;
    }

    @StrutsParameter
    public void setContentTypes(List<String> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public void setContentTypesDisplayMapper(ContentTypesDisplayMapper contentTypesDisplayMapper) {
        this.contentTypesDisplayMapper = contentTypesDisplayMapper;
    }

    @StrutsParameter
    public void setContributor(String contributor) {
        this.contributor = contributor;
    }

    @StrutsParameter
    public void setDisplayRichLinks(boolean displayRichLinks) {
        this.displayRichLinks = displayRichLinks;
    }

    @StrutsParameter
    public void setExcludeFilters(List<String> excludeFilters) {
        this.excludeFilters = excludeFilters;
    }

    @StrutsParameter
    public void setFolksonomyLabels(List<String> folksonomyLabels) {
        this.folksonomyLabels = folksonomyLabels;
    }

    @StrutsParameter
    public void setHiddenFilterGroups(List<String> hiddenFilterGroups) {
        this.hiddenFilterGroups = hiddenFilterGroups;
    }

    @StrutsParameter
    public void setHostSpaceKey(String hostSpaceKey) {
        this.hostSpaceKey = hostSpaceKey;
    }

    @StrutsParameter
    public void setInheritSpaceLabel(boolean inheritSpaceLabel) {
        this.inheritSpaceLabel = inheritSpaceLabel;
    }

    @StrutsParameter
    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    @StrutsParameter
    public void setMacroOverridesRichLinksDisplay(boolean macroOverridesRichLinksDisplay) {
        this.macroOverridesRichLinksDisplay = macroOverridesRichLinksDisplay;
    }

    @StrutsParameter
    public void setMaxLiveResults(int maxLiveResults) {
        this.maxLiveResults = maxLiveResults;
    }

    @StrutsParameter
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setPredefinedSearchBuilder(PredefinedSearchBuilder predefinedSearchBuilder) {
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    @StrutsParameter
    public void setQuery(String queryString) {
        this.setQueryString(queryString);
    }

    @StrutsParameter
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @StrutsParameter
    public void setSearchFilters(List<String> searchFilters) {
        this.searchFilters = searchFilters;
    }

    @StrutsParameter
    public void setSearchInTitle(boolean searchInTitle) {
        this.searchInTitle = searchInTitle;
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    @StrutsParameter
    public void setSearchMode(String searchMode) {
        this.searchMode = searchMode;
    }

    protected void setSearchResults(List<SearchResult> searchResults) {
        this.searchResults = searchResults;
    }

    @StrutsParameter
    public void setSearchScope(List<String> searchScope) {
        this.searchScope = searchScope;
    }

    @StrutsParameter
    public void setShowSpaceCategories(boolean showSpaceCategories) {
        this.showSpaceCategories = showSpaceCategories;
    }

    @StrutsParameter
    public void setShownFilterGroups(List<String> shownFilterGroups) {
        this.shownFilterGroups = shownFilterGroups;
    }

    @StrutsParameter
    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    @StrutsParameter
    public void setSpaceSearchScope(List<String> spaceSearchScope) {
        this.spaceSearchScope = spaceSearchScope;
    }

    @StrutsParameter
    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    protected void setTargetedSearch(TargetedSearch targetedSearch) {
        this.targetedSearch = targetedSearch;
    }

    @StrutsParameter
    public void setUseSEO(String useSEO) {
        this.useSEO = useSEO;
    }

    @StrutsParameter
    public void setWhere(String where) {
        this.where = where;
    }

    public List<FilterGroup> sortByValue(List<FilterGroup> filterGroups) {
        if (this.getShownFilterGroups().isEmpty()) {
            return filterGroups;
        }
        ArrayList<FilterGroup> sorted = new ArrayList<FilterGroup>();
        for (String filterGroupName : this.getShownFilterGroups()) {
            sorted.add(FilterGroup.getFilterGroupByName(filterGroupName));
        }
        return sorted;
    }

    protected String stripMarkup(String content) {
        content = content.replace("&nbsp;", " ");
        content = RendererUtil.stripBasicMarkup((String)content);
        content = content.replace("\\", "");
        content = content.replace("#", "");
        content = content.replace("{{", "");
        content = content.replace("}}", "");
        content = content.replace("\u00a0", " ");
        content = content.replaceAll("\\s+", " ");
        return content;
    }

    protected boolean validateRequest() {
        List<Filter> filters = this.getSearchFilters();
        return BrikitString.isSet((String)this.getQueryString()) || filters != null && !filters.isEmpty();
    }
}

