/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.SearchSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CQLComposer {
    protected static final String ALL_CONTENT_QUERY = "created <= now('+1d')";
    public static final String FILTER_OPTION_ALL = "all";
    public static final String FILTER_OPTION_ANY = "any";
    protected String queryString;
    protected BrikitList<String> searchFilters;
    protected List<String> additionalFilters;
    protected List<String> excludeFilters;
    protected String filterOption;
    protected List<String> searchScope;
    protected List<String> spaceSearchScope;
    protected BrikitList<String> contentTypes;
    protected String lastModified;
    protected BrikitList<String> contributors;
    protected String sortBy;
    protected boolean constrainToFilters;
    protected boolean searchPageTitles;
    protected boolean wildcardSearch;

    public static String urlEncodedQuery(String query) {
        query = query.replaceAll("\\s", "+");
        while (query.contains("'")) {
            query = query.replace("'", "%27");
        }
        while (query.contains("\"")) {
            query = query.replace("\"", "%5C%22");
        }
        return query;
    }

    public String combinedSpaceKeyClause() {
        BrikitList<String> keys = this.getCombinedSpaceKeys();
        return keys.isEmpty() ? null : "space.key in (" + this.quotedJoinedValues(keys) + ")";
    }

    public String combinedSpaceQueryClause() {
        if (Confluence.isConfluenceVersionAtLeast("6.15")) {
            BrikitList<String> orClauses = new BrikitList<String>(2);
            orClauses.add(this.spaceCategoryClause());
            orClauses.add(this.spaceKeyClause());
            orClauses.compact();
            return orClauses.isEmpty() ? null : "(" + orClauses.join(" OR ") + ")";
        }
        return this.combinedSpaceKeyClause();
    }

    public String contentTypeClause() {
        BrikitList<String> types = this.getContentTypes();
        return types.isEmpty() ? "" : "type in (" + types.join(",") + ")";
    }

    public String contributorsClause() {
        if (this.getContributors().isEmpty()) {
            return null;
        }
        BrikitList<String> clauses = new BrikitList<String>(this.getContributors().size());
        for (String username : this.getContributors()) {
            clauses.add("contributor in (\"" + username + "\")");
        }
        return "(" + clauses.join(" OR ") + ")";
    }

    public String cql() {
        BrikitList<String> andClauses = new BrikitList<String>();
        andClauses.add(this.contentTypeClause());
        andClauses.add(this.queryStringClause());
        andClauses.add(this.labelClauseForSearchFilters());
        andClauses.add(this.labelClauseForAdditionalFilters());
        andClauses.add(this.combinedSpaceQueryClause());
        andClauses.add(this.lastModifiedClause());
        andClauses.add(this.contributorsClause());
        andClauses.add(this.requireAtLeastOneFilterClause());
        andClauses.add(this.excludeFiltersClause());
        andClauses.compact();
        String selectClause = andClauses.join(" and ");
        if (!BrikitString.isSet(selectClause)) {
            selectClause = ALL_CONTENT_QUERY;
        }
        String orderClause = BrikitString.isSet(this.getSortBy()) ? " " + this.getSortBy() : "";
        return selectClause + orderClause;
    }

    public String excludeFiltersClause() {
        return this.labelInClauseForFilters(Filter.labelsFromFilters(this.getExcludeFilters()), true);
    }

    public List<String> getAdditionalFilters() {
        if (this.additionalFilters == null) {
            this.additionalFilters = new BrikitList<String>();
        }
        return this.additionalFilters;
    }

    public BrikitList<String> getCombinedFilters() {
        HashSet<String> filterSet = new HashSet<String>(this.getSearchFilters());
        filterSet.addAll(this.getAdditionalFilters());
        BrikitList<String> filters = new BrikitList<String>((Set<String>)filterSet);
        filters.compact();
        return filters;
    }

    public BrikitList<String> getCombinedSpaceKeys() {
        HashSet<String> keySet = new HashSet<String>(this.getSpaceSearchScope());
        if (!this.getSearchScope().isEmpty()) {
            keySet.addAll(Confluence.spaceKeysWithLabels(this.getSearchScope(), true));
        }
        BrikitList<String> keys = new BrikitList<String>((Set<String>)keySet);
        keys.compact();
        return keys;
    }

    public BrikitList<String> getContentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new BrikitList();
        }
        return this.contentTypes;
    }

    public BrikitList<String> getContributors() {
        if (this.contributors == null) {
            this.contributors = new BrikitList();
        }
        return this.contributors;
    }

    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public String getFilterOption() {
        return this.filterOption;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public BrikitList<String> getSearchFilters() {
        if (this.searchFilters == null) {
            this.searchFilters = new BrikitList();
        }
        return this.searchFilters;
    }

    public List<String> getSearchScope() {
        if (this.searchScope == null) {
            this.searchScope = new BrikitList<String>();
        }
        return this.searchScope;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public List<String> getSpaceSearchScope() {
        if (this.spaceSearchScope == null) {
            this.spaceSearchScope = new BrikitList<String>();
        }
        return this.spaceSearchScope;
    }

    public boolean isConstrainToFilters() {
        return this.constrainToFilters;
    }

    public boolean isSearchPageTitles() {
        return this.searchPageTitles;
    }

    public boolean isWildcardSearch() {
        return this.wildcardSearch;
    }

    public String labelClauseForAdditionalFilters() {
        return this.labelClauseForGroupFilters(this.getAdditionalFilters());
    }

    public String labelClauseForGroupFilters(List<String> filters) {
        BrikitList<String> groupSelections = new BrikitList<String>();
        for (Map.Entry<String, List<String>> entry : SearchSettings.sortFilterLabelsByFilterGroup(filters).entrySet()) {
            BrikitList<String> filtersInGroup = new BrikitList<String>(entry.getValue());
            groupSelections.add(this.labelInClauseForFilters(filtersInGroup));
        }
        return groupSelections.isEmpty() ? null : groupSelections.join(" AND ");
    }

    public String labelClauseForSearchFilters() {
        if (FILTER_OPTION_ANY.equals(this.getFilterOption())) {
            return this.labelInClauseForFilters(this.getSearchFilters(), false);
        }
        if (FILTER_OPTION_ALL.equals(this.getFilterOption())) {
            BrikitList<String> clauses = new BrikitList<String>();
            for (String filter : this.getSearchFilters()) {
                clauses.add(this.labelInClauseForFilters(new BrikitList<String>(filter), false));
            }
            return clauses.isEmpty() ? null : clauses.join(" AND ");
        }
        return this.labelClauseForGroupFilters(this.getSearchFilters());
    }

    public String labelInClauseForFilters(BrikitList<String> filters) {
        return this.labelInClauseForFilters(filters, false);
    }

    public String labelInClauseForFilters(BrikitList<String> filters, boolean notIn) {
        return filters == null || filters.isEmpty() ? null : "label " + (notIn ? "not " : "") + "in (" + this.quotedJoinedValues(filters) + ")";
    }

    public String lastModifiedClause() {
        if ("LASTDAY".equals(this.getLastModified())) {
            return "lastmodified >= now('-1d')";
        }
        if ("LASTTWODAYS".equals(this.getLastModified())) {
            return "lastmodified >= now('-2d')";
        }
        if ("LASTWEEK".equals(this.getLastModified())) {
            return "lastmodified >= now('-1w')";
        }
        if ("LASTMONTH".equals(this.getLastModified())) {
            return "lastmodified >= now('-1M')";
        }
        if ("LASTSIXMONTHS".equals(this.getLastModified())) {
            return "lastmodified >= now('-6M')";
        }
        if ("LASTYEAR".equals(this.getLastModified())) {
            return "lastmodified >= now('-1y')";
        }
        if ("LASTTWOYEARS".equals(this.getLastModified())) {
            return "lastmodified >= now('-2y')";
        }
        return null;
    }

    public String queryStringClause() {
        String query = this.getQueryString().trim();
        query = query.replaceAll("\\[", "%5B");
        query = query.replaceAll("\\]", "%5D");
        query = query.replaceAll("\\{", "%7B");
        query = query.replaceAll("\\}", "%7D");
        query = query.replaceAll("\\|", "%7C");
        query = query.replaceAll("\\&", "%26");
        query = query.replaceAll("\\#", "%23");
        query = query.replaceAll("\\\\", "%5C");
        query = query.replaceAll("\\/", "%2F");
        query = query.replaceAll("`", "%60");
        if (this.isWildcardSearch()) {
            query = query + "*";
        }
        query = CQLComposer.urlEncodedQuery(query);
        String searchWhat = this.isSearchPageTitles() ? "title" : "siteSearch";
        return BrikitString.isSet(this.getQueryString()) ? searchWhat + "~!!QUOTE!!SYMBOL!!" + query + "!!QUOTE!!SYMBOL!!" : null;
    }

    public String quotedJoinedValues(BrikitList<String> values) {
        BrikitList<String> quoted = new BrikitList<String>();
        for (String value : values) {
            if ((value = BrikitString.trimToNull(value)) == null) continue;
            quoted.add('\"' + value + '\"');
        }
        return quoted.join(",");
    }

    public String requireAtLeastOneFilterClause() {
        return !this.isConstrainToFilters() || this.getSearchFilters().isEmpty() ? null : this.labelInClauseForFilters(Filter.labelsFromFilters(this.getSearchFilters()));
    }

    public void setAdditionalFilters(List<String> additionalFilters) {
        this.additionalFilters = additionalFilters;
    }

    public void setConstrainToFilters(boolean constrainToFilters) {
        this.constrainToFilters = constrainToFilters;
    }

    public void setContentTypes(List<String> contentTypes) {
        this.contentTypes = new BrikitList();
        for (String type : contentTypes) {
            if (!BrikitString.isSet(type)) continue;
            this.contentTypes.add(type);
        }
    }

    public void setContributors(BrikitList<String> contributors) {
        this.contributors = contributors;
    }

    public void setExcludeFilters(List<String> excludeFilters) {
        this.excludeFilters = excludeFilters;
    }

    public void setFilterOption(String filterOption) {
        this.filterOption = filterOption;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setSearchFilters(List<String> searchFilters) {
        this.searchFilters = new BrikitList<String>(searchFilters);
    }

    public void setSearchPageTitles(boolean searchPageTitles) {
        this.searchPageTitles = searchPageTitles;
    }

    public void setSearchScope(List<String> searchScope) {
        this.searchScope = searchScope;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSpaceSearchScope(List<String> spaceSearchScope) {
        this.spaceSearchScope = spaceSearchScope;
    }

    public void setWildcardSearch(boolean wildcardSearch) {
        this.wildcardSearch = wildcardSearch;
    }

    public String spaceCategoryClause() {
        return this.getSearchScope().isEmpty() ? null : "space.category in (" + this.quotedJoinedValues(new BrikitList<String>(this.getSearchScope())).toLowerCase() + ")";
    }

    public String spaceKeyClause() {
        BrikitList<String> keys = new BrikitList<String>(this.getSpaceSearchScope());
        keys.compact();
        return keys.isEmpty() ? null : "space.key in (" + this.quotedJoinedValues(keys) + ")";
    }
}

