/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BrikitMap<K, V>
extends HashMap<K, V> {
    public static void removeBlanks(Map<String, String> aMap) {
        Iterator<String> it = aMap.values().iterator();
        while (it.hasNext()) {
            String value = it.next();
            if (BrikitString.isSet(value)) continue;
            it.remove();
        }
    }

    public BrikitMap() {
    }

    public BrikitMap(Map<K, V> aMap) {
        super(aMap == null ? new HashMap() : aMap);
    }

    public static boolean equals(Map map1, Map map2) {
        return map1 == null ? map2 == null : map1.equals(map2);
    }

    public static boolean equalsKeySubset(Map map1, Map map2, List keyList) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        boolean equal = true;
        for (Object key : keyList) {
            Object value1 = map1.get(key);
            Object value2 = map2.get(key);
            if (value1 == null && value2 == null) continue;
            if (value1 == null || value2 == null) {
                equal = false;
                continue;
            }
            equal = equal && value1.equals(value2);
        }
        return equal;
    }

    public BrikitList<K> getKeysSortedByValues() {
        BrikitMap<V, K> inverted = this.invert();
        BrikitList keysSortedByValues = new BrikitList();
        for (Object value : inverted.sortedKeys()) {
            keysSortedByValues.add(inverted.get(value));
        }
        return keysSortedByValues;
    }

    public BrikitList<V> getValuesSortedByKeys() {
        BrikitList values = new BrikitList(this.size());
        for (Object key : this.sortedKeys()) {
            values.add(this.get(key));
        }
        return values;
    }

    public BrikitMap<V, K> invert() {
        BrikitMap inverted = new BrikitMap();
        for (Object key : this.keySet()) {
            Object value = this.get(key);
            if (value == null || inverted.containsKey(value)) continue;
            inverted.put(value, key);
        }
        return inverted;
    }

    public BrikitList<K> sortedKeys() {
        BrikitList keys = new BrikitList();
        keys.addAll(this.keySet());
        Collections.sort(keys);
        return keys;
    }

    public BrikitList<V> sortedValues() {
        BrikitList contents = new BrikitList();
        contents.addAll(this.values());
        Collections.sort(contents);
        return contents;
    }
}

