/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.macros.AbstractFacetAwareMacro;
import java.util.Map;

public class TargetedSearchLinkMacro
extends AbstractFacetAwareMacro {
    protected static final String LINK_TITLE_PARAM = "link-title";
    protected static final String SEARCH_QUERY_PARAM = "search-query";
    protected static final String SHOW_AS_BUTTON_PARAM = "show-as-button";
    protected static final String QUERY_STRING = "queryString";
    protected static final String LINK_TITLE_HTML = "linkTitleHTML";
    protected static final String SEARCH_TEXT = "com.brikit.targetedsearch.macros.search";
    protected static final String TEMPLATE = "targeted-search/templates/targeted-search-link.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        this.validateFilterGroups(macroContext);
        this.initializeVelocityContext(macroContext);
        macroContext.velocityContextAdd("action", (Object)this);
        macroContext.velocityContextAdd(LINK_TITLE_HTML, this.getLinkTitleParam(macroContext));
        macroContext.velocityContextAdd(SHOW_AS_BUTTON_PARAM, this.getShowAsButton(macroContext));
        macroContext.velocityContextAdd(QUERY_STRING, this.getSearchQuery(macroContext));
        return this.renderTemplate(TEMPLATE, macroContext);
    }

    protected String getLinkTitleParam(BrikitMacroContext macroContext) {
        return BrikitString.removeTags(macroContext.unsafeStringValue(LINK_TITLE_PARAM, SEARCH_TEXT));
    }

    protected String getSearchQuery(BrikitMacroContext macroContext) {
        return macroContext.stringValue(SEARCH_QUERY_PARAM);
    }

    protected boolean getShowAsButton(BrikitMacroContext macroContext) {
        return macroContext.booleanValue(SHOW_AS_BUTTON_PARAM);
    }
}

