/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.tiles;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitFile;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.tiles.Tile;
import java.io.IOException;

public class AttachmentTile
extends Tile {
    public static final String PINBOARD_ATTACHMENT_TEMPLATE = "pinboards/html/macros/pinboard-attachment-template.vm";
    public static final String PINBOARD_IMAGE_TEMPLATE = "pinboards/html/macros/pinboard-image-template.vm";

    protected AttachmentTile(FeedEntry feedEntry, ConfluenceEntityObject content, ConfluenceActionSupport action) {
        super(feedEntry, content, action);
    }

    public Attachment getAttachment() {
        return (Attachment)this.getContent();
    }

    @Override
    public AbstractPage getPageContext() {
        return Confluence.getPage((Attachment)this.getAttachment());
    }

    @Override
    public String getRenderedContent() throws IOException {
        String storageFormat = this.isImage() ? "<ac:image><ri:attachment ri:filename=\"" + this.getFileName() + "\" /></ac:image>" : "";
        return Confluence.render((String)storageFormat, (AbstractPage)this.getPageContext());
    }

    @Override
    public String getTemplateLocation() {
        return this.isImage() ? PINBOARD_IMAGE_TEMPLATE : PINBOARD_ATTACHMENT_TEMPLATE;
    }

    public String getFileName() {
        return this.getAttachment().getFileName();
    }

    public boolean isImage() {
        return BrikitFile.isImage((String)this.getFileName());
    }
}

