/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.settings;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.bandana.ContentFlowBandanaManager;
import com.brikit.contentflow.model.ContentFlowUtils;
import com.brikit.contentflow.model.DocumentIdentifiers;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;

public class DocumentIdentifierSettings {
    public static final String SPACE_LIBRARY_CODE_KEY = "com.brikit.contentflows.space.library.code";
    public static final String SPACE_DOCUMENT_IDENTIFIER_PATTERN_KEY = "com.brikit.contentflows.space.document.identifier.pattern";
    public static final String SPACE_NEXT_DOCUMENT_NUMBER_KEY = "com.brikit.contentflows.space.next.document.number";
    public static final String PAGE_DOCUMENT_NUMBER_KEY = "com.brikit.contentflows.page.metadata.document.number";
    public static final String PAGE_NEXT_CHILD_DOCUMENT_NUMBER_KEY = "com.brikit.contentflows.page.metadata.next.child.document.number";

    public static void adjustNextAvailableDocumentNumberForPage(Page page, Integer assignedNumber) {
        boolean childOfHome = Confluence.isChildOfHome((Page)page);
        Integer nextAvailable = childOfHome ? DocumentIdentifierSettings.getSpaceNextDocumentNumber(Confluence.getSpace((AbstractPage)page)) : DocumentIdentifierSettings.getNextChildDocumentNumber(Confluence.getParent((Page)page));
        if (assignedNumber == nextAvailable) {
            if (childOfHome) {
                DocumentIdentifierSettings.setSpaceNextDocumentNumber(Confluence.getSpace((AbstractPage)page), assignedNumber + 1);
            } else {
                DocumentIdentifierSettings.setNextChildDocumentNumber(Confluence.getParent((Page)page), assignedNumber + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getAndIncrementSpaceNextDocumentNumber(Space aSpace) {
        String string = aSpace.getKey();
        synchronized (string) {
            Integer nextNumber = DocumentIdentifierSettings.getSpaceNextDocumentNumber(aSpace);
            DocumentIdentifierSettings.setSpaceNextDocumentNumber(aSpace, nextNumber + 1);
            return nextNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getAndIncrementNextChildDocumentNumber(Page parentPage) {
        String string = parentPage.getIdAsString();
        synchronized (string) {
            Integer nextNumber = DocumentIdentifierSettings.getNextChildDocumentNumber(parentPage);
            DocumentIdentifierSettings.setNextChildDocumentNumber(parentPage, nextNumber + 1);
            return nextNumber;
        }
    }

    public static Integer getNextAvailableDocumentNumberForPage(Page page) {
        return Confluence.isChildOfHome((Page)page) ? DocumentIdentifierSettings.getSpaceNextDocumentNumber(Confluence.getSpace((AbstractPage)page)) : DocumentIdentifierSettings.getNextChildDocumentNumber(Confluence.getParent((Page)page));
    }

    public static Integer getNextChildDocumentNumber(Page parentPage) {
        Integer number = BrikitNumber.parseInteger((String)Confluence.getRawData((String)PAGE_NEXT_CHILD_DOCUMENT_NUMBER_KEY, (AbstractPage)parentPage));
        return Math.max(1, number);
    }

    public static Integer getPageDocumentNumber(Page page) {
        return BrikitNumber.parseInteger((String)Confluence.getRawData((String)PAGE_DOCUMENT_NUMBER_KEY, (AbstractPage)page));
    }

    public static String getSpaceDocumentIdentifierPattern(Space aSpace) {
        return ContentFlowBandanaManager.getStringEntry(aSpace, SPACE_DOCUMENT_IDENTIFIER_PATTERN_KEY);
    }

    public static String getSpaceLibraryCode(Space aSpace) {
        return (String)DocumentIdentifierSettings.getSpaceLibraryCodes().get((Object)aSpace.getKey());
    }

    public static BrikitMap<String, String> getSpaceLibraryCodes() {
        return ContentFlowBandanaManager.getMapEntry(null, SPACE_LIBRARY_CODE_KEY);
    }

    public static BrikitMap<String, String> getLibraryCodesByCode() {
        return DocumentIdentifierSettings.getSpaceLibraryCodes().invert();
    }

    public static int getSpaceNextDocumentNumber(Space aSpace) {
        return ContentFlowBandanaManager.getIntegerEntry(aSpace, SPACE_NEXT_DOCUMENT_NUMBER_KEY);
    }

    public static boolean isDocumentIdentifiersEnabled(String libraryCode, String documentIdentifierPattern) {
        return BrikitString.isSet((String)libraryCode) && BrikitString.isSet((String)documentIdentifierPattern);
    }

    public static boolean isDocumentIdentifiersEnabledForPage(AbstractPage abstractPage) {
        return Confluence.isPage((AbstractPage)abstractPage) && DocumentIdentifierSettings.isDocumentIdentifiersEnabledForSpace(Confluence.getSpace((AbstractPage)abstractPage));
    }

    public static boolean isDocumentIdentifiersEnabledForSpace(Space aSpace) {
        return aSpace != null && DocumentIdentifierSettings.isDocumentIdentifiersEnabled(DocumentIdentifierSettings.getSpaceLibraryCode(aSpace), DocumentIdentifierSettings.getSpaceDocumentIdentifierPattern(aSpace));
    }

    public static boolean isDocumentIdentifiersEnabledForSpace(String spaceKey) {
        return DocumentIdentifierSettings.isDocumentIdentifiersEnabledForSpace(Confluence.getSpace((String)spaceKey));
    }

    public static void recalculateAndSaveDocumentNumber(Page page) {
        String identifier = DocumentIdentifiers.composeDocumentIdentifier((AbstractPage)page);
        String pageTitle = identifier + " " + page.getTitle();
        Confluence.saveContentProperty((ContentEntityObject)page, (String)"title", (String)pageTitle);
        Confluence.saveContentProperty((ContentEntityObject)page, (String)"documentId", (String)identifier);
        Confluence.saveContentProperty((ContentEntityObject)page, (String)"pageDocumentNumber", (String)DocumentIdentifiers.leftPad(DocumentIdentifierSettings.getPageDocumentNumber(page), 5, "0"));
    }

    public static void setPageDocumentNumber(Page page, Integer number) {
        Confluence.saveRawData((String)PAGE_DOCUMENT_NUMBER_KEY, (String)number.toString(), (AbstractPage)page);
        DocumentIdentifierSettings.recalculateAndSaveDocumentNumber(page);
        DocumentIdentifierSettings.adjustNextAvailableDocumentNumberForPage(page, number);
        ContentFlowUtils.addPageToIndexQueue((AbstractPage)page);
    }

    public static void setNextChildDocumentNumber(Page parentPage, Integer number) {
        Confluence.saveRawData((String)PAGE_NEXT_CHILD_DOCUMENT_NUMBER_KEY, (String)number.toString(), (AbstractPage)parentPage);
    }

    public static void setSpaceDocumentIdentifierPattern(Space aSpace, String pattern) {
        ContentFlowBandanaManager.saveEntry(aSpace, SPACE_DOCUMENT_IDENTIFIER_PATTERN_KEY, pattern);
    }

    public static void setSpaceLibraryCode(Space space, String code) {
        BrikitMap<String, String> codes = DocumentIdentifierSettings.getSpaceLibraryCodes();
        codes.put((Object)space.getKey(), (Object)code);
        ContentFlowBandanaManager.saveMapEntry(null, SPACE_LIBRARY_CODE_KEY, codes);
    }

    public static void setSpaceNextDocumentNumber(Space aSpace, Integer nextNumber) {
        ContentFlowBandanaManager.saveEntry(aSpace, SPACE_NEXT_DOCUMENT_NUMBER_KEY, nextNumber);
    }
}

