/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.JsonUtils;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.Publisher;
import com.brikit.contentflow.model.Reviewer;
import com.brikit.contentflow.model.WorkflowVisibility;
import com.brikit.contentflow.model.ao.WorkflowAO;
import com.brikit.contentflow.model.query.PageWorkflowQuery;
import com.brikit.contentflow.model.query.WorkflowQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class Workflow
extends AbstractActiveObjectsModel {
    protected static final String NAME_KEY = "name";
    protected static final String VISIBILITY_KEY = "visibility";
    protected static final String REMOVE_PERMISSIONS_NAME = "removePermissionsName";
    protected static final String REMOVE_PERMISSIONS_USER = "removePermissionsUser";
    protected static final String SPACE_CATEGORIES_KEY = "spaceCategories";
    protected static final String SPACE_KEY = "spaceKey";
    protected static final String CREATOR_USERNAME_KEY = "creatorUsername";
    protected static final String PUBLISHING_KEY = "publishing";
    protected static final String ENTRY_PAGE_STATUS_ID_KEY = "entryPageStatusId";
    protected static final String LABELS_KEY = "labels";
    protected static final String EXIT_PAGE_STATUS_ID_KEY = "exitPageStatusId";
    protected static final String DISABLED_KEY = "disabled";
    protected static final String APPROVAL_STEPS_KEY = "approvalSteps";
    public static final String DEFAULT_WORKFLOW_NAME = "Page Preview";
    protected WorkflowAO activeObject;
    protected List<ApprovalStep> approvalSteps;
    protected PageStatus entryPageStatus;
    protected PageStatus exitPageStatus;
    protected Publisher publisher;

    protected Workflow(ActiveObjects activeObjects, WorkflowAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static Workflow createWorkflow(ActiveObjects activeObjects, JSONObject workflowJSON) throws Exception {
        WorkflowAO workflowAO = (WorkflowAO)activeObjects.create(WorkflowAO.class, new DBParam[0]);
        Workflow workflow = new Workflow(activeObjects, workflowAO);
        workflowJSON.put("id", workflow.getID());
        workflowJSON.put(CREATOR_USERNAME_KEY, (Object)Confluence.getUsername());
        workflow.update(activeObjects, workflowJSON);
        return workflow;
    }

    public static Workflow createWorkflow(ActiveObjects activeObjects, String name, boolean publishing, WorkflowVisibility visibility, String removePermissionsName, boolean removePermissionsUser, String spaceKey, String spaceCategories) {
        WorkflowAO workflowAO = (WorkflowAO)activeObjects.create(WorkflowAO.class, new DBParam[0]);
        Workflow workflow = new Workflow(activeObjects, workflowAO);
        workflow.setName(name);
        workflow.setPublishing(publishing);
        workflow.setVisibility(visibility);
        workflow.setRemovePermissionsName(removePermissionsName);
        if (BrikitString.isSet((String)spaceKey)) {
            workflow.setSpaceKey(spaceKey);
        }
        if (BrikitString.isSet((String)spaceCategories)) {
            workflow.setSpaceCategoriesString(spaceCategories);
        }
        workflow.save();
        ApprovalStep approvalStep = ApprovalStep.create(activeObjects, workflow, 1);
        workflow.save();
        return workflow;
    }

    public static void deleteAllWorkflows(ActiveObjects activeObjects) {
        WorkflowQuery query = new WorkflowQuery(activeObjects);
        for (WorkflowAO workflowAO : query.getAllWorkflows()) {
            activeObjects.delete(new RawEntity[]{workflowAO});
        }
    }

    public static String ensureNameIsUnique(ActiveObjects activeObjects, String name, int workflowID) {
        String originalName = name;
        int adjuster = 1;
        while (!Workflow.getWorkflowsByNameExcludingID(activeObjects, name, workflowID).isEmpty()) {
            name = originalName + " " + ++adjuster;
        }
        return name;
    }

    protected static List<Workflow> fromActiveObjects(ActiveObjects activeObjects, WorkflowAO[] workflowAOs) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>(workflowAOs.length);
        for (WorkflowAO workflowAO : workflowAOs) {
            workflows.add(new Workflow(activeObjects, workflowAO));
        }
        return workflows;
    }

    public static List<Workflow> getAllWorkflows(ActiveObjects activeObjects) {
        WorkflowQuery query = new WorkflowQuery(activeObjects);
        return Workflow.fromActiveObjects(activeObjects, query.getAllWorkflows());
    }

    public static List<Workflow> getAvailableWorkflows(ActiveObjects activeObjects, Space aSpace) {
        return Workflow.getAvailableWorkflows(activeObjects, aSpace.getKey());
    }

    public static List<Workflow> getAvailableWorkflows(ActiveObjects activeObjects, String spaceKey) {
        WorkflowQuery query = new WorkflowQuery(activeObjects);
        List<Workflow> workflows = Workflow.getWorkflows(activeObjects, query.getAvailableWorkflows(spaceKey));
        for (Workflow workflow : Workflow.getWorkflows(activeObjects, query.getSpaceCategoryWorkflows())) {
            if (BrikitString.isSet((String)spaceKey) && !Confluence.spaceHasAnyCategory((String)spaceKey, workflow.getSpaceCategories())) continue;
            workflows.add(workflow);
        }
        return workflows;
    }

    public static List<Workflow> getGlobalWorkflows(ActiveObjects activeObjects) {
        WorkflowQuery query = new WorkflowQuery(activeObjects);
        List<Workflow> workflows = Workflow.getWorkflows(activeObjects, query.getGlobalWorkflows());
        workflows.addAll(Workflow.getWorkflows(activeObjects, query.getSpaceCategoryWorkflows()));
        return workflows;
    }

    public static Workflow getWorkflowWithId(ActiveObjects activeObjects, int workflowId) {
        WorkflowQuery query = new WorkflowQuery(activeObjects);
        WorkflowAO foundObject = query.getWorkflowWithId(workflowId);
        return foundObject == null ? null : new Workflow(activeObjects, foundObject);
    }

    public static List<Workflow> getWorkflows(ActiveObjects activeObjects, WorkflowAO[] workflowAOs) {
        List<Workflow> workflows = Workflow.fromActiveObjects(activeObjects, workflowAOs);
        Collections.sort(workflows, new Comparator<Workflow>(){

            @Override
            public int compare(Workflow workflow1, Workflow workflow2) {
                String name1 = BrikitString.trimToString((String)workflow1.getName());
                String name2 = BrikitString.trimToString((String)workflow2.getName());
                return name1.compareToIgnoreCase(name2);
            }
        });
        return workflows;
    }

    public static Workflow getWorkflowByName(ActiveObjects activeObjects, String name) {
        WorkflowQuery query = new WorkflowQuery(activeObjects);
        return (Workflow)((Object)new BrikitList(Workflow.fromActiveObjects(activeObjects, query.getWorkflowsByName(name))).first());
    }

    public static List<Workflow> getWorkflowsByNameExcludingID(ActiveObjects activeObjects, String name, int excludeID) {
        WorkflowQuery query = new WorkflowQuery(activeObjects);
        return Workflow.fromActiveObjects(activeObjects, query.getWorkflowsByNameExcludingID(name, excludeID));
    }

    public static boolean isWorkflowAvailable(ActiveObjects activeObjects, int workflowId, AbstractPage abstractPage) {
        return Workflow.isWorkflowAvailable(activeObjects, workflowId, Confluence.getSpaceKey((AbstractPage)abstractPage));
    }

    public static boolean isWorkflowAvailable(ActiveObjects activeObjects, int workflowId, String spaceKey) {
        for (Workflow workflow : Workflow.getAvailableWorkflows(activeObjects, spaceKey)) {
            if (workflow.getID() != workflowId) continue;
            return true;
        }
        return false;
    }

    public ApprovalStep addApprovalStep(JSONArray reviewersJSON, Long pageStatusKey, ApprovalStep lastStep) throws Exception {
        int position = lastStep == null ? 1 : lastStep.getPosition() + 1;
        ApprovalStep newApprovalStep = ApprovalStep.create(this.getActiveObjects(), this, position, reviewersJSON, pageStatusKey);
        return newApprovalStep;
    }

    public ApprovalStep approvalStepWithID(int id) {
        for (ApprovalStep step : this.getApprovalSteps()) {
            if (step.getID() != id) continue;
            return step;
        }
        return null;
    }

    public int countActivePageWorkflows(String spaceKey) {
        PageWorkflowQuery query = new PageWorkflowQuery(this.getActiveObjects());
        return query.countActivePageWorkflows(this.getActiveObject(), spaceKey);
    }

    public boolean currentUserCanModify() {
        if (Confluence.isAnonymousUser()) {
            return false;
        }
        return Confluence.isConfluenceAdministrator() || Confluence.canAdministerSpace((String)this.getSpaceKey()) || Confluence.getConfluenceUser().equals(this.getCreator());
    }

    public boolean currentUserIsInWorkflow() {
        ConfluenceUser currentUser = Confluence.getConfluenceUser();
        for (ApprovalStep step : this.getApprovalSteps()) {
            if (!step.isReviewer(currentUser)) continue;
            return true;
        }
        return false;
    }

    public ConfluenceUser getCreator() {
        return Confluence.getConfluenceUserByUserKey((String)this.getCreatorUserKeyString());
    }

    public String getCreatorUserKeyString() {
        return this.getActiveObject().getCreatorUserKey();
    }

    public void delete() {
        ContentFlowConfiguration.removeFromSpaceConfigurations(this.getActiveObjects(), this);
        for (ApprovalStep approvalStep : this.getApprovalSteps()) {
            approvalStep.delete();
        }
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public WorkflowAO getActiveObject() {
        return this.activeObject;
    }

    public BrikitList<String> getAllApprovalStepLabels() {
        BrikitList labels = new BrikitList();
        for (ApprovalStep approvalStep : this.getApprovalSteps()) {
            labels.add((Object)approvalStep.getLabel());
        }
        return labels;
    }

    public List<Reviewer> getAllReviewers() {
        ArrayList<Reviewer> reviewers = new ArrayList<Reviewer>();
        for (ApprovalStep step : this.getApprovalSteps()) {
            reviewers.addAll(step.getReviewers());
        }
        return reviewers;
    }

    public List<ApprovalStep> getApprovalSteps() {
        if (this.approvalSteps == null) {
            this.approvalSteps = ApprovalStep.fromActiveObjects(this.getActiveObjects(), this.getActiveObject().getApprovalStepAOs());
            Collections.sort(this.approvalSteps, new Comparator<ApprovalStep>(){

                @Override
                public int compare(ApprovalStep approvalStep, ApprovalStep approvalStep2) {
                    return approvalStep.getPosition() - approvalStep2.getPosition();
                }
            });
        }
        return this.approvalSteps;
    }

    public List<ApprovalStep> getApprovalStepsAfterEditor() {
        List<ApprovalStep> approvalSteps = this.getApprovalSteps();
        if (approvalSteps.size() > 0) {
            approvalSteps.remove(0);
        }
        return approvalSteps;
    }

    public PageStatus getEntryPageStatus() {
        if (this.entryPageStatus == null && this.getActiveObject().getEntryPageStatusAO() != null) {
            this.entryPageStatus = new PageStatus(this.getActiveObjects(), this.getActiveObject().getEntryPageStatusAO());
        }
        return this.entryPageStatus;
    }

    public PageStatus getExitPageStatus() {
        if (this.exitPageStatus == null && this.getActiveObject().getExitPageStatusAO() != null) {
            this.exitPageStatus = new PageStatus(this.getActiveObjects(), this.getActiveObject().getExitPageStatusAO());
        }
        return this.exitPageStatus;
    }

    public ApprovalStep getFirstStep() {
        return (ApprovalStep)((Object)new BrikitList(this.getApprovalSteps()).first());
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public BrikitList<String> getLabels() {
        return BrikitString.splitCommaSeparated((String)this.getLabelsString());
    }

    public String getLabelsString() {
        return this.getActiveObject().getLabels();
    }

    public String getName() {
        return this.getActiveObject().getName();
    }

    public String getRemovePermissionsName() {
        return this.getActiveObject().getRemovePermissionsName();
    }

    public ConfluenceUser getRemovePermissionsUser() {
        return this.hasRemovePermissionsName() && this.isRemovePermissionsUser() ? Confluence.getConfluenceUser((String)this.getRemovePermissionsName()) : null;
    }

    public Space getSpace() {
        return Confluence.getSpace((String)this.getSpaceKey());
    }

    public List<String> getSpaceCategories() {
        return BrikitString.splitCommaSeparated((String)this.getSpaceCategoriesString());
    }

    public String getSpaceCategoriesString() {
        return this.getActiveObject().getSpaceCategories();
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public WorkflowVisibility getVisibility() {
        String visibility = this.getVisibilityString();
        return BrikitString.isSet((String)visibility) ? WorkflowVisibility.valueOf(visibility) : WorkflowVisibility.SPACE;
    }

    public String getVisibilityString() {
        return this.getActiveObject().getVisibility();
    }

    public boolean hasRemovePermissionsName() {
        return BrikitString.isSet((String)this.getRemovePermissionsName());
    }

    public boolean isDisabled() {
        return this.getActiveObject().isDisabled();
    }

    public boolean isFirstStep(ApprovalStep approvalStep) {
        return approvalStep != null && approvalStep.equals((Object)this.getFirstStep());
    }

    public boolean isGlobalWorkflow() {
        return this.getVisibility() == WorkflowVisibility.GLOBAL;
    }

    public boolean isAutomaticPagePreview() {
        return DEFAULT_WORKFLOW_NAME.equals(this.getName());
    }

    public boolean isModifiable() {
        return this.currentUserCanModify();
    }

    public boolean isEditorStep(ApprovalStep approvalStep) {
        BrikitList steps = new BrikitList(this.getApprovalSteps());
        return approvalStep == steps.first();
    }

    public boolean isPublishing() {
        return this.getActiveObject().isPublishing();
    }

    public boolean isRemovePermissionsUser() {
        return this.getActiveObject().getRemovePermissionsUser();
    }

    public boolean isRouting() {
        return !this.isPublishing();
    }

    public boolean isSpaceAutomaticWorkflow(String spaceKey) {
        Workflow automaticWorkflow = ContentFlowConfiguration.getAutomaticWorkflow(this.getActiveObjects(), spaceKey);
        return automaticWorkflow != null && this.equals((Object)automaticWorkflow);
    }

    public boolean isSpaceCategoryWorkflow() {
        return this.getVisibility() == WorkflowVisibility.SPACE_CATEGORIES;
    }

    public boolean isSpaceWorkflow() {
        return this.getVisibility() == WorkflowVisibility.SPACE;
    }

    public ApprovalStep nextStep(ApprovalStep approvalStep) {
        return (ApprovalStep)((Object)new BrikitList(this.getApprovalSteps()).after((Object)approvalStep));
    }

    public ApprovalStep previousStep(ApprovalStep approvalStep) {
        return (ApprovalStep)((Object)new BrikitList(this.getApprovalSteps()).before((Object)approvalStep));
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(WorkflowAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setCreatorUsername(String creatorUsername) {
        this.getActiveObject().setCreatorUserKey(Confluence.getUserKeyString((ConfluenceUser)Confluence.getConfluenceUser((String)creatorUsername)));
    }

    public void setDisabled(boolean disabled) {
        this.getActiveObject().setDisabled(disabled);
    }

    protected void setEntryPageStatusFromKey(Long pageStatusKey) {
        this.entryPageStatus = pageStatusKey == null ? null : PageStatus.getPageStatus(this.getActiveObjects(), pageStatusKey);
        this.getActiveObject().setEntryPageStatusAO(this.entryPageStatus == null ? null : this.entryPageStatus.getActiveObject());
    }

    protected void setExitPageStatusFromKey(Long pageStatusKey) {
        this.exitPageStatus = pageStatusKey == null ? null : PageStatus.getPageStatus(this.getActiveObjects(), pageStatusKey);
        this.getActiveObject().setExitPageStatusAO(this.exitPageStatus == null ? null : this.exitPageStatus.getActiveObject());
    }

    public void setLabels(String labelsString) {
        WorkflowAO workflow = this.getActiveObject();
        if (labelsString == null) {
            workflow.setLabels("");
            return;
        }
        workflow.setLabels(labelsString);
    }

    public void setName(String name) {
        this.getActiveObject().setName(name);
    }

    public void setPublishing(boolean publishing) {
        this.getActiveObject().setPublishing(publishing);
    }

    public void setRemovePermissionsName(String removePermissionsName) {
        this.getActiveObject().setRemovePermissionsName(removePermissionsName);
    }

    public void setRemovePermissionsUser(boolean isUser) {
        this.getActiveObject().setRemovePermissionsUser(isUser);
    }

    public void setSpaceCategories(List<String> spaceCategories) {
        this.setSpaceCategoriesString(new BrikitList(spaceCategories).join(","));
    }

    public void setSpaceCategoriesString(String spaceCategoriesCSV) {
        this.getActiveObject().setSpaceCategories(spaceCategoriesCSV);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }

    public void setVisibility(String visibility) {
        this.getActiveObject().setVisibility(visibility);
    }

    public void setVisibility(WorkflowVisibility visibility) {
        this.setVisibility(visibility.name());
    }

    public void update(ActiveObjects activeObjects, JSONObject workflowJSON) throws Exception {
        int workflowID = workflowJSON.getInt("id");
        if (this.getID() != workflowID) {
            throw new Exception(Confluence.getText((String)"com.brikit.contentflow.workflow.ids.do.not.match"));
        }
        String name = workflowJSON.getString(NAME_KEY);
        name = Workflow.ensureNameIsUnique(activeObjects, name, workflowID);
        this.setName(JsonUtils.getString(workflowJSON, NAME_KEY));
        this.setVisibility(JsonUtils.getString(workflowJSON, VISIBILITY_KEY));
        this.setRemovePermissionsName(JsonUtils.getString(workflowJSON, REMOVE_PERMISSIONS_NAME));
        this.setRemovePermissionsUser(JsonUtils.getBoolean(workflowJSON, REMOVE_PERMISSIONS_USER));
        this.setSpaceCategoriesString(JsonUtils.getString(workflowJSON, SPACE_CATEGORIES_KEY));
        this.setSpaceKey(JsonUtils.getString(workflowJSON, SPACE_KEY));
        this.setCreatorUsername(JsonUtils.getString(workflowJSON, CREATOR_USERNAME_KEY));
        this.setPublishing(JsonUtils.getBoolean(workflowJSON, PUBLISHING_KEY));
        this.setDisabled(JsonUtils.getBoolean(workflowJSON, DISABLED_KEY));
        this.setEntryPageStatusFromKey(JsonUtils.getLong(workflowJSON, ENTRY_PAGE_STATUS_ID_KEY));
        this.setExitPageStatusFromKey(JsonUtils.getLong(workflowJSON, EXIT_PAGE_STATUS_ID_KEY));
        this.setLabels(JsonUtils.getString(workflowJSON, LABELS_KEY));
        int oldIndex = 0;
        int newIndex = 0;
        List<ApprovalStep> oldApprovalSteps = this.getApprovalSteps();
        ApprovalStep lastStep = (ApprovalStep)((Object)new BrikitList(oldApprovalSteps).last());
        JSONArray newApprovalSteps = workflowJSON.getJSONArray(APPROVAL_STEPS_KEY);
        while (oldIndex < oldApprovalSteps.size() || newIndex < newApprovalSteps.length()) {
            ApprovalStep oldApprovalStep = oldIndex < oldApprovalSteps.size() ? oldApprovalSteps.get(oldIndex) : null;
            JSONObject newApprovalStepJSON = newIndex < newApprovalSteps.length() ? newApprovalSteps.getJSONObject(newIndex) : null;
            JSONArray newReviewersJSON = newApprovalStepJSON == null ? new JSONArray() : newApprovalStepJSON.getJSONArray("reviewers");
            Long newPageStatusKey = JsonUtils.getLong(newApprovalStepJSON, "pageStatusId");
            if (oldApprovalStep == null) {
                lastStep = this.addApprovalStep(newReviewersJSON, newPageStatusKey, lastStep);
                ++newIndex;
                continue;
            }
            if (newApprovalStepJSON == null) {
                oldApprovalStep.delete();
                ++oldIndex;
                continue;
            }
            if (newApprovalStepJSON.getLong("id") == 0L) {
                lastStep = this.addApprovalStep(newReviewersJSON, newPageStatusKey, lastStep);
                ++newIndex;
                continue;
            }
            if ((long)oldApprovalStep.getID() == newApprovalStepJSON.getLong("id")) {
                oldApprovalStep.update(newApprovalStepJSON);
                ++oldIndex;
                ++newIndex;
                continue;
            }
            oldApprovalStep.delete();
            ++oldIndex;
        }
        this.save();
    }
}

