/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.settings.PageActivitySettings;
import com.brikit.core.confluence.Confluence;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class PageActivitySpaceAction
extends AbstractSpaceAdminAction {
    protected int historyDays;

    @PermittedMethods(value={HttpMethod.POST})
    public String doDefault() throws Exception {
        PageActivitySettings.setHistoryDays(this.getSpace(), this.getHistoryDays());
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        this.setHistoryDays(PageActivitySettings.getHistoryDays(this.getSpace()));
        return "input";
    }

    public int getHistoryDays() {
        return this.historyDays;
    }

    public boolean isPageActivityEnabled() {
        return PageActivitySettings.isPageActivityEnabled(this.getSpace());
    }

    @StrutsParameter
    public void setHistoryDays(int historyDays) {
        this.historyDays = historyDays;
    }

    public void validate() {
        super.validate();
        if (!Confluence.canAdministerSpace((Space)this.getSpace())) {
            this.addActionError(this.getText("config.insufficient.permissions"));
        }
    }
}

