/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.model.ArchivedPage;
import com.brikit.contentflow.model.Archiver;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.PageApprovalStep;
import com.brikit.contentflow.model.PageReviewer;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.ScheduledPage;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.model.WorkflowPermissions;
import com.brikit.core.actions.ActiveObjectsActionSupport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.Collections;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ContentFlowActionSupport
extends ActiveObjectsActionSupport {
    protected LocalNotificationService notificationService;
    protected WorkflowPermissions workflowPermissions;
    protected Workflow workflow;
    protected PageWorkflow pageWorkflow;
    protected Workflow automaticWorkflow;
    protected ArchivedPage archivedPage;
    protected Archiver archiver;
    protected ScheduledPage scheduledPage;
    protected int workflowId;
    protected long pageId;
    protected String spaceKey;
    protected AbstractPage abstractPage;
    protected Space space;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doDefault() throws Exception {
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() throws Exception {
        return "success";
    }

    public BrikitList<PageStatus> getAllStatuses() {
        BrikitList<PageStatus> statuses = PageStatus.getAll(this.getActiveObjects());
        Collections.sort(statuses);
        return statuses;
    }

    public ArchivedPage getArchivedPage() {
        if (this.archivedPage == null) {
            this.archivedPage = ArchivedPage.getArchivedPageForPage(this.getActiveObjects(), this.getPageId());
        }
        return this.archivedPage;
    }

    public PageApprovalStep getCurrentPageApprovalStep() {
        PageWorkflow pw = this.getPageWorkflow();
        return pw == null ? null : pw.getCurrentPageApprovalStep();
    }

    public PageReviewer getCurrentUserReviewer() {
        PageApprovalStep pageApprovalStep = this.getCurrentPageApprovalStep();
        return pageApprovalStep == null ? null : pageApprovalStep.pageReviewerForCurrentUser();
    }

    public Workflow getDefaultWorkflow() {
        if (this.automaticWorkflow == null) {
            this.automaticWorkflow = ContentFlowConfiguration.getAutomaticWorkflow(this.getActiveObjects(), this.getPageId());
        }
        return this.automaticWorkflow;
    }

    public LocalNotificationService getNotificationService() {
        return this.notificationService;
    }

    public AbstractPage getPage() {
        return this.abstractPage;
    }

    public long getPageId() {
        return this.pageId;
    }

    public PageWorkflow getPageWorkflow() {
        if (this.pageWorkflow == null && this.getPageId() != 0L) {
            this.pageWorkflow = PageWorkflow.getPageWorkflow(this.getActiveObjects(), this.getPageId());
        }
        return this.pageWorkflow;
    }

    public ScheduledPage getScheduledPage() {
        if (this.scheduledPage == null) {
            this.scheduledPage = ScheduledPage.getScheduledPageForPage(this.getActiveObjects(), this.getPage());
        }
        return this.scheduledPage;
    }

    public Space getSpace() {
        if (this.space == null) {
            this.space = Confluence.getSpace((AbstractPage)this.getPage());
        }
        return this.space;
    }

    public ContentFlowConfiguration getSpaceConfiguration() {
        return ContentFlowConfiguration.forSpace(this.getActiveObjects(), this.getSpaceKey());
    }

    public String getSpaceKey() {
        if (this.spaceKey == null) {
            this.spaceKey = Confluence.getSpaceKey((AbstractPage)this.getPage());
        }
        return this.spaceKey;
    }

    public Workflow getWorkflow() {
        if (this.workflow == null) {
            this.workflow = Workflow.getWorkflowWithId(this.getActiveObjects(), this.getWorkflowId());
        }
        return this.workflow;
    }

    public int getWorkflowId() {
        return this.workflowId;
    }

    public WorkflowPermissions getWorkflowPermissions() {
        if (this.workflowPermissions == null) {
            this.workflowPermissions = new WorkflowPermissions(this.getActiveObjects());
        }
        return this.workflowPermissions;
    }

    public boolean hasArchivedPage() {
        return this.getArchivedPage() != null;
    }

    public boolean hasPageWorkflow() {
        return this.getPageWorkflow() != null;
    }

    public boolean hasScheduledPage() {
        return this.getScheduledPage() != null;
    }

    public boolean hasWorkflow() {
        return this.getPageWorkflow() != null;
    }

    public void setNotificationService(LocalNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @StrutsParameter
    public void setPageId(long pageId) {
        this.pageId = pageId;
        if (pageId != 0L) {
            this.abstractPage = Confluence.getPageOrBlogPost((long)pageId);
        }
    }

    protected void setPageWorkflow(PageWorkflow pageWorkflow) {
        this.pageWorkflow = pageWorkflow;
    }

    @StrutsParameter
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
        this.space = BrikitString.isSet((String)spaceKey) ? Confluence.getSpace((String)spaceKey) : null;
    }

    @StrutsParameter
    public void setWorkflowId(int workflowId) {
        this.workflowId = workflowId;
        this.pageWorkflow = null;
    }
}

