/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.settings;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.contentflow.model.ContentFlowUtils;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitString;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class PublishDateManager {
    public static final String PUBLISHED_DATE_KEY = "com.brikit.contentflows.page.metadata.publish.date";

    public static String formatPublishDate(Calendar calendar) {
        return PublishDateManager.formatPublishDate(calendar.getTime());
    }

    public static String formatPublishDate(Calendar calendar, String dateFormat) {
        return PublishDateManager.formatPublishDate(calendar.getTime(), dateFormat);
    }

    public static String formatPublishDate(Date date) {
        return PublishDateManager.formatPublishDate(date, "yyyy-MM-dd");
    }

    public static String formatPublishDate(Date date, String dateFormat) {
        return BrikitDate.formatDateTime((Date)date, (TimeZone)Confluence.getSystemTimeZone(), (String)dateFormat, (boolean)true);
    }

    public static String formatPublishDate(AbstractPage abstractPage, String dateFormat) {
        Calendar calendar = PublishDateManager.getPublishDate(abstractPage);
        if (!BrikitString.isSet((String)dateFormat)) {
            dateFormat = "MM/dd/yyyy";
        }
        return PublishDateManager.formatPublishDate(calendar, dateFormat);
    }

    public static Calendar getPublishDate(AbstractPage abstractPage) {
        String dateString = Confluence.getRawData((String)PUBLISHED_DATE_KEY, (AbstractPage)abstractPage);
        try {
            return BrikitDate.parseDateOnly((String)dateString, (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            return BrikitDate.toCalendar((Date)Confluence.getCreationDate((ContentEntityObject)abstractPage));
        }
    }

    public static boolean hasPublishDate(AbstractPage abstractPage) {
        return BrikitString.isSet((String)Confluence.getRawData((String)PUBLISHED_DATE_KEY, (AbstractPage)abstractPage));
    }

    public static void setPublishDate(AbstractPage abstractPage, Calendar calendar) {
        PublishDateManager.setPublishDate(abstractPage, calendar.getTime());
    }

    public static void setPublishDate(AbstractPage abstractPage, String dateString) throws ParseException {
        PublishDateManager.setPublishDate(abstractPage, BrikitDate.parseDateOnly((String)dateString, (String)"yyyy-MM-dd"));
    }

    public static void setPublishDate(AbstractPage abstractPage, Date date) {
        Confluence.saveRawData((String)PUBLISHED_DATE_KEY, (String)PublishDateManager.formatPublishDate(date), (AbstractPage)abstractPage);
        ContentFlowUtils.addPageToIndexQueue(abstractPage);
    }

    public static void setPublishedDateIfNotSet(AbstractPage abstractPage) {
        if (PublishDateManager.hasPublishDate(abstractPage)) {
            return;
        }
        PublishDateManager.setPublishDate(abstractPage, BrikitDate.getToday());
    }
}

