(function ($) {
	
	ContentFlow.PublishDate = {

		dialog: function (selector) {
			var $dialog = $("#publish-date-dialog");
			return selector ? $(selector, $dialog) : $dialog;
		},
		
		form: function (selector) {
			var $form = ContentFlow.PublishDate.dialog("#publish-date-form");
			return selector ? $(selector, $form) : $form;
		},
		
		initialize: function(response) {
			var options = {
				title: ContentFlow.getText("com.brikit.contentflow.set.publish.date"),
				id: "publish-date-dialog",
				okButton: ContentFlow.getText("com.brikit.contentflow.save.name"),
				closeWithButtonOnly: true
			};

            ContentFlow.Dialog2.dialog(response, options, ContentFlow.PublishDate.savePublishDate);

			$("#publish-date-field").datePicker({overrideBrowserDefault: true});

			ContentFlow.PublishDate.form().submit(function () { return false} );
        },

		savePublishDate: function (dialog) {
			ContentFlow.PublishDate.dialog(".dialog-button-panel .button-panel-button").spin();
			
			var $form = ContentFlow.PublishDate.form();
			$.ajax({
				url: $form.attr("action"),
				data: $form.serialize(),
				method: "POST",
				success: ContentFlow.reloadBrowser,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while saving the publish date.", errorThrown);
				}
			})
		},
		
		showSelector: function (event) {
			event.preventDefault();
	        jQuery.ajax({
	            url: $(this).attr("href"),
				data: {
					pageId: ContentFlow.pageId
				},
	            success: ContentFlow.PublishDate.initialize,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while loading the publish date panel.", errorThrown);
	            }
	        });
		}
		
	};
	
	ContentFlow.toInit(function ($) {
		$("#content-flow-set-publish-date").click(ContentFlow.PublishDate.showSelector);
	});

})(jQuery);
