(function ($) {
	//
	// handles the workflow control widgets in the Page metadata banner
	//
	ContentFlowControls = function () {
		var self = this;
		self.applyWorkflowTrigger = $("#apply-workflow-trigger");
		self.approveWorkflowTrigger = $("#approve-workflow-trigger");
		self.initialize();
	};
	
	Object.assign(ContentFlowControls.prototype, {
		
		initialize: function () {
			this.initializeApplyWorkflowTrigger();
			this.initializeApproveWorkflowTrigger();
		},
		
		initializeApplyWorkflowTrigger: function () {
			var self = this;
		
			self.applyWorkflowTrigger.click(function (e) { e.preventDefault(); self.openApplyWorkflowDialog(this); });
			self.applyWorkflowTrigger.find("span").addClass("aui-icon aui-icon-small aui-iconfont-configure");
		},
				
		initializeApproveWorkflowTrigger: function () {
			var self = this;
		
			self.approveWorkflowTrigger.click(function (e) { e.preventDefault(); self.openApproveWorkflowDialog(this); });
		
			self.approveWorkflowTrigger.spin();
		
	        jQuery.ajax({
	            url: ContentFlow.contextPath + "/plugins/contentflow/pageworkflowstatus.action",
				data: {pageId: self.pageId()},
				dataType: "json",
	            success: function (pageStatus) { 
					self.initializeApproveWorkflowTriggerResponse(pageStatus); 
				},
	            error: function (xhRequest, textStatus, errorThrown) {
					self.approveWorkflowTrigger.spinStop();
	                console.log("An error occurred while checking page content flow status.", errorThrown);
	            }
	        });
		},
		
		// ORIGINALLY:  Set icons in toolbar view.  Currently (alpha):  initializes state of content flow 
		// dialog and anchor icon in page title meta-data area.
		//
		// Initialize the workflow banner controls that appear near Page title
		// -workflow		apply workflow
		// *-*-o-o			workflow in progress (Approve if it's your turn, View otherwise)
		// -locked			publishes on approval
		// -success			published
		// -time only		scheduled
		// -success & -time published, but will archive on a given date
		// -flag			needs review
		initializeApproveWorkflowTriggerResponse: function (pageStatus) {
			var self = this;
			// self.trigger.removeClass("loading").attr("title", "No one can see this")
			// 		.find("span").spinStop().addClass("aui-lozenge aui-lozenge-subtle aui-lozenge-moved").html("Draft");

			self.approveWorkflowTrigger.spinStop();
			var waitingIcon = self.approveWorkflowTrigger.find("span");
			var userCanEdit = pageStatus.canEdit;
			
			// If action required of current user, ensure workflow icon appears and add color cue
			if (pageStatus.waitingForUser && !pageStatus.complete) { 
				waitingIcon.addClass("icon-cf-workflow");
				// TODO: Switch to adding a css class once design team is done (JIRA ticket: FLOW-359)
				waitingIcon.css('color', 'crimson');
			}
			// If a workflow is active AND user has edit permissions, ensure workflow icon appears.
			// 'canEdit' hides the workflow widget from read-only users
			else if (pageStatus.active && userCanEdit) {
				waitingIcon.addClass("icon-cf-workflow");
				if (!pageStatus.complete) {
					// TODO: Switch to adding a class once design team is done (JIRA ticket: FLOW-359)
					waitingIcon.css('color', 'goldenrod');
				}
			}
			// If no workflow has been applied yet (AND user has edit permissions) ensure workflow icon appears
			else if (!pageStatus.active && userCanEdit) {
				waitingIcon.addClass("icon-cf-pagesettings");
			}
			return;
			//
			// TODO: CC: The code below is unreachable... Is this ALL from the old toolbar icons?  
			//
			
			$link = ContentFlow.toolbarButton().empty();
	
			$link.adjustClass("aui-button-subtle", !pageStatus.waitingForUser && !pageStatus.needsReview);

			var addIcon = function ($link, className, text, tooltip) {
			    $link.append($("<span>").addClass("aui-icon aui-icon-small aui-iconfont-" + className));
				if (text) $link.append($("<span>").text(text).addClass("link-text"));
				if (tooltip) $link.attr("title", tooltip);
			}

			if (pageStatus.needsReview) addIcon($link, "flag", false, ContentFlow.getText("com.brikit.contentflow.page.needs.review"));
			if (pageStatus.publishOnApproval && !pageStatus.complete) addIcon($link, "locked", false, ContentFlow.getText("com.brikit.contentflow.page.not.published"));
			if (pageStatus.scheduled || pageStatus.timeLimited) addIcon($link, "time");

			if (pageStatus.complete) {
				addIcon($link, "success", false, (pageStatus.needsReview ? false : ContentFlow.getText("com.brikit.contentflow.page.published")));
				$link.append(ContentFlow.getText("com.brikit.contentflow.approved.name"))
			}
			else if (!pageStatus.active) {
				addIcon($link, "workflow", ContentFlow.getText("com.brikit.contentflow.workflow.name"), ContentFlow.getText("com.brikit.contentflow.add.workflow"));
			}
			else {
				var $tracker = $("<div>").attr("id", "thumbnail-tracker");
				// $tracker.append($("<div>").addClass("path"));
				var $ul = $("<ul>");
				$(pageStatus.stepStates).each(function () { 
					$ul.append($("<li>").addClass("step " + this.toString()));
				});
				$link.append($tracker.append($ul));

				// Create a gradient for the path background that follows the progress of completed steps
				var steps = $ul.find("li").length;
				var complete = $ul.find("li.complete").length;
				// if (complete > 0) complete -= 1;
				var change = 3 + complete * 12 + "px";
				var stop = 3 + steps * 12 + "px";
		
				var color1 = pageStatus.waitingForUser ? " #777 " : " #777 ";
				var color2 = pageStatus.waitingForUser ? " #AAA " : " #AAA ";
				var gradient = "linear-gradient(90deg," + color1 + "3px," + color1 + change + "," + color2 + change + "," + color2 + stop + ")";

				$tracker.css({ background: gradient, backgroundClip: "content-box" });
			}
	    },
		
		openApplyWorkflowDialog: function (trigger) {
			// Get the dialog from the DOM; if there isn't one, create one; show it
			var dialog = $(trigger).data("dialog") || new ContentFlowApplyDialog(trigger);
			dialog.show();
		},
		
		openApproveWorkflowDialog: function (trigger) {
			// Get the dialog from the DOM; if there isn't one, create one; show it
			var dialog = $(trigger).data("dialog") || new ContentFlowApproveDialog(trigger);
			dialog.show();
		},
		
		pageId: function () {
			return typeof(pageId) == "undefined" ? ContentFlow.pageId : pageId;
		},

		updateTrigger: function (trigger, options) {
			if (options.classNames) trigger.find("span").attr("class", options.classNames);ss
			if (options.text) trigger.find("span").html(options.text);
			if (options.tooltip) trigger.attr("title", options.tooltip);
		}
	});
	
	ContentFlow.toFinalize(function ($) {
		
		// TODO:  See comment on dialog.js (ContentFlowDialog.updateTrigger())
		if (ContentFlow.pageId && $("#approve-workflow-trigger, #apply-workflow-trigger").length) ContentFlow.controls = new ContentFlowControls();
	});
	
	
})(jQuery);
