/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.BlueprintPage;
import com.brikit.blueprintmaker.model.PageBlueprintType;
import com.brikit.core.confluence.BrikitVelocityContext;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitOrderedMap;
import com.brikit.core.util.BrikitString;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PageBlueprint {
    protected String name;
    protected String spaceKey;
    protected String pageTitle;
    protected String description;
    protected PageBlueprintType type;
    protected List<BlueprintField> blueprintFieldsFromPageBlueprint;
    protected List<String> spaceCategories;
    protected BrikitOrderedMap<String, BlueprintField> allBlueprintFields;
    protected Integer workflowId;

    public static Integer appliedWorkflow(AbstractPage abstractPage) {
        Object contentFlow = PageBlueprint.getContentFlowVelocityContext();
        if (contentFlow != null) {
            try {
                Method method = contentFlow.getClass().getMethod("getActiveWorkflowId", AbstractPage.class);
                return (Integer)method.invoke(contentFlow, abstractPage);
            }
            catch (Exception ex) {
                BrikitLog.logDebug((String)("Failed to look for active workflow on page " + String.valueOf(abstractPage)));
            }
        }
        return null;
    }

    protected static Object getContentFlowVelocityContext() {
        Map velocityContext = BrikitVelocityContext.getDefaultVelocityContext();
        return velocityContext.get("contentFlow");
    }

    public PageBlueprint(String name, String spaceKey, String pageTitle, String description, List<BlueprintField> blueprintFieldsFromPageBlueprint, PageBlueprintType type, List<String> spaceCategories, Integer workflowId) {
        this.setName(name);
        this.setSpaceKey(spaceKey);
        this.setPageTitle(pageTitle);
        this.setDescription(description);
        this.setBlueprintFieldsFromPageBlueprint(blueprintFieldsFromPageBlueprint);
        this.setType(type);
        this.setSpaceCategories(spaceCategories);
        this.setWorkflowId(workflowId);
    }

    public PageBlueprint(AbstractPage pageUsedPreviouslyAsTemplate) {
        this("Previously Used Template", Confluence.getSpaceKey((AbstractPage)pageUsedPreviouslyAsTemplate), pageUsedPreviouslyAsTemplate.getTitle(), "", new ArrayList<BlueprintField>(), PageBlueprintType.PAGE, new ArrayList<String>(), null);
    }

    protected void applyWorkflow(AbstractPage page) {
        Object contentFlow;
        if (this.getWorkflowId() != null && (contentFlow = PageBlueprint.getContentFlowVelocityContext()) != null) {
            try {
                Method method = contentFlow.getClass().getMethod("applyWorkflow", Integer.class, AbstractPage.class, Boolean.class);
                method.invoke(contentFlow, this.getWorkflowId(), page, true);
            }
            catch (Exception ex) {
                BrikitLog.logDebug((String)("Failed to apply workflow " + this.getWorkflowId() + " to page " + String.valueOf(page)));
            }
        }
    }

    public BrikitOrderedMap<String, BlueprintField> getAllBlueprintFields() {
        if (this.allBlueprintFields == null) {
            this.allBlueprintFields = new BrikitOrderedMap();
            for (BlueprintField field : this.getBlueprintFieldsFromPageBlueprint()) {
                this.allBlueprintFields.put((Object)field.getId(), (Object)field);
            }
            for (BlueprintField field : this.getBlueprintFieldsFromBlueprintPages()) {
                this.allBlueprintFields.putIfAbsent((Object)field.getId(), (Object)field);
            }
        }
        return this.allBlueprintFields;
    }

    protected List<BlueprintField> getBlueprintFieldsFromBlueprintPages() {
        List<Page> pages = Arrays.asList(this.getConfluencePage());
        if (this.includeChildren()) {
            pages.addAll(Confluence.getDescendants((Page)this.getConfluencePage()));
        }
        ArrayList<BlueprintField> fields = new ArrayList<BlueprintField>();
        for (Page page : pages) {
            for (BlueprintField pageField : BlueprintPage.get((AbstractPage)page).getFields()) {
                BlueprintField field = BlueprintDefinitions.getBlueprintField(pageField.getName());
                if (field == null) {
                    field = pageField;
                }
                if (fields.contains(field)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public List<BlueprintField> getBlueprintFieldsFromPageBlueprint() {
        return this.blueprintFieldsFromPageBlueprint;
    }

    public Page getConfluencePage() {
        return Confluence.getPage((String)this.getSpaceKey(), (String)this.getPageTitle());
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        if (!BrikitString.isSet((String)this.name)) {
            this.name = this.getPageTitle();
        }
        return this.name;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public List<String> getSpaceCategories() {
        if (this.spaceCategories == null) {
            this.spaceCategories = new ArrayList<String>();
        }
        return this.spaceCategories;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public PageBlueprintType getType() {
        return this.type;
    }

    public Integer getWorkflowId() {
        return this.getType() == PageBlueprintType.PAGE ? this.workflowId : null;
    }

    public boolean includeChildren() {
        return this.getType() == PageBlueprintType.TREE;
    }

    public boolean isVisibleInSpace(Space space) {
        return space != null && this.isVisibleInSpace(space.getKey());
    }

    public boolean isVisibleInSpace(String spaceKey) {
        return this.getSpaceCategories().isEmpty() || BrikitString.isSet((String)spaceKey) && Confluence.spaceHasAnyCategory((String)spaceKey, this.getSpaceCategories());
    }

    public void setBlueprintFieldsFromPageBlueprint(List<BlueprintField> blueprintFieldsFromPageBlueprint) {
        this.blueprintFieldsFromPageBlueprint = blueprintFieldsFromPageBlueprint;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(PageBlueprintType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public void setSpaceCategories(List<String> spaceCategories) {
        this.spaceCategories = spaceCategories;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setWorkflowId(Integer workflowId) {
        this.workflowId = workflowId;
    }

    protected void suspendAutomaticWorkflows() {
        this.temporarilyAdjustAutomaticWorkflows("addUserToIgnoreList");
    }

    protected void temporarilyAdjustAutomaticWorkflows(String methodName) {
        Object contentFlow;
        if (this.getWorkflowId() != null && (contentFlow = PageBlueprint.getContentFlowVelocityContext()) != null) {
            try {
                Method method = contentFlow.getClass().getMethod(methodName, String.class);
                method.invoke(contentFlow, Confluence.getUsername());
            }
            catch (Exception ex) {
                BrikitLog.logDebug((String)("Failed to adjust automatic workflows for " + Confluence.getUsername()));
            }
        }
    }

    protected void unsuspendAutomaticWorkflows() {
        this.temporarilyAdjustAutomaticWorkflows("removeUserFromIgnoreList");
    }
}

