/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.BlueprintFieldType;
import com.brikit.blueprintmaker.model.ContentMaker;
import com.brikit.blueprintmaker.model.CopyPageBlueprint;
import com.brikit.blueprintmaker.model.FieldSwapper;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.PageFields;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlueprintPage {
    public static final String TEMPLATE_DATA_KEY = "com.brikit.blueprintmaker.page.template";
    public static final String DATA_TEMPLATE_FIELD_MACRO_KEY = "data-template-field";
    public static final String NAME_PARAM = "name";
    public static final String REQUIRED_PARAM = "required";
    public static final String TYPE_PARAM = "type";
    public static final String HELP_PARAM = "help";
    public static final String PLACEHOLDER_PARAM = "placeholder";
    public static final String VALIDATION_PARAM = "validation";
    public static final String DATA_TEMPLATE_DEFAULTS_MACRO_KEY = "data-template-defaults";
    public static final String PARENT_PAGE_PARAM = "parent-page";
    public static final String PAGE_TITLE_PARAM = "page-title";
    public static final String LABELS_PARAM = "labels";
    public static final String BLUEPRINT_NAME_PARAM = "blueprint-name";
    public static final String DEFAULT_TYPE = BlueprintFieldType.TEXT.getName();
    public static final String MARKUP_DELIMITER = "\\|\\|";
    protected long templatePageId;
    protected AbstractPage confluencePage;

    public static AbstractPage copyPage(AbstractPage pageToCopy, String spaceKey, String pageTitle, Page destinationParent) throws Exception {
        CopyPageBlueprint pageBlueprint = new CopyPageBlueprint(spaceKey, pageToCopy);
        return BlueprintPage.createFromPageBlueprint(pageBlueprint, spaceKey, pageTitle, destinationParent, "[]", (Map<String, AttachmentResource>)Collections.EMPTY_MAP, (List<String>)Collections.EMPTY_LIST);
    }

    public static AbstractPage createFromPageBlueprint(String blueprintName, String spaceKey, String pageTitle, Page destinationParent, String valuesJson, Map<String, AttachmentResource> fileResources, List<String> pageLabels) throws Exception {
        PageBlueprint pageBlueprint = BlueprintDefinitions.getPageBlueprint(blueprintName);
        if (pageBlueprint == null) {
            throw new Exception("Page blueprint not found.");
        }
        return BlueprintPage.createFromPageBlueprint(pageBlueprint, spaceKey, pageTitle, destinationParent, valuesJson, fileResources, pageLabels);
    }

    public static AbstractPage createFromPageBlueprint(PageBlueprint pageBlueprint, String spaceKey, String pageTitle, Page destinationParent, String valuesJson, Map<String, AttachmentResource> fileResources, List<String> pageLabels) throws Exception {
        if (pageBlueprint == null) {
            throw new Exception("Page blueprint not specified.");
        }
        if (destinationParent == null) {
            throw new Exception("Destination parent page not found.");
        }
        ContentMaker contentMaker = new ContentMaker(pageBlueprint, destinationParent, valuesJson, fileResources);
        AbstractPage newPage = contentMaker.createPage(pageTitle);
        for (String label : pageLabels) {
            label = contentMaker.getFieldSwapper().applyData(label);
            Confluence.addLabel((String)label, (AbstractPage)newPage);
        }
        return newPage;
    }

    public static AbstractPage regeneratePageFromBlueprint(String blueprintName, String originalPageId, String pageTitle, String valuesJson, Map<String, AttachmentResource> fileResources, List<String> pageLabels) throws Exception {
        AbstractPage originalPageTemplate;
        PageBlueprint pageBlueprint = BlueprintDefinitions.getPageBlueprint(blueprintName);
        AbstractPage originalPage = Confluence.getPageOrBlogPost((String)originalPageId);
        if (pageBlueprint == null && (originalPageTemplate = PageFields.pageTemplate(originalPage)) != null) {
            pageBlueprint = new PageBlueprint(originalPageTemplate);
        }
        Page parentPage = Confluence.isPage((AbstractPage)originalPage) ? Confluence.getParent((Page)((Page)originalPage)) : null;
        ContentMaker contentMaker = new ContentMaker(pageBlueprint, parentPage, valuesJson, fileResources);
        AbstractPage newPage = contentMaker.recreatePageFromBlueprint(originalPage, pageBlueprint.getConfluencePage(), false, pageTitle);
        for (String label : pageLabels) {
            label = contentMaker.getFieldSwapper().applyData(label);
            Confluence.addLabel((String)label, (AbstractPage)newPage);
        }
        return newPage;
    }

    public static BlueprintPage get(long templatePageId) {
        BlueprintPage blueprintPage = new BlueprintPage();
        blueprintPage.setTemplatePageId(templatePageId);
        return blueprintPage;
    }

    public static BlueprintPage get(String templatePageIdString) {
        return BlueprintPage.get(BrikitNumber.longValue((String)templatePageIdString));
    }

    public static BlueprintPage get(AbstractPage abstractPage) {
        return BlueprintPage.get(abstractPage.getId());
    }

    public static boolean isTemplate(AbstractPage abstractPage) {
        return BlueprintPage.get(abstractPage.getId()).readData() != null;
    }

    protected BlueprintField fieldFromMacro(MacroDefinition macro) {
        String name = MacroParser.getStringParameter((MacroDefinition)macro, (String)NAME_PARAM);
        if (!BrikitString.isSet((String)name) || FieldSwapper.isStandardSubstitution(name)) {
            return null;
        }
        boolean required = MacroParser.getBooleanParameter((MacroDefinition)macro, (String)REQUIRED_PARAM);
        String type = MacroParser.getStringParameter((MacroDefinition)macro, (String)TYPE_PARAM);
        if (!BrikitString.isSet((String)type)) {
            type = DEFAULT_TYPE;
        }
        String help = MacroParser.getStringParameter((MacroDefinition)macro, (String)HELP_PARAM);
        String placeholder = MacroParser.getStringParameter((MacroDefinition)macro, (String)PLACEHOLDER_PARAM);
        String validation = MacroParser.getStringParameter((MacroDefinition)macro, (String)VALIDATION_PARAM);
        return BlueprintField.create(name, type, help, placeholder, validation, required);
    }

    protected BlueprintField fieldFromMarkup(String markup) {
        BrikitList bits = BrikitString.split((String)markup, (String)MARKUP_DELIMITER);
        if (bits.isEmpty()) {
            return null;
        }
        String name = (String)bits.get(0);
        if (FieldSwapper.isStandardSubstitution(name)) {
            return null;
        }
        boolean required = name.endsWith("*");
        if (required) {
            name = name.substring(0, name.length() - 1);
        }
        String type = bits.size() > 1 ? (String)bits.get(1) : null;
        String help = bits.size() > 2 ? (String)bits.get(2) : null;
        String placeholder = bits.size() > 3 ? (String)bits.get(3) : null;
        String validation = bits.size() > 4 ? (String)bits.get(4) : null;
        return BlueprintField.create(name, type, help, placeholder, validation, required);
    }

    public AbstractPage getConfluencePage() {
        if (this.confluencePage == null) {
            this.confluencePage = Confluence.getPageOrBlogPost((long)this.getTemplatePageId());
        }
        return this.confluencePage;
    }

    public List<String> getFieldNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (BlueprintField field : this.getFields()) {
            names.add(field.getName());
        }
        return names;
    }

    public List<BlueprintField> getFields() {
        ArrayList<BlueprintField> fieldList = new ArrayList<BlueprintField>();
        String pageBody = this.getTemplateStorageFormat();
        try {
            List macros = MacroParser.extractMacrosFromStorageFormat((AbstractPage)this.getConfluencePage(), (String)pageBody, (String)DATA_TEMPLATE_FIELD_MACRO_KEY);
            for (MacroDefinition macro : macros) {
                fieldList.add(this.fieldFromMacro(macro));
            }
        }
        catch (XhtmlException ex) {
            BrikitLog.logDebug((String)("Unable to read macros from template page " + String.valueOf(this.getConfluencePage())), (Exception)((Object)ex));
        }
        Pattern pattern = Pattern.compile("\\[\\[^\\-(.+?)^\\-\\]\\]");
        Matcher matcher = pattern.matcher(pageBody);
        while (matcher.find()) {
            fieldList.add(this.fieldFromMarkup(matcher.group(1)));
        }
        matcher = pattern.matcher(this.getTemplateTitle());
        while (matcher.find()) {
            fieldList.add(this.fieldFromMarkup(matcher.group(1)));
        }
        HashMap<String, BlueprintField> fields = new HashMap<String, BlueprintField>();
        for (BlueprintField field : fieldList) {
            if (field == null) continue;
            BlueprintField previous = (BlueprintField)fields.get(field.getName());
            if (previous != null) {
                if (!BrikitString.isSet((String)previous.getHelpText())) {
                    previous.setHelpText(field.getHelpText());
                }
                if (previous.getType() != null) continue;
                previous.setType(field.getType());
                continue;
            }
            fields.put(field.getName(), field);
        }
        return new ArrayList<BlueprintField>(fields.values());
    }

    public String getSpaceKey() {
        return this.getConfluencePage().getSpaceKey();
    }

    public long getTemplatePageId() {
        return this.templatePageId;
    }

    public String getTemplateStorageFormat() {
        return Confluence.getBodyAsString((ContentEntityObject)this.getConfluencePage());
    }

    public String getTemplateTitle() {
        return Confluence.getTitle((AbstractPage)this.getConfluencePage());
    }

    public boolean hasTemplateFields() {
        return !this.getFields().isEmpty();
    }

    public void makeTemplate() {
        this.saveData(true);
    }

    protected JSONObject readData() {
        String data = Confluence.getRawData((String)TEMPLATE_DATA_KEY, (AbstractPage)this.getConfluencePage());
        if (!BrikitString.isSet((String)data)) {
            return null;
        }
        try {
            return new JSONObject(data);
        }
        catch (Exception ex) {
            BrikitLog.logDebug((String)("Error reading template data from " + String.valueOf(this.getConfluencePage())), (Exception)ex);
            return null;
        }
    }

    protected void saveData(boolean becomeTemplate) {
        JSONObject data = new JSONObject();
        data.put("isTemplate", true);
        Confluence.saveRawData((String)TEMPLATE_DATA_KEY, (String)(becomeTemplate ? data.toString() : null), (AbstractPage)this.getConfluencePage());
    }

    public void setTemplatePageId(long templatePageId) {
        this.templatePageId = templatePageId;
    }

    public void unmakeTemplate() {
        this.saveData(false);
    }

    public static AbstractPage updateLiveBlueprint(String blueprintName, String pageId, String macroId, String valuesJson, Map<String, AttachmentResource> fileResources) throws Exception {
        AbstractPage page = Confluence.getPageOrBlogPost((String)pageId);
        MacroDefinition oldMacro = MacroParser.findMacroById((AbstractPage)page, (String)macroId);
        MacroDefinition newMacro = MacroParser.clone((MacroDefinition)oldMacro);
        MacroParser.setParameter((MacroDefinition)newMacro, (String)BLUEPRINT_NAME_PARAM, (String)blueprintName, (AbstractPage)page);
        FieldSwapper fieldSwapper = new FieldSwapper();
        fieldSwapper.addValues(valuesJson);
        String properties = fieldSwapper.toProperties();
        MacroParser.setBodyPlainText((MacroDefinition)newMacro, (String)properties);
        MacroParser.replaceMacro((AbstractPage)page, (String)macroId, (MacroDefinition)newMacro, (String)"", (boolean)false);
        return page;
    }

    public void updatePageTemplateStatus() {
        this.saveData(this.hasTemplateFields());
    }
}

