(function ($) {
	
	BrikitColumnEntry = function (entry, column, options) {
		this.$entry = $(entry);
		this.$entry.data("entry", this);
		this.data = options.data;
		this.column = column;
		this.initialize();
	};
	
	var prototype = BrikitColumnEntry.prototype;
	
	prototype.$find = function (selector) {
		return selector ? $(selector, this.$entry) : this.$entry;
	};
	
	prototype.childColumn = function (column) {
		if (column) this.childColumn = column;
		return this.childColumn;
	}
	
	prototype.data = function (name, data) {
		return this.find().data(name, data);
	};
	
	// Set the selected state for clicked element.
	// Shift, Meta, and Ctrl keys toggle selected state off.
	// Return true if the selected state changed as a result of the click.
	prototype.entryClicked = function (event) {
		
		if (this.column.browser.isFrozen()) return false;

		var stateChanged = false;
		var shouldSelect = !event.shiftKey && !event.metaKey && !event.ctrlKey;
		var alreadySelected = this.isSelected();
		stateChanged = shouldSelect != alreadySelected;
	
		if (shouldSelect == alreadySelected) return false;
	
		if (shouldSelect != alreadySelected) this.column.unselectEntries();
		if (shouldSelect) this.$find().addClass("selected");

		var event = jQuery.Event(event);
		event.type = "selection";
		event.entry = this;
		this.$find().trigger(event);
	};
	
	prototype.getText = function () {
		return this.$find().text();
	};
	
	prototype.initialize = function () {
		this.column.$scroller().append(this.$find());
	};
	
	prototype.isSelected = function () {
		return this.$find().hasClass("selected");
	};

	prototype.setEnablement = function () {
	};
	
	$.fn.brikitColumnEntry = function (column, options) {
	    return this.each(function() {
			new BrikitColumnEntry(this, column, options);
	    });
	};

})(jQuery);
