/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.brikit.core.util.BrikitString;
import java.util.HashMap;
import java.util.Map;

public enum BlueprintFieldType {
    DEFAULT("default"),
    SHORT("short"),
    MEDIUM("medium"),
    LONG("long"),
    TEXT("text"),
    EMAIL("email"),
    DATE("date"),
    INTEGER("integer"),
    DECIMAL("decimal"),
    FILE("file"),
    URL_PARAM("url_param"),
    USER("user"),
    GROUP("group"),
    SPACE("space"),
    PAGE("page"),
    LIST("list");

    private static Map<String, BlueprintFieldType> types;
    private String name;

    protected static Map<String, BlueprintFieldType> getTypes() {
        if (types == null) {
            types = new HashMap<String, BlueprintFieldType>();
            for (BlueprintFieldType fieldType : BlueprintFieldType.values()) {
                types.put(fieldType.getName(), fieldType);
            }
        }
        return types;
    }

    public static BlueprintFieldType get(String name) {
        return BrikitString.isSet(name) ? BlueprintFieldType.getTypes().get(name.toLowerCase()) : null;
    }

    private BlueprintFieldType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

