/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.actions;

import com.brikit.blueprintmaker.actions.BlueprintMakerActionSupport;
import com.brikit.blueprintmaker.model.Access;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.PageBlueprint;
import com.brikit.blueprintmaker.model.SpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitOrderedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ViewBlueprintsAction
extends BlueprintMakerActionSupport {
    public String execute() throws Exception {
        return "success";
    }

    public String fieldIds(PageBlueprint pageBlueprint) {
        BrikitList fieldIds = new BrikitList();
        for (BlueprintField field : pageBlueprint.getBlueprintFieldsFromPageBlueprint()) {
            fieldIds.add((Object)field.getId());
        }
        return fieldIds.join(", ");
    }

    public String fieldIds(SpaceBlueprint spaceBlueprint) {
        BrikitList fieldIds = new BrikitList();
        for (BlueprintField field : spaceBlueprint.getBlueprintFieldsFromSpaceBlueprint()) {
            fieldIds.add((Object)field.getId());
        }
        return fieldIds.join(", ");
    }

    public Map<String, Access> getAccesses() {
        return BlueprintDefinitions.getAccesses();
    }

    public List<String> getCreateSpaceGroups() {
        return BlueprintDefinitions.getCreateSpaceGroups();
    }

    public BrikitOrderedMap<String, PageBlueprint> getPageBlueprints() {
        return BlueprintDefinitions.getPageBlueprints();
    }

    public List<String> getPageMetadata() {
        return BlueprintDefinitions.getPageMetadata();
    }

    public List<String> getSpaceMetadata() {
        return BlueprintDefinitions.getSpaceMetadata();
    }

    public BrikitOrderedMap<String, SpaceBlueprint> getSpaceBlueprints() {
        return BlueprintDefinitions.getSpaceBlueprints();
    }

    public BrikitOrderedMap<String, BlueprintField> getBlueprintFields() {
        return BlueprintDefinitions.getBlueprintFields();
    }

    public boolean hasBlueprintDefinitions() {
        return !this.getSpaceBlueprints().isEmpty() || !this.getPageBlueprints().isEmpty() || !this.getBlueprintFields().isEmpty() || !this.getAccesses().isEmpty() || !this.getPageMetadata().isEmpty() || !this.getSpaceMetadata().isEmpty() || !this.getCreateSpaceGroups().isEmpty();
    }

    public String sortedAccessNames(SpaceBlueprint spaceBlueprint) {
        ArrayList<String> accessNames = new ArrayList<String>();
        for (Access access : spaceBlueprint.getAccesses()) {
            accessNames.add(access.getName());
        }
        Collections.sort(accessNames);
        return new BrikitList(accessNames).join(", ");
    }

    public String sortedCategoryNames(SpaceBlueprint spaceBlueprint) {
        ArrayList<String> categoryNames = new ArrayList<String>(spaceBlueprint.getSpaceCategories());
        Collections.sort(categoryNames);
        return new BrikitList(categoryNames).join(", ");
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("com.brikit.blueprintmaker.insufficient.permissions"));
        }
    }
}

