(function ($) {
	BlueprintMaker.extend({
		
		currentPanel: false,
		
		blueprintPanelChanged: function ($new) {
			var dialog = this;
			Confluence.Binder.autocompleteUserOrGroup($new);
			Confluence.Binder.autocompletePage($new);
			if ($new.hasClass("blueprint-details-panel")) {
				BlueprintMaker.initializeBlueprintDetails(dialog, $new);
			}
			else if ($new.hasClass("blueprint-values-panel")) {
				BlueprintMaker.initializeBlueprintValues(dialog, $new);
			}
			else if ($new.hasClass("blueprint-definitions-panel")) {
				var $selected = BlueprintMaker.selectedBlueprint(dialog);
				$selected.scrollToBeVisible($selected.closest(".aui-dialog2-content"), {speed: 0});
			}

			var forward = $(BlueprintMaker.currentPanel).hasClass("blueprint-definitions-panel");
			BlueprintMaker.currentPanel = $new;
			if ($("#no-blueprint-fields-required-message", $new).length) {
				if (forward) dialog.nextButton().click();
				else dialog.previousButton().click();
			}
		},
		
		changePageDestination: function (event) {
			var isNew = $(this).val() == "create";
			$(".create-page-extras").showIf(isNew);
			$(".update-page-extras").hideIf(isNew);
		},
		
		chooseTemplate: function (event) {
			event.preventDefault();
			
			$.get(BlueprintMaker.contextPath + "/plugins/brikit/blueprints/chooseblueprint.action", 
				{ spaceKey: BlueprintMaker.spaceKey, pageId: BlueprintMaker.pageId },
				BlueprintMaker.showBlueprintChoices);
			
			return false;
		},
		
		createPageFromBlueprintButtonPressed: function (event) {
			event.preventDefault();
			
			if ($(this).data("missing-view-permissions")) {
				BlueprintMaker.Dialog2.alert(BlueprintMaker.getText("com.brikit.blueprintmaker.missing.blueprint.page.view.permission"), { title: BlueprintMaker.getText("com.brikit.blueprintmaker.no.permission") });
				return false;
			}
			
			BlueprintMaker.createPageFromBlueprint = true;
			BlueprintMaker.liveBlueprint = false;
			BlueprintMaker.blueprintProperties = false;
			BlueprintMaker.startBlueprint = $(this).data("blueprint");
			BlueprintMaker.pageTitleForBlueprint = $(this).data("page-title");
			BlueprintMaker.pageLabelsForBlueprint = $(this).data("page-labels");
			BlueprintMaker.chooseTemplate(event);
		},

		editLiveBlueprint: function (event) {
			event.preventDefault();
			
			BlueprintMaker.liveBlueprint = true;
			BlueprintMaker.startBlueprint = $(this).data("blueprint-name");
			BlueprintMaker.blueprintProperties = $(this).data("blueprint-properties");

			$.get(BlueprintMaker.contextPath + "/plugins/brikit/blueprints/chooseblueprint.action", 
				{ spaceKey: BlueprintMaker.spaceKey, pageId: BlueprintMaker.pageId, liveBlueprint: true, macroId: $(this).data("macro-id") },
				BlueprintMaker.showBlueprintChoices);
		},

        fields: function () {
            return BlueprintMaker.form(".blueprint-maker-form-field");
        },
        
        form: function (selector) {
			var $form = $("#blueprint-maker-create-from-blueprint-form");
            return selector ? $(selector, $form): $form;
        },
        
        formValues: function () {
			var $fields = BlueprintMaker.fields();
			
			var values = [];
            var addValue = function (name, type, value) {
				var value =  {
					"name" : name,
					"type" : type,
					"value" : value
				}
				values.push(value);
            }
            
			$fields.each(function () {
				addValue($(this).attr("name"), $(this).data("type"), $(this).val());
			});
            
            // Add extra fields with formatted human-readable labels for filter groups
            $fields.each(function () {
                var $field = $(this);
                if (!$field.hasClass("filter-group-list")) return;
                
                var selected = [];
                $field.find("option:selected").each(function () {
                    selected.push($(this).text());
                });

                addValue($field.attr("name") + "-human-readable-filters", "medium", selected.join(" "));
                addValue($field.attr("name") + "-human-readable-filters-comma-separated", "medium", selected.join(", "));
                addValue($field.attr("name") + "-human-readable-filters-dash-separated", "medium", selected.join(" - "));
            });
            
            return values;
        },
		
		initialize: function () {
			$("#header").on("click", "#blueprint-maker-create-link", BlueprintMaker.chooseTemplate);
		},
		
		initializeBlueprintDetailField: function (dialog, $blueprintDetailsPanel, fieldSelector, templateFieldSelector) {
			var nameField = $(fieldSelector, $blueprintDetailsPanel);
			if (!nameField.length) return;
			
			var nameTemplate = nameField.val() || dialog.find(templateFieldSelector).val();
			nameField.val(BlueprintMaker.substituteValues(dialog, nameTemplate));
		},
		
		initializeBlueprintDetails: function (dialog, $blueprintDetailsPanel) {
			BlueprintMaker.initializeBlueprintDetailField(dialog, $blueprintDetailsPanel, "#space-name-field",        "#space-name-template");
			BlueprintMaker.initializeBlueprintDetailField(dialog, $blueprintDetailsPanel, "#space-key-field",         "#space-key-template");
			BlueprintMaker.initializeBlueprintDetailField(dialog, $blueprintDetailsPanel, "#space-description-field", "#space-description-template");

			var $pageTitleField = dialog.find("#page-title-field");
			var presetTitle = $("#preset-page-title-field").val();
			if (presetTitle && !$pageTitleField.val()) $pageTitleField.val(presetTitle);
			BlueprintMaker.initializeBlueprintDetailField(dialog, $blueprintDetailsPanel, "#page-title-field", 		  "#page-title-template");
			
			var presetLabels = $("#preset-page-labels-field").val();
			if (presetLabels) dialog.find("#page-labels-field").val(presetLabels);
						
			$("#create-new-page, #regenerate-this-page", $blueprintDetailsPanel).click(BlueprintMaker.changePageDestination);

			if (dialog.find("#original-page-template-field").val()) {
				$("#regenerate-this-page", $blueprintDetailsPanel).click();
				$("#create-new-page", $blueprintDetailsPanel).attr("disabled", "disabled");
				if (!$pageTitleField.val()) $pageTitleField.val(BlueprintMaker.pageTitle);
			}
			else {
				$("#create-new-page", $blueprintDetailsPanel).removeAttr("disabled");
			}
			
			BlueprintMaker.initializeBlueprintDetailField(dialog, $blueprintDetailsPanel, "#destination-page-field",  "#destination-page-template");
		},
		
		initializeBlueprintValues: function (dialog, $blueprintValuesPanel) {
			$.each(BlueprintMaker.blueprintProperties, function (name, value) {
				$blueprintValuesPanel.find("[name='" + name + "']").val(value);
			});
		},
		
		initializeCreateBlueprint: function () {
			var dialog = this;
			
			BlueprintMaker.initializeTemplates(dialog);
			BlueprintMaker.initializeSubmitForm(dialog);
						
			if (BlueprintMaker.liveBlueprint) {
				dialog.find("#space-blueprint-picker, .blueprint-section-title, .template:not(.LIVE)").hide();
			}
			else {
				dialog.find(".template.LIVE").hide();
			}
			
			if (BlueprintMaker.startBlueprint) {
				var $blueprintFound = $("li.template[data-page-blueprint='" + BlueprintMaker.startBlueprint + "']").click();
				if (BlueprintMaker.pageTitleForBlueprint) dialog.find("#preset-page-title-field").val(BlueprintMaker.pageTitleForBlueprint);
                if (BlueprintMaker.pageLabelsForBlueprint) dialog.find("#preset-page-labels-field").val(BlueprintMaker.pageLabelsForBlueprint);
				BlueprintMaker.liveBlueprint = false;
				BlueprintMaker.startBlueprint = false;
				BlueprintMaker.pageTitleForBlueprint = false;
				BlueprintMaker.pageLabelsForBlueprint = false;
				if ($blueprintFound.length) $("#dialog-next-button").click();
			}
			else {
				// Set to match the initial selection
				BlueprintMaker.selectedBlueprint(dialog).click();
			}
			
		},
		
		initializeSubmitForm: function (dialog) {
			// Wire up the form to submit using the jquery.form plugin, so that attachments get sent properly
			var submitFunction = function (response, textStatus, jqXHR) {
				dialog.showBusy(false);
				if (response.indexOf("errorMessage") != -1) {
					BlueprintMaker.Dialog2.alert(response, {title: BlueprintMaker.getText("com.brikit.blueprintmaker.error")});
				}
				else {
					dialog.hide();
					location.href = response;
				}
			};
			dialog.find("#blueprint-maker-create-from-blueprint-form").ajaxForm(submitFunction);
		},
		
		initializeTemplates: function (dialog) {
			if (BlueprintMaker.createPageFromBlueprint) {
				dialog.find("#space-blueprint-picker").hide();
				dialog.find(".template.copy-page").hide();
				BlueprintMaker.createPageFromBlueprint = false;
			}

			var $templates = dialog.find("ol.templates");

			$templates.on("click", "li", function (event) { 
				event.preventDefault();
				
				// Visually select the space template
				$templates.find("li").removeClass("selected");
				$(this).addClass("selected");
				
				// Get the selected template's name
				BlueprintMaker.setSelectedBlueprint(dialog, this);
			});
		},
		
		selectedBlueprint: function (dialog) {
			return dialog.find("ol.templates li.selected");
		},
		
		setSelectedBlueprint: function (dialog, blueprint) {
			// Set the dialog's context to the type and template name
			var templateName = $(blueprint).data("space-blueprint") ? "space:" + $(blueprint).data("space-blueprint") : "page:" + $(blueprint).data("page-blueprint");
			dialog.loadContext(templateName);

			// Write the template name to the hidden field so it gets submitted with the rest of the form data
			dialog.find("#template-name-field").val(templateName);
			dialog.find("#original-page-template-field").val($(blueprint).data("original-page-template"));
		},
		
		showBlueprintChoices: function (responseText, textStatus, XMLHttpRequest) {
			var dialog = new BlueprintMaker.MultiPanelDialog(
				"#create-dialog", 
				responseText, 
				{
					okButton: BlueprintMaker.getText(BlueprintMaker.liveBlueprint ? "com.brikit.blueprintmaker.save" : "com.brikit.blueprintmaker.create"),
					initialize: BlueprintMaker.initializeCreateBlueprint,
					submit: BlueprintMaker.submitCreateFromBlueprint,
					panelChange: BlueprintMaker.blueprintPanelChanged
				}
			);
			
		},
        
		submitCreateFromBlueprint: function (result) {
            var dialog = this;

			if (!BlueprintMaker.validateFields(BlueprintMaker.fields())) return dialog.showBusy(false);
			
			
			BlueprintMaker.form("#dynamic-values-field").val(JSON.stringify(BlueprintMaker.formValues()));
			BlueprintMaker.form("#current-space-key-field").val(BlueprintMaker.spaceKey);
			BlueprintMaker.form("#current-page-id-field").val(BlueprintMaker.pageId);
			
			BlueprintMaker.form().submit();
		},
		
		substituteValues: function (dialog, string) {
            $.each(BlueprintMaker.formValues(), function (index, kv) {
				if (kv.value) string = string.replace("[[" + kv.name + "]]", kv.value);
            });
			return string;
		},
		
		validateFields: function ($fields) {
			var missing = [];
			$fields.each(function () {
				var $fieldGroup = $(this).closest(".field-group");
				if ($fieldGroup.find(".icon-required").length && !$(this).val()) {
					// Nutty clone sequence is to avoid getting text from sub-elements, such as the span
					missing.push(" " + $.trim($("label", $fieldGroup).clone().children().remove().end().text())); 
				};
			});
			if (missing.length) {
				BlueprintMaker.Dialog2.alert(BlueprintMaker.getText("com.brikit.blueprintmaker.required.fields", [missing]), 
					{title: BlueprintMaker.getText("com.brikit.blueprintmaker.field.input.error.title")});
				return false;
			}
			
			var failed = [];
			$fields.each(function () {
				var validation = $(this).data("validation");
				if (validation && !(new RegExp(validation).test($(this).val()))) {
					var $fieldGroup = $(this).closest(".field-group");
					// Nutty clone sequence is to avoid getting text from sub-elements, such as the span
					failed.push(" " + $.trim($("label", $fieldGroup).clone().children().remove().end().text())); 
				}
			});
			if (failed.length) {
				BlueprintMaker.Dialog2.alert(BlueprintMaker.getText("com.brikit.blueprintmaker.validation.failed", [failed]), 
					{title: BlueprintMaker.getText("com.brikit.blueprintmaker.field.input.error.title")});
				return false;
			}
			
			return true;
		}
	});

})(jQuery);

BlueprintMaker.toFinalize(function ($) {
	BlueprintMaker.initialize();
});
