(function ($) { 

	ThemePress.Flex = {

		stop: false,
	
		// Adjust the minimum height of the canvas to ensure the footer never floats up from the bottom edge of the window
		ensureFooterAtBottom: function () {
			var $lastLayerAboveFooter = $("#content .brikit-container-content, #brikit-non-page-content").last();
			var $shim = $("#brikit-footer-shim");
			if ($lastLayerAboveFooter.length) {
				if ($lastLayerAboveFooter.closest(".brikit-content-column").length) $lastLayerAboveFooter.after($shim);
				else $lastLayerAboveFooter.append($shim);
			}
			// The extra pixel allows for an extra bit at the bottom
			var $whatToMeasure = ThemePress.Structure.contentStack().length ? ThemePress.Structure.contentStack() : ThemePress.Structure.brikitNonPageContent();
			var shortage = $(window).height() -
							(ThemePress.Structure.isHeaderShowing() ? ThemePress.Structure.confluenceHeader().outerHeight(true) : 0) -
							(ThemePress.Structure.isHeaderShowing() ? ThemePress.Structure.toolbar().outerHeight(true) : 0) -
							ThemePress.Structure.banner().outerHeight(true) -
							(ThemePress.Browser.mobile ? 0 : $(".brikit-header-backdrop").outerHeight(true)) -
							$whatToMeasure.outerHeight(true) + $shim.height() + 1 -
                            $(".brikit-footer-backdrop").outerHeight(true);
			$shim.height(Math.max(0, shortage));
		},

		windowResized: function () {
			ThemePress.Flex.ensureFooterAtBottom();
			if (ThemePress.Designer && ThemePress.Designer.designer().length) {
				ThemePress.Focus.updateFocusBlanket();
				ThemePress.Designer.resizeDesigner();
			}
			ThemePress.Menu.positionMenuPanels();
			ThemePress.Structure.adjustHybridPageHeaders();
			var bannerOffset = $(".brikit-banner-content").outerHeight(true);
			$("#header-fake-stripe").width($("#main").outerWidth(true)).css("top", bannerOffset);

			var $toggle = ThemePress.SimpleMenu.simpleMenuToggleButton();

			// If the simple toolbar toggle (hamburger menu) is in the standard location, adjust the header to ensure
			// the hamburger doesn't overlap with menus and other header content
			if (!ThemePress.Browser.mobile && !$("#move-simple-toolbar").length && $toggle.length) {
				var $header = ThemePress.Structure.header();
				
				// Reset to the original right margin
				if (!$header.attr("data-original-right-margin")) $header.attr("data-original-right-margin", $header.css("margin-right"));
				$header.css("margin-right", $header.data("original-right-margin"));
				
				// Adjust if an overlap is detected
				var toggleLeft = $toggle.offset().left;
				var headerRight = $header.offset().left + $header.outerWidth();
				if (headerRight > toggleLeft) $header.css("margin-right", headerRight - toggleLeft + 20);
			}
			
		}
	};

	ThemePress.toInit( function ($) {

		$(window).resize(ThemePress.Flex.windowResized);
		$(document).ajaxComplete(ThemePress.Flex.windowResized); // Needed for Team Calendars initial page load
		ThemePress.Flex.windowResized();
	});

})(jQuery);
