/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.util.SpaceComparator;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitLabel;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitOrderedMap;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ListSpacesMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/list-spaces.vm";
    public static final String FILTER_PARAM = "filter";
    public static final String CATEGORIES_PARAM = "categories";
    public static final String EXCLUDE_CATEGORIES_PARAM = "exclude-categories";
    public static final String SHOW_CATEGORIES_PARAM = "show-categories";
    public static final String CATEGORY_NAMES_PARAM = "category-names";
    public static final String SHOW_ARCHIVED_PARAM = "show-archived";
    public static final String SHOW_CATEGORIES_ONLY_PARAM = "show-categories-only";
    public static final String ALL_CATEGORIES_WILDCARD = "@all";
    public static final String FILTER_ALL = "all";
    public static final String FILTER_CATEGORY = "category";
    public static final String FILTER_FAVORITE = "favorites";
    public static final String FILTER_NEW = "new";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.booleanValue("no-bullets")) {
            macroContext.velocityContextAdd((Object)"noBullets", (Object)"true");
        }
        boolean showArchived = macroContext.booleanValue(SHOW_ARCHIVED_PARAM);
        boolean showCategoriesOnly = macroContext.booleanValue(SHOW_CATEGORIES_ONLY_PARAM);
        String filter = macroContext.stringValue(FILTER_PARAM, FILTER_ALL);
        List spaces = new ArrayList();
        if (!showCategoriesOnly) {
            if (FILTER_ALL.equalsIgnoreCase(filter)) {
                spaces = new ArrayList(Confluence.permittedSpaces());
            } else if (FILTER_CATEGORY.equalsIgnoreCase(filter)) {
                String categoriesString = BrikitString.decodeSpecialCharacters((String)macroContext.stringValue(CATEGORIES_PARAM));
                String excludeCategoriesString = BrikitString.decodeSpecialCharacters((String)macroContext.stringValue(EXCLUDE_CATEGORIES_PARAM));
                spaces = Confluence.spacesWithCategories((List)BrikitString.splitCommaSeparated((String)categoriesString), (List)BrikitString.splitCommaSeparated((String)excludeCategoriesString));
            } else if (FILTER_FAVORITE.equalsIgnoreCase(filter)) {
                spaces = Confluence.favoriteSpaces();
            } else if (FILTER_NEW.equalsIgnoreCase(filter)) {
                spaces = Confluence.newSpaces();
            }
        }
        if (!showArchived) {
            ListIterator spacesIterator = spaces.listIterator();
            while (spacesIterator.hasNext()) {
                Space space = (Space)spacesIterator.next();
                if (space.getSpaceStatus() != SpaceStatus.ARCHIVED) continue;
                spacesIterator.remove();
            }
        }
        HashMap<String, String> mappedNames = new HashMap<String, String>();
        for (String labelPair : macroContext.commaSeparatedListValue(CATEGORY_NAMES_PARAM)) {
            BrikitList pair = new BrikitList((List)BrikitString.split((String)labelPair, (String)"="));
            if (pair.size() != 2) continue;
            mappedNames.put((String)pair.first(), (String)pair.last());
        }
        Collections.sort(spaces, new SpaceComparator());
        if (!macroContext.hasStringValue(SHOW_CATEGORIES_PARAM)) {
            macroContext.velocityContextAdd((Object)"spaces", spaces);
        } else {
            BrikitOrderedMap categoryEntries = new BrikitOrderedMap();
            List showCategories = ALL_CATEGORIES_WILDCARD.equalsIgnoreCase(macroContext.stringValue(SHOW_CATEGORIES_PARAM)) ? Confluence.getSpaceCategoriesAsStrings() : macroContext.commaSeparatedListValue(SHOW_CATEGORIES_PARAM);
            HashMap spacesByCategory = new HashMap(showCategories.size());
            Iterator iterator = showCategories.iterator();
            while (iterator.hasNext()) {
                String category;
                categoryEntries.put((Object)category, (Object)(mappedNames.containsKey(category = (String)iterator.next()) ? (String)mappedNames.get(category) : BrikitLabel.humanize((String)category)));
                ArrayList<Space> categorySpaces = new ArrayList<Space>();
                for (Space space : spaces) {
                    if (!Confluence.spaceHasCategory((String)space.getKey(), (String)category)) continue;
                    categorySpaces.add(space);
                }
                spacesByCategory.put(category, categorySpaces);
            }
            macroContext.velocityContextAdd((Object)CATEGORIES_PARAM, (Object)categoryEntries);
            macroContext.velocityContextAdd((Object)"spacesByCategory", spacesByCategory);
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

