/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocal;
import com.atlassian.confluence.util.i18n.Message;
import com.brikit.core.confluence.Confluence;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BrikitDate {
    public static final String DATE_ONLY_FORMAT = "yyyy/MM/dd";
    public static final String MONTH_ONLY_FORMAT = "yyyy/MM";
    public static final String DEFAULT_DATE_TIME_FORMAT = "MM/dd/yyyy h:mm a";
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";
    public static final String DEFAULT_TIME_FORMAT = "h:mm a";
    public static final String DATE_TIME_TIMEZONE_FORMAT = "MM/dd/yyyy h:mm a z";
    public static final String TIME_TIMEZONE_FORMAT = "h:mm a z";
    public static final String ICS_DATE_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String ISO_DATE_FORMAT = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'";
    public static final String FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final double MILLISECONDS_PER_DAY = 8.64E7;
    public static final long ONE_YEAR_IN_MILLISECONDS = 1471228928L;

    public static Calendar addDays(Calendar aDate, int number) {
        return BrikitDate.addUnits(aDate, 5, number);
    }

    public static Date addDays(Date aDate, int number) {
        return BrikitDate.addUnits(aDate, 5, number);
    }

    public static Calendar addMilliseconds(Calendar aDate, int number) {
        return BrikitDate.addUnits(aDate, 14, number);
    }

    public static Date addMilliseconds(Date aDate, int number) {
        return BrikitDate.addUnits(aDate, 14, number);
    }

    public static Calendar addMonths(Calendar aDate, int number) {
        return BrikitDate.addUnits(aDate, 2, number);
    }

    public static Date addMonths(Date aDate, int number) {
        return BrikitDate.addUnits(aDate, 2, number);
    }

    public static Calendar addUnits(Calendar aDate, int dateField, int number) {
        Calendar adjustedDate = (Calendar)aDate.clone();
        adjustedDate.add(dateField, number);
        return adjustedDate;
    }

    public static Date addUnits(Date aDate, int dateField, int number) {
        return BrikitDate.toDate(BrikitDate.addUnits(BrikitDate.toCalendar(aDate), dateField, number));
    }

    public static Calendar convert(Calendar aCalendar, com.atlassian.confluence.core.TimeZone timeZone) {
        Calendar calendar = (Calendar)aCalendar.clone();
        calendar.setTimeZone(timeZone.getWrappedTimeZone());
        return calendar;
    }

    public static Calendar convert(Date aDate, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.convert(BrikitDate.toCalendar(aDate), timeZone);
    }

    public static Date convertDate(Date aDate, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.toDate(BrikitDate.convert(BrikitDate.toCalendar(aDate), timeZone));
    }

    public static Calendar convertToSystemTimezone(Calendar aCalendar) {
        return BrikitDate.convert(aCalendar, Confluence.getSystemTimeZone());
    }

    public static Calendar convertToUserTimezone(Calendar aCalendar) {
        return BrikitDate.convert(aCalendar, Confluence.getUserTimeZone());
    }

    public static Calendar dateOnly(Calendar aDate) {
        Calendar dateOnly = (Calendar)aDate.clone();
        dateOnly.clear();
        dateOnly.setTimeZone(aDate.getTimeZone());
        dateOnly.set(aDate.get(1), aDate.get(2), aDate.get(5));
        return dateOnly;
    }

    public static Date dateOnly(Date aDate) {
        return BrikitDate.dateOnly(BrikitDate.toCalendar(aDate)).getTime();
    }

    public static int daysBetween(Calendar day1, Calendar day2) {
        return (int)Math.round((double)(BrikitDate.dateOnly(day2).getTimeInMillis() - BrikitDate.dateOnly(day1).getTimeInMillis()) / 8.64E7);
    }

    public static int daysBetween(Date day1, Date day2) {
        return BrikitDate.daysBetween(BrikitDate.toCalendar(day1), BrikitDate.toCalendar(day2));
    }

    public static String formatDateOnly(Date aDate, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.formatDateTime(aDate, timeZone, DEFAULT_DATE_FORMAT, true);
    }

    public static String formatDateTime(Calendar aCalendar, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.formatDateTime(aCalendar.getTime(), timeZone, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String formatDateTime(Date aDate, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.formatDateTime(aDate, timeZone, DEFAULT_DATE_TIME_FORMAT);
    }

    public static String formatDateTime(Calendar aCalendar, com.atlassian.confluence.core.TimeZone timeZone, boolean omitTimeZone) {
        return BrikitDate.formatDateTime(aCalendar.getTime(), timeZone, DEFAULT_DATE_TIME_FORMAT, omitTimeZone);
    }

    public static String formatDateTime(Date aDate, com.atlassian.confluence.core.TimeZone timeZone, boolean omitTimeZone) {
        return BrikitDate.formatDateTime(aDate, timeZone, DEFAULT_DATE_TIME_FORMAT, omitTimeZone);
    }

    public static String formatDateTime(Calendar aCalendar, com.atlassian.confluence.core.TimeZone timeZone, String dateFormat) {
        return BrikitDate.formatDateTime(aCalendar.getTime(), timeZone, dateFormat);
    }

    public static String formatDateTime(Date aDate, com.atlassian.confluence.core.TimeZone timeZone, String dateFormat) {
        return BrikitDate.formatDateTime(aDate, timeZone, dateFormat, false);
    }

    public static String formatDateTime(Calendar aCalendar, com.atlassian.confluence.core.TimeZone timeZone, String dateFormat, boolean omitTimeZone) {
        return BrikitDate.formatDateTime(aCalendar.getTime(), timeZone, dateFormat, omitTimeZone);
    }

    public static String formatDateTime(Date aDate, com.atlassian.confluence.core.TimeZone timeZone, String dateFormat, boolean omitTimeZone) {
        if (aDate == null) {
            return "";
        }
        return Confluence.getDateFormatter(timeZone).formatGivenString(dateFormat, aDate) + (omitTimeZone ? "" : " " + BrikitDate.formatShortTimeZone(timeZone));
    }

    public static String formatFriendlyDate(Calendar calendar) {
        return BrikitDate.formatFriendlyDate(BrikitDate.toDate(calendar));
    }

    public static String formatFriendlyDate(Date date) {
        FriendlyDateFormatter friendlyDateFormatter = new FriendlyDateFormatter(RequestTimeThreadLocal.getTimeOrNow(), Confluence.getUserDateFormatter());
        Message message = friendlyDateFormatter.getFormatMessage(date);
        return Confluence.getText(message.getKey(), message.getArguments());
    }

    public static String formatFriendlyDate(Timestamp timestamp) {
        return BrikitDate.formatFriendlyDate(new Date(timestamp.getTime()));
    }

    public static String formatISODateTime() {
        return BrikitDate.formatISODateTime(new Date());
    }

    public static String formatISODateTime(Date aDate) {
        return Confluence.getUTCDateFormatter().formatGivenString(ISO_DATE_FORMAT, aDate);
    }

    public static String formatIcsDateTime() {
        return BrikitDate.formatIcsDateTime(new Date());
    }

    public static String formatIcsDateTime(Date aDate) {
        return Confluence.getUTCDateFormatter().formatGivenString(ICS_DATE_FORMAT, aDate);
    }

    public static String formatLongMonthYear(Calendar aCalendar) {
        return Confluence.getUserDateFormatter().formatGivenString("MMMM yyyy", aCalendar.getTime());
    }

    public static String formatShortTimeZone(com.atlassian.confluence.core.TimeZone timeZone) {
        return timeZone.getWrappedTimeZone().getDisplayName(false, 0);
    }

    public static String formatShortYearMonth(Calendar aCalendar) {
        return Confluence.getUserDateFormatter().formatGivenString(MONTH_ONLY_FORMAT, aCalendar.getTime());
    }

    public static String formatSimpleDate(Calendar aCalendar) {
        return aCalendar == null ? "" : BrikitDate.formatSimpleDate(aCalendar.getTime());
    }

    public static String formatSimpleDate(Date aDate) {
        return aDate == null ? "" : Confluence.getUserDateFormatter().formatGivenString(FORMAT_YYYY_MM_DD, aDate);
    }

    public static String formatSystemDateTime(Date aDate) {
        return BrikitDate.formatDateTime(aDate, Confluence.getSystemTimeZone(), DEFAULT_DATE_TIME_FORMAT);
    }

    public static String formatTime(Calendar aCalendar, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.formatDateTime(aCalendar, timeZone, false);
    }

    public static String formatTime(Calendar aCalendar, com.atlassian.confluence.core.TimeZone timeZone, boolean omitTimeZone) {
        return BrikitDate.formatDateTime(aCalendar, timeZone, DEFAULT_TIME_FORMAT, omitTimeZone);
    }

    public static String formatTime(Date aDate, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.formatDateTime(aDate, timeZone, false);
    }

    public static String formatTime(Date aDate, com.atlassian.confluence.core.TimeZone timeZone, boolean omitTimeZone) {
        return BrikitDate.formatDateTime(aDate, timeZone, DEFAULT_TIME_FORMAT, omitTimeZone);
    }

    public static Calendar getCalendar(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(year, month - 1, Math.max(1, day));
        return calendar;
    }

    public static DateFormat getDateOnlyFormat() {
        return new SimpleDateFormat(DATE_ONLY_FORMAT);
    }

    public static Calendar getEndOfDay(Calendar aCalendar) {
        Calendar date = BrikitDate.dateOnly(aCalendar);
        date.add(5, 1);
        date.add(14, -1);
        return date;
    }

    public static Calendar getEndOfDay() {
        return BrikitDate.getEndOfDay(Confluence.getUserTimeZone());
    }

    public static Calendar getEndOfDay(com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.getEndOfDay(BrikitDate.getToday(timeZone));
    }

    public static Calendar getFirstDayOfMonth(Calendar aCalendar) {
        Calendar date = BrikitDate.dateOnly((Calendar)aCalendar.clone());
        date.set(5, 1);
        return date;
    }

    public static Calendar getFirstDayOfMonth(int year, int month) {
        Calendar date = BrikitDate.getFirstDayOfThisMonth();
        date.set(1, year);
        date.set(2, month);
        return date;
    }

    public static Calendar getFirstDayOfMonthAfter(Calendar aCalendar) {
        Calendar date = BrikitDate.getFirstDayOfMonth(aCalendar);
        date.add(2, 1);
        return date;
    }

    public static Calendar getFirstDayOfNextMonth() {
        return BrikitDate.getFirstDayOfNextMonth(Confluence.getUserTimeZone());
    }

    public static Calendar getFirstDayOfNextMonth(com.atlassian.confluence.core.TimeZone timeZone) {
        Calendar date = BrikitDate.getFirstDayOfThisMonth(timeZone);
        date = BrikitDate.getLastDayOfMonth(date);
        date.add(5, 1);
        return date;
    }

    public static Calendar getFirstDayOfThisMonth() {
        return BrikitDate.getFirstDayOfThisMonth(Confluence.getUserTimeZone());
    }

    public static Calendar getFirstDayOfThisMonth(com.atlassian.confluence.core.TimeZone timeZone) {
        Calendar date = BrikitDate.getToday(timeZone);
        date.set(5, 1);
        return date;
    }

    public static Calendar getFirstDayOfThisWeek() {
        return BrikitDate.getFirstDayOfThisWeek(Confluence.getUserTimeZone());
    }

    public static Calendar getFirstDayOfThisWeek(com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.getFirstDayOfWeek(BrikitDate.getToday(timeZone));
    }

    public static Calendar getFirstDayOfWeek(Calendar aCalendar) {
        Calendar date = BrikitDate.dateOnly((Calendar)aCalendar.clone());
        date.add(5, -1 * (date.get(7) - 1));
        return date;
    }

    public static Calendar getLastDayOfMonth(Calendar aCalendar) {
        Calendar date = BrikitDate.getFirstDayOfMonth(aCalendar);
        date.add(2, 1);
        date.add(5, -1);
        return date;
    }

    public static Calendar getLastDayOfMonth(int year, int month) {
        return BrikitDate.getLastDayOfMonth(BrikitDate.getFirstDayOfMonth(year, month));
    }

    public static Calendar getLastDayOfLastMonth() {
        return BrikitDate.getLastDayOfLastMonth(Confluence.getUserTimeZone());
    }

    public static Calendar getLastDayOfLastMonth(com.atlassian.confluence.core.TimeZone timeZone) {
        Calendar date = BrikitDate.getFirstDayOfThisMonth(timeZone);
        date.add(5, -1);
        return date;
    }

    public static Calendar getLastDayOfNextMonth() {
        return BrikitDate.getLastDayOfNextMonth(Confluence.getUserTimeZone());
    }

    public static Calendar getLastDayOfNextMonth(com.atlassian.confluence.core.TimeZone timeZone) {
        Calendar date = BrikitDate.getFirstDayOfNextMonth(timeZone);
        return BrikitDate.getLastDayOfMonth(date);
    }

    public static Calendar getLastDayOfThisMonth() {
        return BrikitDate.getLastDayOfMonth(BrikitDate.getFirstDayOfThisMonth());
    }

    public static Calendar getLastDayOfThisWeek() {
        Calendar date = BrikitDate.getFirstDayOfThisWeek();
        date.add(5, 6);
        return date;
    }

    public static Calendar getLastDayOfWeek(Calendar aCalendar) {
        Calendar date = BrikitDate.getFirstDayOfWeek(aCalendar);
        date.add(5, 6);
        return date;
    }

    public static int getMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static DateFormat getMonthOnlyFormat() {
        return new SimpleDateFormat(MONTH_ONLY_FORMAT);
    }

    public static Calendar getPeriodEnd(int year, int month) {
        return BrikitDate.getPeriodEnd(year, month, 0);
    }

    public static Calendar getPeriodEnd(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day == 0 ? calendar.getActualMaximum(5) : day);
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, calendar.getActualMaximum(14));
        return calendar;
    }

    public static Calendar getToday() {
        return BrikitDate.getToday(Confluence.getUserTimeZone());
    }

    public static Calendar getTodayDateOnly() {
        return BrikitDate.dateOnly(BrikitDate.getToday());
    }

    public static Calendar getToday(com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.dateOnly(Confluence.getTimeNow(timeZone));
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static boolean isAfter(Calendar day1, Calendar day2) {
        return day1.getTimeInMillis() > day2.getTimeInMillis();
    }

    public static boolean isAfter(Date day1, Date day2) {
        return day1.getTime() > day2.getTime();
    }

    public static boolean isBefore(Calendar day1, Calendar day2) {
        return day1.getTimeInMillis() < day2.getTimeInMillis();
    }

    public static boolean isBefore(Date day1, Date day2) {
        return day1.getTime() < day2.getTime();
    }

    public static boolean isAfterToday(Calendar calendar) {
        return BrikitDate.isAfter(BrikitDate.dateOnly(calendar), BrikitDate.getTodayDateOnly());
    }

    public static boolean isAfterToday(Date date) {
        return BrikitDate.isAfterToday(BrikitDate.toCalendar(date));
    }

    public static boolean isBeforeToday(Calendar calendar) {
        return BrikitDate.isBefore(BrikitDate.dateOnly(calendar), BrikitDate.getTodayDateOnly());
    }

    public static boolean isBeforeToday(Date date) {
        return BrikitDate.isBeforeToday(BrikitDate.toCalendar(date));
    }

    public static boolean isToday(Calendar calendar) {
        return BrikitDate.getTodayDateOnly().equals(BrikitDate.dateOnly(BrikitDate.convertToUserTimezone(calendar)));
    }

    public static boolean isToday(Date date) {
        return BrikitDate.isToday(BrikitDate.toCalendar(date));
    }

    public static boolean isWeekend(Calendar calendar) {
        return BrikitDate.isWeekend(calendar.getTime());
    }

    public static boolean isWeekend(Calendar calendar, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.isWeekend(calendar.getTime(), timeZone);
    }

    public static boolean isWeekend(Date date) {
        return BrikitDate.isWeekend(date, Confluence.getUserTimeZone());
    }

    public static boolean isWeekend(Date date, com.atlassian.confluence.core.TimeZone timeZone) {
        DateTime joda = BrikitDate.joda(date, timeZone);
        return joda.getDayOfWeek() == 6 || joda.getDayOfWeek() == 7;
    }

    public static DateTime joda(Calendar calendar) {
        return BrikitDate.joda(calendar.getTime());
    }

    public static DateTime joda(Calendar calendar, com.atlassian.confluence.core.TimeZone timeZone) {
        return BrikitDate.joda(calendar.getTime(), timeZone);
    }

    public static DateTime joda(Date date) {
        return BrikitDate.joda(date, Confluence.getUserTimeZone());
    }

    public static DateTime joda(Date date, com.atlassian.confluence.core.TimeZone timeZone) {
        return new DateTime((Object)date, DateTimeZone.forTimeZone((TimeZone)timeZone.getWrappedTimeZone()));
    }

    public static Calendar parseCalendar(String dateString) throws ParseException {
        return BrikitDate.toCalendar(BrikitDate.parseDate(dateString));
    }

    public static Date parseDate(String dateString) throws ParseException {
        return BrikitDate.parseDate(dateString, Confluence.getTimeZone());
    }

    public static Date parseDate(String dateString, com.atlassian.confluence.core.TimeZone timeZone) throws ParseException {
        return BrikitDate.parseDate(FORMAT_YYYY_MM_DD, dateString, timeZone);
    }

    public static Date parseDate(String dateFormat, String dateString, com.atlassian.confluence.core.TimeZone timeZone) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, Confluence.getLocale());
        formatter.setLenient(false);
        if (timeZone != null) {
            formatter.setTimeZone(timeZone.getWrappedTimeZone());
        }
        return formatter.parse(dateString);
    }

    public static Date parseDateForSystemTimeZone(String dateFormat, String dateString) throws ParseException {
        return BrikitDate.parseDate(dateFormat, dateString, Confluence.getSystemTimeZone());
    }

    public static Date parseDateForUserTimeZone(String dateFormat, String dateString) throws ParseException {
        return BrikitDate.parseDate(dateFormat, dateString, Confluence.getTimeZone());
    }

    public static Calendar parseDateOnly(String dateOnly) throws ParseException {
        return BrikitDate.parseDateOnly(dateOnly, DATE_ONLY_FORMAT);
    }

    public static Calendar parseDateOnly(String dateOnly, String format) throws ParseException {
        Calendar date = BrikitDate.toCalendar(new SimpleDateFormat(format).parse(dateOnly));
        date = BrikitDate.dateOnly(date);
        return date;
    }

    public static Date parseICSDate(String dateString) throws ParseException {
        return BrikitDate.parseDate(ICS_DATE_FORMAT, dateString, Confluence.getUTCTimeZone());
    }

    public static Date parseISODate(String dateString) throws ParseException {
        return BrikitDate.parseDate(ISO_DATE_FORMAT, dateString, Confluence.getUTCTimeZone());
    }

    public static Calendar parseMonthOnly(String monthOnly) throws ParseException {
        Calendar date = BrikitDate.toCalendar(BrikitDate.getMonthOnlyFormat().parse(monthOnly));
        date = BrikitDate.dateOnly(date);
        date.set(5, 1);
        return date;
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date toDate(Calendar calendar) {
        return calendar == null ? null : new Date(calendar.getTimeInMillis());
    }

    public static java.sql.Date toSqlDate(Calendar calendar) {
        return calendar == null ? null : new java.sql.Date(calendar.getTimeInMillis());
    }

    public static String zeroPad(int anInt, int length) {
        int paddedNum = anInt + (int)Math.pow(10.0, length);
        String paddedString = Integer.toString(paddedNum);
        return paddedString.substring(1);
    }
}

