(function ($) { 
	// Alias to Brikit for backward-compatibility
	Brikit = ThemePress;
	
	ThemePress.extend({

		parentPageId: AJS.Meta.get("parent-page-id"),
		fullPageUrl: AJS.Meta.get("full-page-url"),
		pageUrl: AJS.Meta.get("page-url"),
		allowHeaderFor: AJS.Meta.get("allow-header"),
		showHeaderByDefault: AJS.Meta.get("show-header-by-default"),
		
		isDemoSpace: ThemePress.spaceKey == "themepressdemo",
		
	    colors:     	{},
	    reverseColors: 	{}

	});
	
	ThemePress.extend({
		
		architectPageName: function () {
			return ThemePress.meta("brikit-architect-page");
		},
        
        blockToggler: function (macroId) {
			return $(".block-toggle[data-macro-id='" + macroId + "']");
        },
		
		clickCanvas: function () {
			$(".brikit-canvas").click();
		},
        
        containingBlockMacroId: function (element) {
            return ThemePress.macroId($(element).closest(".brikit-content-block"));
        },
        
		// Return the currently displayed theme name
		currentTheme: function () {
			return ThemePress.meta("theme-press-theme-name");
		},

		isArchitectPage: function () {
			return ThemePress.meta("brikit-architect-page");
		},
        
		isDeveloperMode: function () {
			return ThemePress.meta("brikit-developer-mode") == "true";
		},
		
		isHistoricalVersion: function () {
			return ThemePress.meta("historical-version") == "true";
		},
		
		isUsingDefaultTheme: function () {
			return ThemePress.meta("using-default-theme") == "true";
		},
        
        macroId: function (macroElement) {
            return $(macroElement).data("macro-id");
        },
		
		namedColors: function () {
			return ["primaryColor", "secondaryColor", "tertiaryColor", "lightColor", "mediumColor", "darkColor", "lightGrayColor", "mediumGrayColor", "darkGrayColor", "whiteColor", "transparent"];
		},
		
		// Return the current space categories
		spaceCategories: function () {
			return ThemePress.meta("space-categories");
		},

		// Return the installed Theme Press product version
		themePressVersion: function () {
			return ThemePress.meta("theme-press-version");
		},
        
        toggleBlock: function (toggleSelector) {
            let $toggler = $(toggleSelector).first();
            
            // If (toggleSelector) is aiming for a block toggle, try using the macroId of the target block
            if ((toggleSelector).trim().endsWith(".block-toggle")) {
                const blockSelector = toggleSelector.substr(0, toggleSelector.indexOf(".block-toggle"));
                const macroId = ThemePress.macroId(blockSelector);
                const $specificToggler = macroId && ThemePress.blockToggler(macroId);
                if ($specificToggler) $toggler = $specificToggler;
            }
            
            if ($toggler.length) $toggler.click();
			else alert("Link target not found: " + toggleSelector);
        },

		// Easter egg to zap changes to the theme
		zapDemoThemeChanges: function () {
			$.post(ThemePress.contextPath + "/plugins/brikit/theme/copy.action", 
				{themeName: "template", newThemeName: "demo", force: true}, 
				function () { location.reload(true); }
			);
		}
		
	});

	ThemePress.toInit( function ($) {
		// Easter egg to reset the theme
		// AJS.whenIType("zzzz").execute(ThemePress.zapDemoThemeChanges);
	});


})(jQuery);
