/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.lesson.model;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitString;
import java.util.List;

public class LessonProperties {
    public static final String KEY_ROOT = "com.brikit.themepress.lesson.";
    public static final String SELECTOR_SUFFIX = ".selector";
    public static final String SELECTOR_NOT_FOUND_MESSAGE_SUFFIX = ".selector.not.found.message";
    public static final String TITLE_SUFFIX = ".title";
    public static final String BODY_SUFFIX = ".body";
    public static final String WIDTH_SUFFIX = ".width";
    public static final String OFFSET_X_SUFFIX = ".offsetX";
    public static final String OFFSET_Y_SUFFIX = ".offsetY";
    public static final String ARROW_OFFSET_X_SUFFIX = ".arrowOffsetX";
    public static final String ERROR_SUFFIX = ".error";
    public static final String WARNING_SUFFIX = ".warning";
    public static final String SUCCESS_SUFFIX = ".success";
    public static final String HINT_SUFFIX = ".hint";
    public static final String HEADER_SUFFIX = ".header";
    public static final String EDIT_BLOCKS_SUFFIX = ".edit.blocks";
    public static final String DESIGNER_MODE_SUFFIX = ".designer.mode";
    public static final String DESIGNER_ACCORDION_SUFFIX = ".designer.accordion";
    public static final String DESIGNER_FIELDSET_SUFFIX = ".designer.fieldset";
    public static final String CLICK_ELEMENT_SUFFIX = ".click";
    protected String lessonPlanName;

    public LessonProperties(String lessonPlanName) {
        this.setLessonPlanName(lessonPlanName);
    }

    public String getArrowOffsetX(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + ARROW_OFFSET_X_SUFFIX);
    }

    public String getBody(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + BODY_SUFFIX);
    }

    public boolean getBooleanValue(String key) {
        return BrikitBoolean.booleanValue((String)this.getValueIfSpecified(key));
    }

    public String getKeyAndStepWithRoot(String lessonName) {
        return this.getKeyWithRoot() + "." + lessonName;
    }

    public String getKeyWithRoot() {
        return KEY_ROOT + this.getLessonPlanName();
    }

    public String getKeyAndLessonPlanDataWithRoot(String lessonPlanData) {
        return this.getKeyWithRoot() + lessonPlanData;
    }

    public List<String> getLessonNames() {
        return BrikitString.splitCommaSeparated((String)this.getStepsListValue());
    }

    public String getLessonPlanName() {
        return this.lessonPlanName;
    }

    public String getLessonPlanTitle() {
        return this.getValueIfSpecified(this.getKeyAndLessonPlanDataWithRoot(TITLE_SUFFIX));
    }

    public String getOffsetX(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + OFFSET_X_SUFFIX);
    }

    public String getOffsetY(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + OFFSET_Y_SUFFIX);
    }

    public String getEditBlocks(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + EDIT_BLOCKS_SUFFIX);
    }

    public String getError(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + ERROR_SUFFIX);
    }

    public String getWarning(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + WARNING_SUFFIX);
    }

    public String getSuccess(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + SUCCESS_SUFFIX);
    }

    public String getClickElement(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + CLICK_ELEMENT_SUFFIX);
    }

    public String getDesignerMode(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + DESIGNER_MODE_SUFFIX);
    }

    public String getDesignerAccordion(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + DESIGNER_ACCORDION_SUFFIX);
    }

    public String getDesignerFieldset(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + DESIGNER_FIELDSET_SUFFIX);
    }

    public String getHeader(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + HEADER_SUFFIX);
    }

    public String getHint(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + HINT_SUFFIX);
    }

    public String getSelector(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + SELECTOR_SUFFIX);
    }

    public String getSelectorNotFoundMessage(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + SELECTOR_NOT_FOUND_MESSAGE_SUFFIX);
    }

    protected String getStepsListValue() {
        return this.getValueIfSpecified(this.getKeyWithRoot());
    }

    public String getTitle(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + TITLE_SUFFIX);
    }

    public String getValueIfSpecified(String key) {
        return this.getValueIfSpecified(key, null);
    }

    public String getValueIfSpecified(String key, List args) {
        if (!BrikitString.isSet((String)key)) {
            return null;
        }
        String value = Confluence.getText((String)key);
        return BrikitString.isSet((String)value) && !key.equals(value) ? Confluence.getText((String)key, (List)args) : null;
    }

    public String getWidth(String lessonName) {
        return this.getValueIfSpecified(this.getKeyAndStepWithRoot(lessonName) + WIDTH_SUFFIX);
    }

    protected void setLessonPlanName(String lessonPlanName) {
        this.lessonPlanName = lessonPlanName;
    }
}

