/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.macros;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.macros.AbstractFacetAwareMacro;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.PagingCQLSearcher;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentQueryMacro
extends AbstractFacetAwareMacro {
    public static final String TEMPLATE_NAME = "targeted-search/templates/content-query.vm";
    protected static final String CQL_PARAM = "cql";
    protected static final String EXPLICIT_CQL_PARAM = "explicitCql";
    protected static final String QUERY_AFTER_PAGE_LOAD_PARAM = "queryAfterPageLoad";
    protected static final String MAX_PARAM = "max";
    protected static final String SORT_PARAM = "sort";
    protected static final String REVERSE_PARAM = "reverse";
    protected static final String DISPLAY_PARAM = "display";
    protected static final String DISPLAY_RICH_LINK_PARAM = "displayRichLinks";
    protected static final String FILTER_GROUP_NAMES_PARAM = "filterGroupNames";
    protected static final String RESULTS_KEY = "results";
    protected static final String ORDER_BY_KEY = "orderBy";
    protected static final String QUERY_KEY = "query";
    protected static final String FILTER_GROUPS_KEY = "filterGroups";
    protected static final String FILTER_GROUP_CLASSES_KEY = "filterGroupClasses";
    protected static final String FILTERS_BY_FILTER_GROUP_NAME_KEY = "filtersByFilterGroupName";
    protected static final String DISPLAY_OPTION_LIST = "list";
    protected static final String DISPLAY_OPTION_RICH_LINKS = "rich links";
    protected static final String DISPLAY_OPTION_TABLE = "table";
    protected static final String DISPLAY_TABLE = "displayTable";
    protected static final String DESCENDING = " desc";
    protected static final String TITLE = " title";
    protected CQLSearchService searchService;

    @Inject
    public ContentQueryMacro(@ComponentImport CQLSearchService searchService) {
        this.searchService = searchService;
    }

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String cql = (String)parameters.get(CQL_PARAM);
        String explicitCql = (String)parameters.get(EXPLICIT_CQL_PARAM);
        this.validateQuery(cql, explicitCql);
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = this.initializeMacroContext(parameters, body, conversionContext);
        String query = BrikitString.isSet((String)explicitCql) ? explicitCql : cql;
        this.finishInitializing(macroContext, query);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    protected void finishInitializing(BrikitMacroContext macroContext, String query) throws MacroExecutionException {
        this.getPageBuilderService().assembler().resources().requireWebResource("confluence.macros.advanced:content-by-label-resources");
        if (macroContext.stringValue(DISPLAY_PARAM).equals(DISPLAY_OPTION_TABLE) && !macroContext.booleanValue(QUERY_AFTER_PAGE_LOAD_PARAM)) {
            throw new MacroExecutionException(Confluence.getText((String)"com.brikit.targetedsearch.content-query.table.display.requires.query.after.page.load"));
        }
        String display = macroContext.stringValue(DISPLAY_PARAM);
        if (BrikitString.isSet((String)display)) {
            macroContext.velocityContextAdd((Object)DISPLAY_RICH_LINK_PARAM, (Object)false);
        }
        if (!BrikitString.isSet((String)display) && macroContext.booleanValue(DISPLAY_RICH_LINK_PARAM)) {
            display = DISPLAY_OPTION_RICH_LINKS;
        }
        boolean tableDisplay = display.equals(DISPLAY_OPTION_TABLE);
        if (display.equals(DISPLAY_OPTION_RICH_LINKS)) {
            macroContext.velocityContextAdd((Object)DISPLAY_RICH_LINK_PARAM, (Object)true);
        } else if (tableDisplay) {
            macroContext.velocityContextAdd((Object)DISPLAY_TABLE, (Object)true);
        }
        int chunkSize = tableDisplay ? 25 : macroContext.integerValue(MAX_PARAM, 15);
        macroContext.velocityContextAdd((Object)MAX_PARAM, (Object)chunkSize);
        query = this.expandCategorySpacesExtensions((String)query);
        macroContext.velocityContextAdd((Object)QUERY_KEY, query);
        query = (String)query + this.getOrderBy(macroContext);
        if (!macroContext.booleanValue(QUERY_AFTER_PAGE_LOAD_PARAM) || macroContext.isPreviewContext()) {
            this.fireSearch(macroContext, (String)query, chunkSize);
        }
    }

    protected String expandCategorySpacesExtensions(String cql) {
        String regex = "space\\s+in\\s+categorySpaces\\(\\s*['\"](.*?)['\"]\\s*\\)";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(cql);
        if (!matcher.find()) {
            return cql;
        }
        String spaceKeys = this.expandCategorySpacesList(matcher.group(1));
        Object expansion = BrikitString.isSet((String)spaceKeys) ? "space in (" + spaceKeys + ")" : "title = \"_ _ _\"";
        cql = cql.replaceFirst(regex, (String)expansion);
        return this.expandCategorySpacesExtensions(cql);
    }

    protected String expandCategorySpacesList(String categoriesCSV) {
        HashSet<String> spaceKeys = new HashSet<String>();
        for (Space space : Confluence.spacesWithCategories((List)BrikitString.splitCommaSeparated((String)categoriesCSV), new ArrayList(), (boolean)true)) {
            spaceKeys.add(space.getKey());
        }
        BrikitList keyList = new BrikitList(spaceKeys);
        return keyList.join(",");
    }

    protected BrikitList<String> filterGroupClasses(List<String> filterGroupNames) throws MacroExecutionException {
        BrikitList classes = new BrikitList();
        for (String filterGroupName : filterGroupNames) {
            classes.add((Object)BrikitString.classify((String)filterGroupName));
        }
        return classes;
    }

    protected void fireSearch(BrikitMacroContext macroContext, String query, int chunkSize) {
        String contextKey = macroContext.getSpace() != null ? macroContext.getSpace().getKey() : null;
        PagingCQLSearcher searcher = new PagingCQLSearcher(contextKey, macroContext.getPage(), this.searchService);
        PageResponse<Content> pageResponse = searcher.search(query, 0, chunkSize);
        if (pageResponse != null) {
            macroContext.velocityContextAdd((Object)RESULTS_KEY, searcher.convertResults());
            macroContext.velocityContextAdd((Object)"nextResult", (Object)searcher.getNextResult());
        }
    }

    public Object getAdvancedMacrosExcerpter() {
        return ContainerManager.getComponent((String)"advancedMacrosExcerpter");
    }

    protected String getOrderBy(BrikitMacroContext macroContext) {
        String key = macroContext.stringValue(SORT_PARAM, TITLE);
        String descending = "";
        if ("modified".equals(key)) {
            key = "lastModified";
            descending = DESCENDING;
        } else if ("creation".equals(key)) {
            key = "created";
            descending = DESCENDING;
        }
        if (macroContext.booleanValue(REVERSE_PARAM)) {
            descending = DESCENDING.equals(descending) ? "" : DESCENDING;
        }
        return " order by " + key + descending;
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public PageBuilderService getPageBuilderService() {
        return Confluence.getPageBuilderService();
    }

    protected BrikitMacroContext initializeMacroContext(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.hasStringValue(FILTER_GROUP_NAMES_PARAM)) {
            List filterGroupNames = macroContext.commaSeparatedListValue(FILTER_GROUP_NAMES_PARAM);
            macroContext.velocityContextAdd((Object)FILTER_GROUP_NAMES_PARAM, (Object)filterGroupNames);
            macroContext.velocityContextAdd((Object)FILTER_GROUP_CLASSES_KEY, this.filterGroupClasses(filterGroupNames));
            macroContext.velocityContextAdd((Object)FILTER_GROUPS_KEY, FilterGroup.getFilterGroupsByName(filterGroupNames));
        }
        macroContext.velocityContextAdd((Object)ORDER_BY_KEY, (Object)this.getOrderBy(macroContext));
        return macroContext;
    }

    protected void validateQuery(String cql, String explicitCql) throws MacroExecutionException {
        if (!BrikitString.isSet((String)cql) && !BrikitString.isSet((String)explicitCql)) {
            throw new MacroExecutionException("No query found");
        }
    }
}

