(function ($) { 

	TargetedSearch.InteractiveSearch = function (element) {
		this.element = $(element);
		this.initialize();
		this.debug = false;
	};
	
	Object.assign(TargetedSearch.InteractiveSearch.prototype, {

		filterAdded: function ($filter) {
			this.markFilterPicker($filter, false);
			this.searchCriteriaChanged();
		},
	
		filterPickers: function () {
			return this.find(".filter-options, .space-category-options, .content-type-options, .date-range-options");
		},
	
		filterRemoved: function ($filter, noSearchUpdate) {
			this.markFilterPicker($filter, true);
			if (!noSearchUpdate) this.searchCriteriaChanged();
		},

		find: function (selector) {
			return selector ? $(selector, this.element) : this.element;
		},

		initialize: function () {
			var self = this;
		
			this.initializing = true;
			
			this.find(".targeted-search-form").first().each(function () { self.searchForm = new TargetedSearch.SearchForm(this, self.find(".search-results-list"), self); });
			this.find(".selected-filters").first().each(function () { self.selectedFilters = new TargetedSearch.SelectedFilters(this, self.searchForm, self); });
			

			// this.find("select.select").auiSelect2().change(function (e) { self.searchCriteriaChanged(e); }.bind(this));
			this.simpleFilterRadioButtons().change(function (e) { this.simpleFilterSelectionChanged(e); }.bind(this));
			this.simpleFilterSelect().change(function (e) { this.simpleFilterSelectionChanged(e); }.bind(this));
		
            this.initializeFilterGroupPickers(this.element, this.selectedFilters);
            
			this.find(".space-category-options").on("click", "a:not(.disabled)", function (e) { this.selectedFilters.addFilterClicked(e, "space-category") }.bind(this));
			this.find(".content-type-options").on("click", "a:not(.disabled)", function (e) { this.selectedFilters.addFilterClicked(e, "content-type") }.bind(this));
			this.find(".date-range-options").on("click", "a:not(.disabled)", function (e) { this.selectedFilters.addFilterClicked(e, "date-range") }.bind(this));
			this.find("select.sort-by-select").change(this.sortByChanged.bind(this)).auiSelect2({ minimumResultsForSearch: Infinity });
		
			// Mark the pickers for the filters drawn by the macro
			this.selectedFilters.selectedFilters().each(function(i, selected) { this.markFilterPicker($(selected), false); }.bind(this));

			this.updateSearchForm();

			this.initializing = false;
					
			if (!this.find('.do-not-search-on-page-load').length) this.searchCriteriaChanged();
		
		},
        
        initializeFilterGroupPickers: function ($scope, selectedFilters) {
            // Regular dropdowns
    		$(".filter-options", $scope).on("click", "a:not(.disabled)", function (e) { selectedFilters.addFilterClicked(e, "filter") });

            // aui-select searchable dropdowns
    		$(".filter-group-picker", $scope).change(function (e) { 
                const $option = $("option:selected", e.target);
                $(this).find("input").val("");
                if (!$option.length) return;
                $option.removeAttr("selected");
                selectedFilters.addFilter($option, "filter");
            });
            
            // Make the width of the aui-select fields match the placeholder text
            $(".filter-group-picker input", $scope).each(function () { $(this).attr('size', $(this).attr('placeholder').length); });
        },
		
		markFilterPicker: function ($filter, removed) {
			$filter = $($filter);
            const filterLabel = $filter.data("id");
			if (this.debug) console.log("markFilterPicker for: " + filterLabel, $filter);
			var $picker = this.filterPickers().find("a[data-label='" + filterLabel + "'], option[value='" + filterLabel + "']");
			if (removed) $picker.removeClass("disabled").removeAttr("aria-disabled");
			else $picker.addClass("disabled").attr("aria-disabled", "true");
            
            const $filterGroupSelect = $picker.closest(".filter-group-select");
            const anyFiltersChosen = $filterGroupSelect.find("li a.disabled, option.disabled").length;
            $filterGroupSelect.adjustClass("has-selected-filter", anyFiltersChosen);
		},
		
		resultsLoaded: function (resultsData) {
			if (resultsData.error) {
				this.updateResultsStatistics(resultsData.error);
			}
			else if (resultsData.totalMatches) {
				this.updateResultsStatistics(TargetedSearch.getText("com.brikit.targetedsearch.results.total.search.results", resultsData.totalMatches, resultsData.searchTime));
			}
			else {
				this.updateResultsStatistics("<p class='no-search-results'>" + TargetedSearch.getText("com.brikit.targetedsearch.interactive.search.no.search.results.found") + "</p>");
			}
			
			return true;
		},
		
		searchCriteriaChanged: function () {
			if (this.initializing) return;
		
			this.updateSearchForm();
			
			this.updateResultsStatistics(TargetedSearch.getText("com.brikit.targetedsearch.results.searching"));
			this.searchForm.searchCriteriaChanged();
		},
		
		simpleFilterRadioButtons: function (checked) {
			return this.find(".simple-filter-list input.radio" + (checked ? ":checked" : ""));
		},
		
		simpleFilterSelect: function (selected) {
			return this.find(".simple-filter-list select" + (selected ? " option:selected" : ""));
		},
		
		simpleFilterSelectionChanged: function (event) {
			event.preventDefault();
			var $filter = this.simpleFilterRadioButtons(true);
			if (!$filter.length) $filter = this.simpleFilterSelect(true);
			this.selectedFilters.addFilter($filter, "simple-filter");
		},
		
		sortByChanged: function (e) {
			e.preventDefault();
			this.searchCriteriaChanged();
		},
		
		updateResultsStatistics: function (html) {
			this.find(".results-statistics").html(html);
		},
		
		updateSearchForm: function () {
			this.searchForm.updateSortBy(this.find(".sort-by-select:not(.select2-container)").val());
			this.selectedFilters.updateSearchFiltersFromSelections();
		}	

	});
		
	TargetedSearch.toInit(function ($) {
		$(".interactive-search").each(function () { new TargetedSearch.InteractiveSearch(this); });
	});

})(jQuery);
