/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PagingCQLSearcher {
    protected CQLSearchService searchService;
    protected String spaceKey;
    protected long pageId;
    protected int nextResult;
    protected int totalMatches;
    protected long searchTime;
    protected PageResponse<Content> response;

    public PagingCQLSearcher(String contextSpaceKey, AbstractPage contextPage, CQLSearchService searchService) {
        this.setSpaceContext(contextSpaceKey);
        if (contextPage != null) {
            this.setPageContext(contextPage.getId());
        }
        this.searchService = searchService;
    }

    public List<ContentEntityObject> convertResults() {
        ArrayList<ContentEntityObject> results = new ArrayList<ContentEntityObject>();
        for (Content result : this.getResponse().getResults()) {
            ContentEntityObject ceo = Confluence.getContentEntity((long)result.getId().asLong());
            if (ceo == null) continue;
            results.add(ceo);
        }
        return results;
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost((long)this.getPageId());
    }

    public int getNextResult() {
        return this.nextResult;
    }

    public long getPageId() {
        return this.pageId;
    }

    public List<Content> getRawResults() {
        return this.getResponse().getResults();
    }

    protected PageResponse<Content> getResponse() {
        return this.response;
    }

    protected SearchContext getSearchContext() {
        SearchContext.Builder contextBuilder = SearchContext.builder();
        if (BrikitString.isSet((String)this.getSpaceKey())) {
            contextBuilder.spaceKey(this.getSpaceKey());
        }
        if (this.getAbstractPage() != null) {
            contextBuilder.contentId(this.getAbstractPage().getContentId());
        }
        return contextBuilder.build();
    }

    public long getSearchTime() {
        return this.searchTime;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public PageResponse<Content> search(String cql, int start, int count) {
        if (!BrikitString.isSet((String)cql)) {
            cql = "created <= now('+1d')";
        }
        SimplePageRequest pageRequest = new SimplePageRequest(start, count);
        try {
            long startTime = new Date().getTime();
            this.setResponse((PageResponse<Content>)this.searchService.searchContent(cql, this.getSearchContext(), (PageRequest)pageRequest, new Expansion[0]));
            this.setSearchTime(new Date().getTime() - startTime);
            this.setNextResult(this.getResponse() != null && this.getResponse().hasMore() ? start + count : -1);
            this.setTotalMatches(this.searchService.countContent(cql, this.getSearchContext()));
        }
        catch (Exception ex) {
            BrikitLog.logDebug((String)("Failed to execute CQL query: " + ex.getMessage() + "; for query: " + cql));
        }
        return this.getResponse();
    }

    protected void setNextResult(int nextResult) {
        this.nextResult = nextResult;
    }

    public void setPageContext(long pageId) {
        this.pageId = pageId;
    }

    protected void setResponse(PageResponse<Content> response) {
        this.response = response;
    }

    public void setSearchTime(long searchTime) {
        this.searchTime = searchTime;
    }

    public void setSpaceContext(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    protected void setTotalMatches(int totalMatches) {
        this.totalMatches = totalMatches;
    }

    public int totalMatches() {
        return this.totalMatches;
    }
}

