/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.entity;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuditEvent {
    @Nonnull
    private final String action;
    @Nonnull
    private final String category;
    @Nonnull
    private final CoverageLevel level;
    @Nullable
    private final CoverageArea area;
    @Nonnull
    private final List<AuditResource> affectedObjects;
    @Nonnull
    private final List<ChangedValue> changedValues;
    @Nonnull
    private final Set<AuditAttribute> extraAttributes;

    private AuditEvent(Builder builder) {
        this.action = Objects.requireNonNull(builder.action);
        this.category = Objects.requireNonNull(builder.category);
        this.level = Objects.requireNonNull(builder.level);
        this.area = builder.area;
        this.affectedObjects = Collections.unmodifiableList(builder.affectedObjects);
        this.changedValues = Collections.unmodifiableList(builder.changedValues);
        this.extraAttributes = Collections.unmodifiableSet(builder.extraAttributes);
    }

    @Nonnull
    public String getAction() {
        return this.action;
    }

    @Nonnull
    public String getCategory() {
        return this.category;
    }

    @Nullable
    public CoverageArea getArea() {
        return this.area;
    }

    @Nonnull
    public CoverageLevel getLevel() {
        return this.level;
    }

    @Nonnull
    public List<AuditResource> getAffectedObjects() {
        return this.affectedObjects;
    }

    @Nonnull
    public List<ChangedValue> getChangedValues() {
        return this.changedValues;
    }

    @Nonnull
    public Collection<AuditAttribute> getExtraAttributes() {
        return this.extraAttributes;
    }

    public Optional<String> getExtraAttribute(@Nonnull String name) {
        return this.extraAttributes.stream().filter(a -> a.getName().equals(Objects.requireNonNull(name))).findFirst().map(AuditAttribute::getValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditEvent that = (AuditEvent)o;
        return this.action.equals(that.action) && this.category.equals(that.category) && this.level == that.level && this.area == that.area && this.affectedObjects.equals(that.affectedObjects) && this.changedValues.equals(that.changedValues) && this.extraAttributes.equals(that.extraAttributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.category, this.level, this.area, this.affectedObjects, this.changedValues, this.extraAttributes});
    }

    public String toString() {
        return "AuditEvent{action='" + this.action + '\'' + ", category='" + this.category + '\'' + ", level=" + (Object)((Object)this.level) + ", area=" + (Object)((Object)this.area) + ", affectedObjects=" + this.affectedObjects + ", changedValues=" + this.changedValues + ", extraAttributes=" + this.extraAttributes + '}';
    }

    public static Builder builder(@Nonnull String action, @Nonnull String category, @Nonnull CoverageLevel level) {
        return new Builder(action, category, level);
    }

    public static Builder builder(@Nonnull AuditType type) {
        return new Builder(type);
    }

    public static class Builder {
        @Nonnull
        private String action;
        @Nonnull
        private String category;
        @Nonnull
        private CoverageLevel level;
        @Nullable
        private CoverageArea area;
        @Nonnull
        private List<AuditResource> affectedObjects = new ArrayList<AuditResource>();
        @Nonnull
        private List<ChangedValue> changedValues = new ArrayList<ChangedValue>();
        @Nonnull
        private Set<AuditAttribute> extraAttributes = new HashSet<AuditAttribute>();

        public Builder(@Nonnull AuditType type) {
            this(type.getAction(), type.getCategory(), type.getLevel(), type.getArea());
        }

        public Builder(@Nonnull String action, @Nonnull String category, @Nonnull CoverageLevel level) {
            this(action, category, level, null);
        }

        public Builder(@Nonnull String action, @Nonnull String category, @Nonnull CoverageLevel level, @Nullable CoverageArea area) {
            Objects.requireNonNull(action, "action");
            Objects.requireNonNull(category, "category");
            Objects.requireNonNull(level, "level");
            this.action = action;
            this.category = category;
            this.level = level;
            this.area = area;
        }

        public Builder(@Nonnull AuditEvent event) {
            this.action = event.action;
            this.category = event.category;
            this.level = event.level;
            this.area = event.area;
            this.affectedObjects = new ArrayList<AuditResource>(event.affectedObjects);
            this.changedValues = new ArrayList<ChangedValue>(event.changedValues);
            this.extraAttributes = new HashSet<AuditAttribute>(event.extraAttributes);
        }

        public Builder action(@Nonnull String action) {
            this.action = Objects.requireNonNull(action);
            return this;
        }

        public Builder category(@Nonnull String category) {
            this.category = Objects.requireNonNull(category);
            return this;
        }

        public Builder level(@Nonnull CoverageLevel level) {
            this.level = Objects.requireNonNull(level);
            return this;
        }

        public Builder area(@Nonnull CoverageArea area) {
            this.area = area;
            return this;
        }

        public Builder affectedObjects(@Nonnull List<AuditResource> affectedObjects) {
            this.affectedObjects = Objects.requireNonNull(affectedObjects);
            return this;
        }

        public Builder appendAffectedObjects(@Nonnull List<AuditResource> affectedObjects) {
            this.affectedObjects.addAll((Collection<AuditResource>)Objects.requireNonNull(affectedObjects));
            return this;
        }

        public Builder affectedObject(@Nonnull AuditResource affectedObject) {
            this.affectedObjects.add(Objects.requireNonNull(affectedObject));
            return this;
        }

        public Builder changedValues(@Nonnull List<ChangedValue> changedValues) {
            this.changedValues = Objects.requireNonNull(changedValues);
            return this;
        }

        public Builder appendChangedValues(@Nonnull Collection<ChangedValue> changedValues) {
            this.changedValues.addAll(Objects.requireNonNull(changedValues));
            return this;
        }

        public Builder changedValue(@Nonnull ChangedValue changedValue) {
            this.changedValues.add(Objects.requireNonNull(changedValue));
            return this;
        }

        public Builder addChangedValueIfDifferent(@Nonnull ChangedValue changedValue) {
            if (!Objects.equals(changedValue.getFrom(), changedValue.getTo())) {
                this.changedValue(changedValue);
            }
            return this;
        }

        public Builder extraAttributes(@Nonnull Collection<AuditAttribute> extraAttributes) {
            this.extraAttributes = new HashSet<AuditAttribute>(Objects.requireNonNull(extraAttributes));
            return this;
        }

        public Builder appendExtraAttributes(@Nonnull Collection<AuditAttribute> extraAttributes) {
            this.extraAttributes.addAll(Objects.requireNonNull(extraAttributes));
            return this;
        }

        public Builder extraAttribute(@Nonnull AuditAttribute extraAttribute) {
            this.extraAttributes.add(Objects.requireNonNull(extraAttribute));
            return this;
        }

        public AuditEvent build() {
            return new AuditEvent(this);
        }
    }
}

