/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.cache;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitMobile;
import com.brikit.pinboards.model.FeedEntry;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class RenderedContentCache {
    protected static final String TILE_CACHE_DIR = "tiles";
    protected static final String CACHE_FILE_NAME = "tile.vm";
    protected static final long CACHE_TIME_LIMIT = 30L;
    protected static long resetCacheTimestamp = new Date().getTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheContent(String content, FeedEntry feedEntry) {
        BrikitLog.log((String)("Caching content for " + String.valueOf(feedEntry)));
        File cacheFile = RenderedContentCache.cacheFileLocation(feedEntry);
        String string = cacheFile.getAbsolutePath();
        synchronized (string) {
            try {
                File location = RenderedContentCache.cacheLocationWithVersion(feedEntry);
                BrikitFile.ensurePathExists((File)location);
                BrikitFile.writeFileUTF8((String)content, (File)cacheFile);
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Failed to write page content cache at " + cacheFile.getAbsolutePath()), (Exception)ex);
            }
        }
    }

    protected static File cacheLocation() {
        return new File(BrikitFile.getBrikitFile((String)"pinboard_cache"), TILE_CACHE_DIR);
    }

    protected static File cacheLocationWithContentUserKey(FeedEntry feedEntry) {
        return new File(RenderedContentCache.cacheFeedLocation(feedEntry), feedEntry.getCeo().getId() + "." + String.valueOf(feedEntry.getUserKey()));
    }

    protected static File cacheFeedLocation(FeedEntry feedEntry) {
        return new File(RenderedContentCache.cacheLocation(), feedEntry.getPinType().getName());
    }

    protected static File cacheLocationWithDeviceType(FeedEntry feedEntry) {
        return new File(RenderedContentCache.cacheLocationWithContentUserKey(feedEntry), BrikitMobile.isPhone() ? "mobile" : "desktop");
    }

    protected static File cacheFileLocation(FeedEntry feedEntry) {
        return new File(RenderedContentCache.cacheLocationWithVersion(feedEntry), CACHE_FILE_NAME);
    }

    protected static File cacheLocationWithVersion(FeedEntry feedEntry) {
        ConfluenceEntityObject ceo = feedEntry.getCeo();
        int version = ceo instanceof AbstractPage && Confluence.canEdit((AbstractPage)((AbstractPage)ceo)) ? ((AbstractPage)ceo).getVersion() : 0;
        return new File(RenderedContentCache.cacheLocationWithDeviceType(feedEntry), Integer.toString(version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cachedContent(FeedEntry feedEntry) {
        File cacheFile = RenderedContentCache.cacheFileLocation(feedEntry);
        String string = cacheFile.getAbsolutePath();
        synchronized (string) {
            try {
                if (!cacheFile.exists()) {
                    return null;
                }
                RenderedContentCache.checkCacheExpirationIgnoringSynchronization(cacheFile);
                if (cacheFile.exists()) {
                    return BrikitFile.readFileUTF8((File)cacheFile);
                }
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Failed to read cached page content at " + cacheFile.getAbsolutePath()), (Exception)ex);
            }
        }
        return null;
    }

    protected static void checkCacheExpirationIgnoringSynchronization(File cacheFile) {
        if (cacheFile.lastModified() < RenderedContentCache.getResetCacheTimestamp()) {
            BrikitFile.removeFile((File)cacheFile);
            return;
        }
        long minutesOld = (new Date().getTime() - cacheFile.lastModified()) / 60000L;
        if (minutesOld > 30L) {
            BrikitFile.removeFile((File)cacheFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanCache(File cacheFile) {
        if (cacheFile.getName().equals(".") || cacheFile.getName().equals("..")) {
            return;
        }
        if (cacheFile.isDirectory()) {
            for (File file : cacheFile.listFiles()) {
                RenderedContentCache.cleanCache(file);
            }
            if (cacheFile.listFiles().length == 0) {
                cacheFile.delete();
            }
        } else if (cacheFile.getAbsolutePath().endsWith(CACHE_FILE_NAME)) {
            String string = cacheFile.getAbsolutePath();
            synchronized (string) {
                RenderedContentCache.checkCacheExpirationIgnoringSynchronization(cacheFile);
            }
        }
    }

    public static void cleanCache() {
        RenderedContentCache.cleanCache(RenderedContentCache.cacheLocation());
    }

    protected static synchronized long getResetCacheTimestamp() {
        return resetCacheTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromCache(FeedEntry feedEntry) {
        BrikitLog.log((String)("Clearing cached content for " + String.valueOf(feedEntry)));
        File cacheFile = RenderedContentCache.cacheFileLocation(feedEntry);
        String string = cacheFile.getAbsolutePath();
        synchronized (string) {
            BrikitFile.removeFile((File)RenderedContentCache.cacheLocationWithContentUserKey(feedEntry));
        }
    }

    public static synchronized void resetCache() {
        resetCacheTimestamp = new Date().getTime();
    }
}

