/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.TimeZone;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CalendarRange {
    protected Calendar start;
    protected Calendar end;

    public CalendarRange(Calendar start, Calendar end) {
        if (start.after(end)) {
            this.setStart(end);
            this.setEnd(start);
        } else {
            this.setStart(start);
            this.setEnd(end);
        }
    }

    public CalendarRange(Calendar start, int unit, int count) {
        this.setStart(start);
        Calendar end = (Calendar)start.clone();
        end.add(unit, count);
        this.setEnd(end);
    }

    public CalendarRange(String unit, int offset, int duration) {
        this(unit, offset, duration, Confluence.getSystemTimeZone());
    }

    public CalendarRange(String unit, int offset, int duration, TimeZone timeZone) {
        int calUnit = 5;
        Calendar start = BrikitDate.getToday(timeZone);
        if (unit.equals("week")) {
            calUnit = 3;
            start = BrikitDate.getFirstDayOfThisWeek(timeZone);
        } else if (unit.equals("month")) {
            calUnit = 2;
            start = BrikitDate.getFirstDayOfThisMonth(timeZone);
        }
        start.add(calUnit, offset);
        this.setStart(start);
        Calendar end = (Calendar)start.clone();
        end.add(calUnit, duration);
        this.setEnd(end);
    }

    public boolean contains(Calendar aCalendar) {
        return !aCalendar.before(this.getStart()) && !aCalendar.after(this.getEnd());
    }

    public boolean contains(Date aDate) {
        return this.contains(BrikitDate.toCalendar(aDate));
    }

    public boolean contains(ContentEntityObject entity) {
        return this.contains(entity.getCreationDate());
    }

    public void convert(TimeZone timeZone) {
        this.start = BrikitDate.convert(this.getStart(), timeZone);
        this.end = BrikitDate.convert(this.getEnd(), timeZone);
    }

    public void convertToSystemTimezone() {
        this.convert(Confluence.getSystemTimeZone());
    }

    public void convertToUserTimezone() {
        this.convert(Confluence.getUserTimeZone());
    }

    public List filter(List<ContentEntityObject> entities) {
        ArrayList<ContentEntityObject> results = new ArrayList<ContentEntityObject>();
        for (ContentEntityObject entity : entities) {
            if (!this.contains(entity)) continue;
            results.add(entity);
        }
        return results;
    }

    public static String formatDateRange(CalendarRange calendarRange, TimeZone timeZone) {
        StringBuilder builder = new StringBuilder();
        builder.append(BrikitDate.formatDateOnly(calendarRange.getStartTime(), timeZone));
        if (!calendarRange.getStartDate().equals(calendarRange.getEndDate())) {
            builder.append(" - ");
            builder.append(BrikitDate.formatDateOnly(calendarRange.getEndTime(), timeZone));
        }
        builder.append(" ").append(BrikitDate.formatShortTimeZone(timeZone));
        return builder.toString();
    }

    public static String formatDateTimeRange(CalendarRange calendarRange, TimeZone timeZone) {
        StringBuilder builder = new StringBuilder();
        builder.append(BrikitDate.formatDateTime(calendarRange.getStart(), timeZone, true));
        if (!calendarRange.getStart().equals(calendarRange.getEnd())) {
            builder.append(" - ");
            if (calendarRange.getStartDate().equals(calendarRange.getEndDate())) {
                builder.append(BrikitDate.formatTime(calendarRange.getEndTime(), timeZone, true));
            } else {
                builder.append(BrikitDate.formatDateTime(calendarRange.getEnd(), timeZone, true));
            }
        }
        builder.append(" ").append(BrikitDate.formatShortTimeZone(timeZone));
        return builder.toString();
    }

    public Calendar getDayAfter() {
        Calendar calendar = (Calendar)this.getEnd().clone();
        calendar.add(5, 1);
        return calendar;
    }

    public Calendar getDayBefore() {
        Calendar calendar = (Calendar)this.getStart().clone();
        calendar.add(5, -1);
        return calendar;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public Calendar getEndDate() {
        return BrikitDate.dateOnly(this.getEnd());
    }

    public Date getEndTime() {
        return this.getEnd().getTime();
    }

    public static CalendarRange getMonthRange(Calendar aCalendar) {
        return new CalendarRange(BrikitDate.getFirstDayOfMonth(aCalendar), BrikitDate.getEndOfDay(BrikitDate.getLastDayOfMonth(aCalendar)));
    }

    public static CalendarRange getMonthRange(int year, int month) {
        return CalendarRange.getMonthRange(BrikitDate.getFirstDayOfMonth(year, month));
    }

    public Calendar getStart() {
        return this.start;
    }

    public Calendar getStartDate() {
        return BrikitDate.dateOnly(this.getStart());
    }

    public Date getStartTime() {
        return this.getStart().getTime();
    }

    public static CalendarRange getWeekRange(Calendar aCalendar) {
        return new CalendarRange(BrikitDate.getFirstDayOfWeek(aCalendar), BrikitDate.getLastDayOfWeek(aCalendar));
    }

    public boolean overlaps(CalendarRange calendarRange) {
        return this.contains(calendarRange.getStart()) || this.contains(calendarRange.getEnd()) || calendarRange.contains(this.getStart()) || calendarRange.contains(this.getEnd());
    }

    public void setEnd(Calendar end) {
        this.end = (Calendar)end.clone();
    }

    public void setStart(Calendar start) {
        this.start = (Calendar)start.clone();
    }

    public String toString() {
        return CalendarRange.formatDateTimeRange(this, Confluence.getSystemTimeZone());
    }
}

