/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.lesson.model;

import com.brikit.core.util.BrikitList;
import com.brikit.themepress.lesson.model.Lesson;
import com.brikit.themepress.lesson.model.LessonProperties;
import java.util.ArrayList;
import java.util.List;

public class LessonPlan {
    protected String name;
    protected String title;
    protected Lesson currentLesson;
    protected List<Lesson> lessons;
    protected boolean finished;

    public LessonPlan(String name) {
        this.setName(name);
    }

    public void advance() {
        if (this.hasNext()) {
            this.setCurrentLesson(this.peekAhead());
        } else {
            this.finish();
        }
    }

    public Lesson findLesson(String lessonName) {
        for (Lesson lesson : this.getLessons()) {
            if (!lesson.getLessonName().equals(lessonName)) continue;
            return lesson;
        }
        return null;
    }

    public void finish() {
        this.setFinished(true);
        this.setCurrentLesson((Lesson)null);
    }

    public Lesson getCurrentLesson() {
        return this.currentLesson;
    }

    public void setCurrentLesson(String lessonName) {
        this.setCurrentLesson(this.findLesson(lessonName));
    }

    public int getLength() {
        return this.getLessons().size();
    }

    public List<Lesson> getLessons() {
        return this.lessons;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
        this.initLessons();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean hasLessons() {
        return !this.getLessons().isEmpty();
    }

    public boolean hasNext() {
        return !this.isFinished() && this.getLength() > this.indexOfNextStep() && !this.onLast();
    }

    public boolean hasPrevious() {
        return !this.onFirst();
    }

    public int indexOfNextStep() {
        return this.getLessons().indexOf(this.getCurrentLesson()) + 1;
    }

    public int indexOfPreviousStep() {
        return Math.max(0, this.getLessons().indexOf(this.getCurrentLesson()) - 1);
    }

    public void initLessons() {
        this.lessons = new ArrayList<Lesson>();
        LessonProperties properties = new LessonProperties(this.getName());
        this.setTitle(properties.getLessonPlanTitle());
        for (String lessonName : properties.getLessonNames()) {
            Lesson lesson = new Lesson(lessonName, properties.getSelector(lessonName), properties.getSelectorNotFoundMessage(lessonName), properties.getTitle(lessonName), properties.getBody(lessonName), properties.getWidth(lessonName), properties.getOffsetX(lessonName), properties.getOffsetY(lessonName), properties.getArrowOffsetX(lessonName), properties.getError(lessonName), properties.getWarning(lessonName), properties.getSuccess(lessonName), properties.getHint(lessonName), properties.getHeader(lessonName), properties.getEditBlocks(lessonName), properties.getDesignerMode(lessonName), properties.getDesignerAccordion(lessonName), properties.getDesignerFieldset(lessonName), properties.getClickElement(lessonName));
            this.lessons.add(lesson);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean onFirst() {
        return new BrikitList(this.getLessons()).isFirst((Object)this.getCurrentLesson());
    }

    public boolean onLast() {
        return new BrikitList(this.getLessons()).isLast((Object)this.getCurrentLesson());
    }

    public Lesson peekAhead() {
        return this.getLessons().get(this.indexOfNextStep());
    }

    public Lesson peekBack() {
        return this.getLessons().get(this.indexOfPreviousStep());
    }

    public void reverse() {
        if (this.hasPrevious()) {
            this.setCurrentLesson(this.peekBack());
        }
    }

    public void setCurrentLesson(Lesson currentLesson) {
        this.currentLesson = currentLesson;
    }
}

