/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.servlet;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.renderer.util.FileTypeUtil;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.icons.IconLibrary;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.ThemeCssCache;
import com.brikit.themepress.settings.ThemeJavaScriptCache;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.support.PluginResourceDownloadStrategy;
import com.brikit.themepress.support.ResourceDownloadStrategy;
import com.brikit.themepress.toolkit.macros.LibraryIconMacro;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@AnonymousSiteAccess
public class BrikitServlet
extends HttpServlet {
    public static final String CSS_BUNDLE_FILE_NAME = "/combined.css";
    public static final String JS_BUNDLE_FILE_NAME = "/combined.js";
    public static final String SPACE_KEY_PARAMETER = "spaceKey";
    public static final String PAGE_ID_PARAMETER = "pageId";
    public static final String CONTEXT_KEY = "context";
    public static final String CONTEXT_PATH_KEY = "contextPath";
    public static final long ONE_YEAR_IN_MILLISECONDS = 31536000000L;
    protected static final String SKIP_PARAM = "_";
    protected static final String NO_RENDER_SERVLET_PATH = "/brikitservlet/";
    public static final String RAW_ICON_LIBRARY_SERVLET_PATH = "/brikitservlet/library/icons/";
    public static final String THEMED_ICON_LIBRARY_SERVLET_PATH = "/brikitservlet/library/icons/themed/";
    protected static final String NO_RENDER_THEME_PLUGIN_SERVLET_PATH = "/brikitservlet/designs/themes/";
    protected static final String CSS_BUNDLE_PATH = "/cssbundle/";
    protected static final String JS_BUNDLE_PATH = "/jsbundle/";

    public static float floatValue(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException var2) {
            return 0.0f;
        }
    }

    protected static String getRequestedFilename(HttpServletRequest aRequest) throws IOException {
        String path = aRequest.getPathInfo();
        String filename = path.substring(1);
        if (filename.startsWith("brikitservlet/")) {
            filename = filename.substring(14);
        }
        return Confluence.urlDecode((String)filename);
    }

    protected static int validateRequest(HttpServletRequest aRequest) throws IOException {
        String requestedPath;
        String actualPath;
        String path = aRequest.getPathInfo();
        String filename = path.substring(1);
        if (filename.startsWith("brikitservlet/")) {
            filename = filename.substring(14);
        }
        if (!(actualPath = new File(Confluence.urlDecode((String)filename)).getCanonicalPath().replace('\\', '/')).endsWith(requestedPath = Confluence.urlDecode((String)filename).replace('\\', '/'))) {
            BrikitLog.logWarning((String)("Not a valid requested file in " + aRequest.getRequestURL()));
            return 405;
        }
        if (filename.length() == 0) {
            BrikitLog.logWarning((String)("No file was requested in " + aRequest.getRequestURL()));
            return 405;
        }
        return 202;
    }

    protected String contentType(HttpServletRequest aRequest, String filename) {
        String type = aRequest.getContentType();
        if (BrikitString.isSet((String)type)) {
            return type;
        }
        if (!BrikitString.isSet((String)filename)) {
            return "text/plain";
        }
        if (filename.endsWith(".js")) {
            return "text/javascript";
        }
        if (filename.endsWith(".css")) {
            return "text/css";
        }
        if (filename.endsWith(".png")) {
            return "image/png";
        }
        if (filename.endsWith(".jpg") || filename.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (filename.endsWith(".gif")) {
            return "image/gif";
        }
        if (filename.endsWith(".bmp")) {
            return "image/bmp";
        }
        if (filename.endsWith(".tif") || filename.endsWith(".tiff")) {
            return "image/tiff";
        }
        return "application/octet-stream";
    }

    protected String cssBundleName(HttpServletRequest aRequest) {
        if (!this.isCssBundle(aRequest)) {
            return null;
        }
        return aRequest.getPathInfo().substring(CSS_BUNDLE_PATH.length());
    }

    protected void doGet(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        if (BrikitServlet.validateRequest(aRequest) != 202) {
            aResponse.sendError(405);
        } else {
            try {
                aResponse.setContentType(FileTypeUtil.getContentType((String)aRequest.getPathInfo()));
                if (!(this.serveThemePluginResource(aRequest, aResponse) || this.serveThemedLibraryIcon(aRequest, aResponse) || this.serveLibraryIcon(aRequest, aResponse))) {
                    if (this.isNoRender(aRequest)) {
                        this.serveWithoutRendering(aRequest, aResponse);
                    } else if (this.isCssBundle(aRequest)) {
                        this.serveCssBundle(aRequest, aResponse);
                    } else if (this.isJavascriptBundle(aRequest)) {
                        this.serveJavascriptBundle(aRequest, aResponse);
                    }
                }
            }
            catch (IOException anException) {
                aResponse.resetBuffer();
                aResponse.sendError(500, anException.toString());
            }
        }
        aResponse.flushBuffer();
    }

    public long getLastModified(HttpServletRequest aRequest) {
        if (!this.isNoRender(aRequest)) {
            return super.getLastModified(aRequest);
        }
        if (this.isPluginResourceRequest(aRequest)) {
            return ThemeResourceServlet.getZenPluginLoaded().getTime();
        }
        try {
            return this.requestedFile(aRequest).lastModified();
        }
        catch (IOException e) {
            BrikitLog.logError((String)("Couldn't access timestamp for resource: " + aRequest.getPathInfo()), (Exception)e);
            return super.getLastModified(aRequest);
        }
    }

    protected boolean isCssBundle(HttpServletRequest aRequest) {
        return aRequest.getPathInfo().startsWith(CSS_BUNDLE_PATH);
    }

    protected boolean isJavascriptBundle(HttpServletRequest aRequest) {
        return aRequest.getPathInfo().startsWith(JS_BUNDLE_PATH);
    }

    protected boolean isNoRender(HttpServletRequest aRequest) {
        return aRequest.getPathInfo().startsWith(NO_RENDER_SERVLET_PATH);
    }

    protected boolean isPluginResourceRequest(HttpServletRequest aRequest) {
        return !ExternalDevelopmentMode.isDeveloperMode() && !aRequest.getPathInfo().startsWith(NO_RENDER_THEME_PLUGIN_SERVLET_PATH);
    }

    protected String javascriptBundleName(HttpServletRequest aRequest) {
        if (!this.isJavascriptBundle(aRequest)) {
            return null;
        }
        return aRequest.getPathInfo().substring(JS_BUNDLE_PATH.length());
    }

    protected File requestedFile(HttpServletRequest aRequest) throws IOException {
        return new File(ThemeResourceServlet.getServerFileLocation((String)BrikitServlet.getRequestedFilename(aRequest)));
    }

    protected File requestedPluginFile(HttpServletRequest aRequest) throws IOException {
        return new File(ThemeResourceServlet.getPluginResource((String)BrikitServlet.getRequestedFilename(aRequest)));
    }

    protected void serveCssBundle(HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        String bundleName = this.cssBundleName(aRequest);
        String css = ThemeCssCache.getCSS(bundleName);
        aResponse.setHeader("Content-Length", Long.toString(css.length()));
        this.setDistantExpiration(aResponse);
        aResponse.getWriter().print(css);
        aResponse.getWriter().flush();
    }

    protected void serveJavascriptBundle(HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        String bundleName = this.javascriptBundleName(aRequest);
        String javascript = ThemeJavaScriptCache.getJavaScript(bundleName);
        aResponse.setHeader("Content-Length", Long.toString(javascript.length()));
        this.setDistantExpiration(aResponse);
        aResponse.getWriter().print(javascript);
        aResponse.getWriter().flush();
    }

    protected boolean serveLibraryIcon(HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        float borderWidth;
        String borderColorKey;
        String fieldColorKey;
        String imageColorKey;
        Pattern pattern = Pattern.compile("/brikitservlet/library/icons/(.*)");
        Matcher matcher = pattern.matcher(aRequest.getPathInfo());
        if (!matcher.find()) {
            return false;
        }
        BrikitList bits = BrikitString.split((String)matcher.group(1), (String)"/");
        if (bits.isEmpty()) {
            return false;
        }
        String themeName = Confluence.urlDecode((String)((String)bits.remove(0)));
        if (!ThemePlugin.isPlugin(themeName)) {
            return false;
        }
        String iconName = bits.isEmpty() ? "___unspecified_library_icon___" : Confluence.urlDecode((String)((String)bits.remove(0)));
        String string = imageColorKey = bits.isEmpty() ? SKIP_PARAM : Confluence.urlDecode((String)((String)bits.remove(0)));
        if (SKIP_PARAM.equals(imageColorKey)) {
            imageColorKey = "primaryColor";
        }
        int iconSize = bits.isEmpty() ? 0 : BrikitNumber.integerValue((String)Confluence.urlDecode((String)((String)bits.remove(0))));
        int imageSize = bits.isEmpty() ? 0 : BrikitNumber.integerValue((String)Confluence.urlDecode((String)((String)bits.remove(0))));
        String string2 = fieldColorKey = bits.isEmpty() ? SKIP_PARAM : Confluence.urlDecode((String)((String)bits.remove(0)));
        if (SKIP_PARAM.equals(fieldColorKey)) {
            fieldColorKey = "transparent";
        }
        int fieldSize = bits.isEmpty() ? 0 : BrikitNumber.integerValue((String)Confluence.urlDecode((String)((String)bits.remove(0))));
        int fieldRadius = bits.isEmpty() ? 0 : BrikitNumber.integerValue((String)Confluence.urlDecode((String)((String)bits.remove(0))));
        String string3 = borderColorKey = bits.isEmpty() ? SKIP_PARAM : Confluence.urlDecode((String)((String)bits.remove(0)));
        if (SKIP_PARAM.equals(borderColorKey)) {
            borderColorKey = "transparent";
        }
        float f = borderWidth = bits.isEmpty() ? 0.0f : BrikitServlet.floatValue(Confluence.urlDecode((String)((String)bits.remove(0))));
        if (imageSize == 0) {
            imageSize = (int)Math.round(0.8 * (double)Math.max(iconSize, fieldSize));
        }
        File iconFile = IconLibrary.getIcon(themeName, iconName, imageColorKey, iconSize, imageSize, fieldColorKey, fieldSize, fieldRadius, borderColorKey, borderWidth);
        aResponse.setContentType(FileTypeUtil.getContentType((File)iconFile));
        this.serveWithoutRendering(iconFile, aRequest, aResponse);
        return true;
    }

    protected void servePluginResourceWithoutRendering(File requestedResource, HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        PluginResourceDownloadStrategy strategy = new PluginResourceDownloadStrategy(requestedResource);
        this.writeToResponse(strategy.getStreamForDownload(), aRequest, aResponse, requestedResource.getName());
    }

    protected boolean serveThemePluginResource(HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            return false;
        }
        Pattern pattern = Pattern.compile("/brikitservlet/designs/themes/([^/]+)/(.*)");
        Matcher matcher = pattern.matcher(aRequest.getPathInfo());
        if (!matcher.find()) {
            return false;
        }
        String themeName = Confluence.urlDecode((String)matcher.group(1));
        if (!ThemePlugin.isPlugin(themeName)) {
            return false;
        }
        ThemePlugin plugin = ThemePlugin.getPlugin(themeName);
        String requestedPath = Confluence.urlDecode((String)matcher.group(2));
        File absolutePath = plugin.absolutePath(requestedPath);
        this.serveWithoutRendering(absolutePath, aRequest, aResponse);
        return true;
    }

    protected boolean serveThemedLibraryIcon(HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        String borderColorKey;
        String fieldColorKey;
        String imageColorKey;
        String iconSizeName;
        Pattern pattern = Pattern.compile("/brikitservlet/library/icons/themed/(.*)");
        Matcher matcher = pattern.matcher(aRequest.getPathInfo());
        if (!matcher.find()) {
            return false;
        }
        BrikitList bits = BrikitString.split((String)matcher.group(1), (String)"/");
        if (bits.isEmpty()) {
            return false;
        }
        String spaceKey = Confluence.urlDecode((String)((String)bits.remove(0)));
        String themeName = BrikitThemeSettings.getThemeName(spaceKey);
        if (!ThemePlugin.isInstalled(themeName)) {
            return false;
        }
        String iconName = bits.isEmpty() ? "___unspecified_library_icon___" : Confluence.urlDecode((String)((String)bits.remove(0)));
        String string = iconSizeName = bits.isEmpty() ? SKIP_PARAM : Confluence.urlDecode((String)((String)bits.remove(0)));
        if (SKIP_PARAM.equals(iconSizeName)) {
            iconSizeName = IconLibrary.defaultIconSize(iconName);
        }
        String string2 = imageColorKey = bits.isEmpty() ? SKIP_PARAM : Confluence.urlDecode((String)((String)bits.remove(0)));
        if (SKIP_PARAM.equals(imageColorKey)) {
            imageColorKey = "primaryColor";
        }
        String string3 = fieldColorKey = bits.isEmpty() ? null : Confluence.urlDecode((String)((String)bits.remove(0)));
        if (SKIP_PARAM.equals(fieldColorKey)) {
            fieldColorKey = null;
        }
        String string4 = borderColorKey = bits.isEmpty() ? null : Confluence.urlDecode((String)((String)bits.remove(0)));
        if (SKIP_PARAM.equals(borderColorKey)) {
            borderColorKey = null;
        }
        int iconSize = LibraryIconMacro.iconSizes.get(iconSizeName);
        boolean hasBorder = BrikitString.isSet((String)borderColorKey) && !"transparent".equals(borderColorKey);
        boolean hasField = BrikitString.isSet((String)fieldColorKey) && !"transparent".equals(fieldColorKey);
        int fieldSize = hasBorder || hasField ? (int)Math.round(0.8 * (double)iconSize) : iconSize;
        int imageSize = (int)Math.round(0.8 * (double)Math.min(iconSize, fieldSize));
        int fieldRadius = fieldSize;
        float borderWidth = LibraryIconMacro.borderSizes.get(iconSizeName).floatValue();
        File iconFile = IconLibrary.getIcon(themeName, iconName, imageColorKey, iconSize, imageSize, fieldColorKey, fieldSize, fieldRadius, borderColorKey, borderWidth);
        aResponse.setContentType(FileTypeUtil.getContentType((File)iconFile));
        this.serveWithoutRendering(iconFile, aRequest, aResponse);
        return true;
    }

    protected void serveWithoutRendering(File requestedResource, HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        if (!requestedResource.exists() || requestedResource.isDirectory()) {
            aResponse.sendError(404, "The file you were looking for was not found");
            return;
        }
        ResourceDownloadStrategy strategy = new ResourceDownloadStrategy(requestedResource);
        this.writeToResponse(strategy.getStreamForDownload(), aRequest, aResponse, requestedResource.getName());
    }

    protected void serveWithoutRendering(HttpServletRequest aRequest, HttpServletResponse aResponse) throws IOException {
        if (this.isPluginResourceRequest(aRequest)) {
            this.servePluginResourceWithoutRendering(this.requestedPluginFile(aRequest), aRequest, aResponse);
        } else {
            this.serveWithoutRendering(this.requestedFile(aRequest), aRequest, aResponse);
        }
    }

    protected void setDistantExpiration(HttpServletResponse aResponse) {
        aResponse.setDateHeader("Expires", System.currentTimeMillis() + 31536000000L);
        aResponse.setHeader("Cache-Control", "max-age=31536000000");
    }

    protected void writeToResponse(InputStream inputStream, HttpServletRequest aRequest, HttpServletResponse aResponse, String filename) throws IOException {
        byte[] bytes = new byte[1024];
        ServletOutputStream outputStream = aResponse.getOutputStream();
        try {
            int count;
            while ((count = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, count);
            }
            inputStream.close();
            aResponse.setContentType(this.contentType(aRequest, filename));
            this.setDistantExpiration(aResponse);
        }
        catch (Exception ex) {
            outputStream.write(("Failed to serve file: " + filename + ". " + ex.getMessage()).getBytes());
            aResponse.setContentType("text/plain");
        }
    }
}

