/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.themepress.designer.PageDesignRestrictions;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class RestrictPageDesignsAction
extends AbstractSpaceAction {
    protected String restrictPages;
    protected List<String> pageLayouts;
    protected List<String> pageFrames;

    public String execute() {
        this.restrictPages = PageDesignRestrictions.restrictPageDesigns(this.getSpace()) ? "on" : null;
        this.pageFrames = PageDesignRestrictions.pageFrameRestrictionList(this.getSpace());
        this.pageLayouts = PageDesignRestrictions.pageLayoutRestrictionList(this.getSpace());
        return "success";
    }

    public List<String> getPageFrames() {
        return this.pageFrames;
    }

    public List<String> getPageLayouts() {
        return this.pageLayouts;
    }

    public String getRestrictPages() {
        return this.restrictPages;
    }

    public String save() {
        PageDesignRestrictions.saveRestrictPageDesigns(this.getSpace(), BrikitBoolean.booleanValue((String)this.getRestrictPages()));
        PageDesignRestrictions.savePageLayoutRestrictionList(this.getSpace(), this.getPageLayouts());
        PageDesignRestrictions.savePageFrameRestrictionList(this.getSpace(), this.getPageFrames());
        return "success";
    }

    @StrutsParameter
    public void setPageFrames(List<String> pageFrames) {
        this.pageFrames = pageFrames;
    }

    @StrutsParameter
    public void setPageLayouts(List<String> pageLayouts) {
        this.pageLayouts = pageLayouts;
    }

    @StrutsParameter
    public void setRestrictPages(String restrictPages) {
        this.restrictPages = restrictPages;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator() && !Confluence.canAdministerSpace((Space)this.getSpace())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

