/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.topictree.actions;

import com.atlassian.confluence.json.json.Json;
import com.atlassian.confluence.json.json.JsonArray;
import com.atlassian.confluence.json.json.JsonObject;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldNames;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.search.ContentSearch;
import com.brikit.core.util.BrikitLabel;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LoadTopicTreeAction
extends ThemePressActionSupport {
    protected int skipResults;
    protected int maxResultsPerLabel;
    protected String label;
    protected String labels;
    protected String labelNames;
    protected String expandTopic;
    protected String order;
    protected boolean includePages;
    protected boolean includeBlogposts;
    protected boolean includeFiles;
    protected String spaceFilter;
    protected String spaceKeysOrCategories;

    public String getExpandTopic() {
        return this.expandTopic;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelNames() {
        return this.labelNames;
    }

    public String getLabels() {
        return this.labels;
    }

    public int getMaxResultsPerLabel() {
        return this.maxResultsPerLabel;
    }

    public String getOrder() {
        return this.order;
    }

    public int getSkipResults() {
        return this.skipResults;
    }

    public String getSpaceFilter() {
        return this.spaceFilter;
    }

    public String getSpaceKeysOrCategories() {
        return this.spaceKeysOrCategories;
    }

    public boolean isIncludeBlogposts() {
        return this.includeBlogposts;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public boolean isIncludePages() {
        return this.includePages;
    }

    public String execute() throws Exception {
        SearchResults searchResults;
        try {
            ArrayList<ContentTypeEnum> contentTypes = new ArrayList<ContentTypeEnum>();
            if (this.isIncludePages()) {
                contentTypes.add(ContentTypeEnum.PAGE);
            }
            if (this.isIncludeBlogposts()) {
                contentTypes.add(ContentTypeEnum.BLOG);
            }
            if (this.isIncludeFiles()) {
                contentTypes.add(ContentTypeEnum.ATTACHMENT);
            }
            searchResults = ContentSearch.searchByDateAndLabel(this.getFieldsToFetch(), (SpaceCategoryQuery)ContentSearch.spaceCategoryQuery((String)this.getSpaceFilter()), (InSpaceQuery)ContentSearch.inSpaceQuery((String)this.getSpaceFilter(), (List)BrikitString.splitCommaSeparated((String)this.getSpaceKeysOrCategories()), (String)this.getSpaceKey()), (ContentTypeQuery)ContentSearch.contentTypeQuery(contentTypes), null, (SearchQuery)ContentSearch.labelQuery((String)BrikitLabel.labelize((String)this.getLabel())), null, null, (SearchSort)ContentSearch.searchSort((String)this.getOrder()));
        }
        catch (InvalidSearchException ise) {
            this.addActionError(Confluence.getText((String)"contentbylabel.error.run-search"), new Object[]{ise});
            this.setJSONError(Confluence.getText((String)"contentbylabel.error.run-search"));
            return "error";
        }
        JsonObject json = new JsonObject();
        json.setProperty("result", (Json)this.jsonSearchResults(searchResults));
        json.setProperty("success", "true");
        this.setResult(json.serialize());
        return "success";
    }

    protected Set<String> getFieldsToFetch() {
        HashSet<String> fields = new HashSet<String>(SearchFieldNames.withDefaultValues());
        fields.add("title");
        fields.add("urlPath");
        fields.add("space-name");
        fields.add("created");
        fields.add("creatorName");
        return fields;
    }

    protected JsonArray jsonSearchResults(SearchResults searchResults) {
        JsonArray jsonResults = new JsonArray();
        int count = 0;
        for (SearchResult result : searchResults) {
            if (this.getMaxResultsPerLabel() == 0 || count < this.getMaxResultsPerLabel()) {
                String name = Confluence.getText((String)"com.brikit.themepress.topic-tree.anonymous");
                String fullName = Confluence.getText((String)"com.brikit.themepress.topic-tree.anonymous");
                if (result.getCreatorUser() != null) {
                    name = result.getCreatorUser().getName();
                    fullName = result.getCreatorUser().getFullName();
                }
                JsonObject jsonResult = new JsonObject().setProperty("title", result.getDisplayTitle()).setProperty("spaceName", result.getSpaceName()).setProperty("label", this.label).setProperty("createDate", result.getCreationDate()).setProperty("creatorUsername", name).setProperty("creatorFullName", fullName).setProperty("url", Confluence.getContextPath() + result.getUrlPath());
                jsonResults.add((Json)jsonResult);
            } else {
                JsonObject jsonResult = new JsonObject().setProperty("title", "More...").setProperty("skipResults", (Number)(this.getMaxResultsPerLabel() + this.skipResults)).setProperty("label", this.label).setProperty("url", Confluence.getContextPath() + "/plugins/brikit/topictree/loadcontent.action");
                jsonResults.add((Json)jsonResult);
            }
            ++count;
        }
        return jsonResults;
    }

    public void setExpandTopic(String expandTopic) {
        this.expandTopic = expandTopic;
    }

    public void setIncludeBlogposts(boolean includeBlogposts) {
        this.includeBlogposts = includeBlogposts;
    }

    public void setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
    }

    public void setIncludePages(boolean includePages) {
        this.includePages = includePages;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabelNames(String labelNames) {
        this.labelNames = labelNames;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public void setMaxResultsPerLabel(int maxResultsPerLabel) {
        this.maxResultsPerLabel = maxResultsPerLabel;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setSkipResults(int skipResults) {
        this.skipResults = skipResults;
    }

    public void setSpaceFilter(String spaceFilter) {
        this.spaceFilter = spaceFilter;
    }

    public void setSpaceKeysOrCategories(String spaceKeysOrCategories) {
        this.spaceKeysOrCategories = spaceKeysOrCategories;
    }
}

